/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3CopyFeature;
import ch.cyberduck.core.s3.S3MultipartCopyFeature;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.transfer.TransferStatus;

public class S3ThresholdCopyFeature
extends S3CopyFeature {
    private final Preferences preferences = PreferencesFactory.get();
    private final S3Session session;
    private final S3AccessControlListFeature accessControlListFeature;
    private final Long multipartThreshold = this.preferences.getLong("s3.upload.multipart.required.threshold");

    public S3ThresholdCopyFeature(S3Session session) {
        this(session, new S3AccessControlListFeature(session));
    }

    public S3ThresholdCopyFeature(S3Session session, S3AccessControlListFeature accessControlListFeature) {
        super(session, accessControlListFeature);
        this.session = session;
        this.accessControlListFeature = accessControlListFeature;
    }

    @Override
    public Path copy(Path source, Path copy, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        if (status.getLength() > this.multipartThreshold) {
            return new S3MultipartCopyFeature(this.session, this.accessControlListFeature).copy(source, copy, status, callback);
        }
        return new S3CopyFeature(this.session, this.accessControlListFeature).copy(source, copy, status, callback);
    }
}

