/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.ssl.ThreadLocalHostnameDelegatingTrustManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class S3BucketHostnameTrustManager
extends ThreadLocalHostnameDelegatingTrustManager {
    private static final Logger log = Logger.getLogger(S3BucketHostnameTrustManager.class);
    private final Pattern pattern = Pattern.compile("([a-z0-9.-]+\\.)([a-z0-9.-]+\\.s3(\\.dualstack)?(\\.[a-z0-9-]+)?.amazonaws.com)");
    private final Preferences preferences = PreferencesFactory.get();

    public S3BucketHostnameTrustManager(X509TrustManager delegate, String hostname) {
        super(delegate, hostname);
    }

    public String getTarget() {
        String hostname = super.getTarget();
        Matcher matcher = this.pattern.matcher(hostname);
        if (matcher.matches()) {
            String simple = matcher.group(2);
            log.warn((Object)String.format("Rewrite hostname target to %s", simple));
            return simple;
        }
        return hostname;
    }
}

