/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.kms;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostUrlProvider;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.auth.AWSCredentialsConfigurator;
import ch.cyberduck.core.aws.AmazonServiceExceptionMappingService;
import ch.cyberduck.core.aws.CustomClientConfiguration;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3EncryptionFeature;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.ssl.ThreadLocalHostnameDelegatingTrustManager;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.AWSKMSClientBuilder;
import com.amazonaws.services.kms.model.AliasListEntry;
import com.amazonaws.services.kms.model.KeyListEntry;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class KMSEncryptionFeature
extends S3EncryptionFeature {
    private static final Logger log = Logger.getLogger(KMSEncryptionFeature.class);
    private final S3Session session;
    private final Preferences preferences = PreferencesFactory.get();
    private final PathContainerService containerService = new S3PathContainerService();
    private final ClientConfiguration configuration;
    private final Location locationFeature;
    public static final Encryption.Algorithm SSE_KMS_DEFAULT = new Encryption.Algorithm("aws:kms", null){

        public String getDescription() {
            return "SSE-KMS";
        }
    };

    public KMSEncryptionFeature(S3Session session, X509TrustManager trust, X509KeyManager key) {
        super(session);
        this.session = session;
        Host bookmark = session.getHost();
        this.configuration = new CustomClientConfiguration(bookmark, new ThreadLocalHostnameDelegatingTrustManager(trust, bookmark.getHostname()), key);
        this.locationFeature = (Location)session.getFeature(Location.class);
    }

    @Override
    public Encryption.Algorithm getDefault(Path file) {
        String setting = this.preferences.getProperty("s3.encryption.algorithm");
        if (StringUtils.equals((CharSequence)KMSEncryptionFeature.SSE_KMS_DEFAULT.algorithm, (CharSequence)setting)) {
            String key = String.format("s3.encryption.key.%s", this.containerService.getContainer(file).getName());
            if (StringUtils.isNotBlank((CharSequence)this.preferences.getProperty(key))) {
                return Encryption.Algorithm.fromString((String)this.preferences.getProperty(key));
            }
            return SSE_KMS_DEFAULT;
        }
        return super.getDefault(file);
    }

    @Override
    public Encryption.Algorithm getEncryption(Path file) throws BackgroundException {
        String key;
        if (this.containerService.isContainer(file) && StringUtils.isNotBlank((CharSequence)this.preferences.getProperty(key = String.format("s3.encryption.key.%s", this.containerService.getContainer(file).getName())))) {
            return Encryption.Algorithm.fromString((String)this.preferences.getProperty(key));
        }
        return super.getEncryption(file);
    }

    @Override
    public Set<Encryption.Algorithm> getKeys(Path file, LoginCallback prompt) throws BackgroundException {
        Path container = this.containerService.getContainer(file);
        Set<Encryption.Algorithm> keys = super.getKeys(container, prompt);
        if (container.isRoot()) {
            return keys;
        }
        try {
            AWSKMS client = this.client(container);
            try {
                HashMap<String, String> aliases = new HashMap<String, String>();
                for (AliasListEntry entry : client.listAliases().getAliases()) {
                    aliases.put(entry.getTargetKeyId(), entry.getAliasName());
                }
                for (AliasListEntry entry : client.listKeys().getKeys()) {
                    keys.add(new AliasedAlgorithm((KeyListEntry)entry, (String)aliases.get(entry.getKeyId())));
                }
            }
            catch (AmazonClientException e) {
                throw new AmazonServiceExceptionMappingService().map("Cannot read AWS KMS configuration", e);
            }
            finally {
                client.shutdown();
            }
        }
        catch (AccessDeniedException e) {
            log.warn((Object)String.format("Ignore failure reading keys from KMS. %s", e.getMessage()));
            keys.add(SSE_KMS_DEFAULT);
        }
        return keys;
    }

    private AWSKMS client(Path container) throws BackgroundException {
        AWSKMSClientBuilder builder = (AWSKMSClientBuilder)((AWSKMSClientBuilder)AWSKMSClientBuilder.standard().withCredentials(AWSCredentialsConfigurator.toAWSCredentialsProvider(((RequestEntityRestStorageService)((Object)this.session.getClient())).getProviderCredentials()))).withClientConfiguration(this.configuration);
        Location.Name region = this.locationFeature.getLocation(container);
        if (S3Session.isAwsHostname(this.session.getHost().getHostname(), false)) {
            if (Location.unknown.equals((Object)region)) {
                builder.withRegion(Regions.DEFAULT_REGION);
            } else {
                builder.withRegion(region.getIdentifier());
            }
        } else {
            builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(new HostUrlProvider(false).get(this.session.getHost()), region.getIdentifier()));
        }
        return (AWSKMS)builder.build();
    }

    private static class AliasedAlgorithm
    extends Encryption.Algorithm {
        private final KeyListEntry entry;
        private final String alias;

        public AliasedAlgorithm(KeyListEntry entry, String alias) {
            super(KMSEncryptionFeature.SSE_KMS_DEFAULT.algorithm, entry.getKeyArn());
            this.entry = entry;
            this.alias = alias;
        }

        public String getDescription() {
            if (StringUtils.isBlank((CharSequence)this.alias)) {
                return String.format("SSE-KMS (%s)", this.entry.getKeyArn());
            }
            return String.format("SSE-KMS (%s - %s)", this.alias, this.entry.getKeyArn());
        }
    }
}

