/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.gui.skins.html;

import java.awt.Color;
import java.awt.Font;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SkinnedLookAndFeel
extends MetalLookAndFeel {
    private static final long serialVersionUID = 4391824305469950437L;
    private static final Log log = LogFactory.getLog(SkinnedLookAndFeel.class);

    public SkinnedLookAndFeel(Properties skinProperties, String itemName) {
        Color color;
        JLabel defaultLabel = new JLabel();
        Color backgroundColor = defaultLabel.getBackground();
        Color textColor = defaultLabel.getForeground();
        Font font = defaultLabel.getFont();
        String backgroundColorValue = skinProperties.getProperty("backgroundColor", null);
        String textColorValue = skinProperties.getProperty("textColor", null);
        String fontValue = skinProperties.getProperty("font", null);
        if (backgroundColorValue != null) {
            color = Color.decode(backgroundColorValue);
            if (color == null) {
                log.error((Object)("Unable to set background color with value: " + backgroundColorValue));
            } else {
                backgroundColor = color;
            }
        }
        if (textColorValue != null) {
            color = Color.decode(textColorValue);
            if (color == null) {
                log.error((Object)("Unable to set text color with value: " + textColorValue));
            } else {
                textColor = color;
            }
        }
        if (fontValue != null) {
            Font myFont = Font.decode(fontValue);
            if (myFont == null) {
                log.error((Object)("Unable to set font with value: " + fontValue));
            } else {
                font = myFont;
            }
        }
        SkinnedMetalTheme skinnedTheme = new SkinnedMetalTheme(new ColorUIResource(backgroundColor), new ColorUIResource(textColor), new FontUIResource(font));
        MetalLookAndFeel.setCurrentTheme(skinnedTheme);
    }

    private class SkinnedMetalTheme
    extends DefaultMetalTheme {
        private ColorUIResource backgroundColorUIResource = null;
        private ColorUIResource textColorUIResource = null;
        private FontUIResource fontUIResource = null;

        public SkinnedMetalTheme(ColorUIResource backgroundColorUIResource, ColorUIResource textColorUIResource, FontUIResource fontUIResource) {
            this.backgroundColorUIResource = backgroundColorUIResource;
            this.textColorUIResource = textColorUIResource;
            this.fontUIResource = fontUIResource;
        }

        @Override
        public String getName() {
            return "Uploader HTML skinnable theme";
        }

        @Override
        public FontUIResource getSystemTextFont() {
            return this.fontUIResource;
        }

        @Override
        public FontUIResource getControlTextFont() {
            return this.fontUIResource;
        }

        @Override
        public FontUIResource getUserTextFont() {
            return this.fontUIResource;
        }

        @Override
        public ColorUIResource getSystemTextColor() {
            return this.textColorUIResource;
        }

        @Override
        public ColorUIResource getControlTextColor() {
            return this.textColorUIResource;
        }

        @Override
        public ColorUIResource getUserTextColor() {
            return this.textColorUIResource;
        }

        @Override
        public ColorUIResource getWindowBackground() {
            return this.backgroundColorUIResource;
        }

        @Override
        public ColorUIResource getControl() {
            return this.backgroundColorUIResource;
        }
    }
}

