/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.googledrive.AbstractDriveListService;
import ch.cyberduck.core.googledrive.DriveAttributesFinderFeature;
import ch.cyberduck.core.googledrive.DriveExceptionMappingService;
import ch.cyberduck.core.googledrive.DriveFileidProvider;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.preferences.PreferencesFactory;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public class DriveSearchListService
extends AbstractDriveListService {
    private static final String DEFAULT_FIELDS = String.format("files(%s,parents),nextPageToken", "createdTime,explicitlyTrashed,id,md5Checksum,mimeType,modifiedTime,name,size,webViewLink,shortcutDetails,version");
    private final DriveSession session;
    private final DriveFileidProvider fileid;
    private final DriveAttributesFinderFeature attributes;
    private final String query;

    public DriveSearchListService(DriveSession session, DriveFileidProvider fileid, String query) {
        super(session, fileid, PreferencesFactory.get().getInteger("googledrive.list.limit"), DEFAULT_FIELDS);
        this.session = session;
        this.fileid = fileid;
        this.attributes = new DriveAttributesFinderFeature(session, fileid);
        this.query = query;
    }

    @Override
    protected String query(Path directory, ListProgressListener listener) throws BackgroundException {
        return String.format("name contains '%s'", this.query);
    }

    @Override
    protected Set<Path> parents(Path directory, File f) throws BackgroundException {
        try {
            HashSet<Path> tree = new HashSet<Path>();
            String workdirId = ((File)((Drive)this.session.getClient()).files().get(this.fileid.getFileid(directory, (ListProgressListener)new DisabledListProgressListener())).setSupportsAllDrives(Boolean.valueOf(PreferencesFactory.get().getBoolean("googledrive.teamdrive.enable"))).execute()).getId();
            for (String parentid : f.getParents()) {
                tree.addAll(this.parents(directory, workdirId, parentid, new ArrayDeque<File>()));
            }
            return tree;
        }
        catch (IOException e) {
            throw new DriveExceptionMappingService().map("Listing directory failed", e, directory);
        }
    }

    private Set<Path> parents(Path directory, String workdirId, String id, Deque<File> dequeue) throws IOException {
        HashSet<Path> tree = new HashSet<Path>();
        while (!workdirId.equals(id)) {
            File f = (File)((Drive)this.session.getClient()).files().get(id).setFields(String.format("parents,%s", "createdTime,explicitlyTrashed,id,md5Checksum,mimeType,modifiedTime,name,size,webViewLink,shortcutDetails,version")).execute();
            dequeue.push(f);
            if (null == f.getParents()) break;
            for (String parentid : f.getParents()) {
                tree.addAll(this.parents(directory, workdirId, parentid, new ArrayDeque<File>(dequeue)));
                id = parentid;
            }
        }
        Path parent = directory;
        while (dequeue.size() > 0) {
            File p = dequeue.pop();
            parent = new Path(parent, p.getName(), EnumSet.of(AbstractPath.Type.directory), new PathAttributes().withFileId(p.getId()));
        }
        tree.add(parent);
        return tree;
    }
}

