/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.utils;

import java.util.Properties;

public class PropertyUtils {
    public static String verifyPropExistsAndGetAsString(Properties properties, String propKey) {
        if (properties == null) {
            throw new IllegalArgumentException("null properties");
        }
        String propVal = properties.getProperty(propKey).trim();
        if (propVal == null) {
            throw new IllegalArgumentException(propKey + " not set in jargon.properties");
        }
        return propVal;
    }

    public static int verifyPropExistsAndGetAsInt(Properties properties, String propKey) {
        if (properties == null) {
            throw new IllegalArgumentException("null properties");
        }
        String propVal = PropertyUtils.verifyPropExistsAndGetAsString(properties, propKey);
        try {
            return Integer.parseInt(propVal);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("prop " + propKey + "did not result in an int value, was:" + propVal);
        }
    }

    public static boolean verifyPropExistsAndGetAsBoolean(Properties properties, String propKey) {
        if (properties == null) {
            throw new IllegalArgumentException("null properties");
        }
        String propVal = PropertyUtils.verifyPropExistsAndGetAsString(properties, propKey);
        return Boolean.parseBoolean(propVal);
    }

    public static long verifyPropExistsAndGetAsLong(Properties properties, String propKey) {
        if (properties == null) {
            throw new IllegalArgumentException("null properties");
        }
        String propVal = PropertyUtils.verifyPropExistsAndGetAsString(properties, propKey);
        try {
            return Long.parseLong(propVal);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("prop " + propKey + "did not result in a long value, was:" + propVal);
        }
    }
}

