/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.transfer;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.irods.jargon.core.connection.NegotiatedClientServerConfiguration;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.DefaultIntraFileProgressCallbackListener;
import org.irods.jargon.core.pub.IRODSAccessObjectFactory;
import org.irods.jargon.core.transfer.AbstractParallelFileTransferStrategy;
import org.irods.jargon.core.transfer.FileRestartInfo;
import org.irods.jargon.core.transfer.ParallelPutTransferThread;
import org.irods.jargon.core.transfer.TransferControlBlock;
import org.irods.jargon.core.transfer.TransferStatus;
import org.irods.jargon.core.transfer.TransferStatusCallbackListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParallelPutFileTransferStrategy
extends AbstractParallelFileTransferStrategy {
    public static final Logger log = LoggerFactory.getLogger(ParallelPutFileTransferStrategy.class);

    public static ParallelPutFileTransferStrategy instance(String host, int port, int numberOfThreads, int password, File localFile, IRODSAccessObjectFactory irodsAccessObjectFactory, long transferLength, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener, FileRestartInfo fileRestartInfo, NegotiatedClientServerConfiguration negotiatedClientServerConfiguration) throws JargonException {
        return new ParallelPutFileTransferStrategy(host, port, numberOfThreads, password, localFile, irodsAccessObjectFactory, transferLength, transferControlBlock, transferStatusCallbackListener, fileRestartInfo, negotiatedClientServerConfiguration);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ParallelPutFileTransferStrategy");
        sb.append("\n   host:");
        sb.append(this.getHost());
        sb.append("\n   port:");
        sb.append(this.getPort());
        sb.append("\n   numberOfThreads:");
        sb.append(this.getNumberOfThreads());
        sb.append("\n   localFile:");
        sb.append(this.localFile.getAbsolutePath());
        sb.append("\n   transferLength:");
        sb.append(this.transferLength);
        return sb.toString();
    }

    private ParallelPutFileTransferStrategy(String host, int port, int numberOfThreads, int password, File localFile, IRODSAccessObjectFactory irodsAccessObjectFactory, long transferLength, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener, FileRestartInfo fileRestartInfo, NegotiatedClientServerConfiguration negotiatedClientServerConfiguration) throws JargonException {
        super(host, port, numberOfThreads, password, localFile, irodsAccessObjectFactory, transferLength, transferControlBlock, transferStatusCallbackListener, fileRestartInfo, negotiatedClientServerConfiguration);
        if (transferControlBlock.getTransferOptions().isIntraFileStatusCallbacks() && transferStatusCallbackListener != null) {
            log.info("will do intra-file status callbacks from transfer");
            this.setConnectionProgressStatusListener(DefaultIntraFileProgressCallbackListener.instance(TransferStatus.TransferType.PUT, transferLength, transferControlBlock, transferStatusCallbackListener));
        }
    }

    @Override
    public void transfer() throws JargonException {
        log.info("initiating transfer for: {}", (Object)this.toString());
        ExecutorService executor = this.getIrodsAccessObjectFactory().getIrodsSession().getParallelTransferThreadPool();
        if (executor == null) {
            log.info("no pool available, transfer using single executor");
            ExecutorService executorService = null;
            try {
                executorService = Executors.newFixedThreadPool(this.numberOfThreads);
                this.transferWithExecutor(executorService);
            }
            finally {
                if (executorService != null) {
                    executorService.shutdown();
                }
            }
        } else {
            log.info("transfer via executor");
            this.transferWithExecutor(executor);
        }
    }

    private void transferWithExecutor(ExecutorService executor) throws JargonException {
        log.info("initiating transfer for: {} without executor", (Object)this.toString());
        ArrayList<ParallelPutTransferThread> parallelPutTransferThreads = new ArrayList<ParallelPutTransferThread>();
        this.localFile.length();
        for (int i = 0; i < this.numberOfThreads; ++i) {
            ParallelPutTransferThread parallelTransferThread = ParallelPutTransferThread.instance(this, i);
            parallelPutTransferThreads.add(parallelTransferThread);
            log.info("created transfer thread:{}", (Object)parallelTransferThread);
        }
        try {
            log.info("invoking executor threads for put");
            List transferThreadStates = executor.invokeAll(parallelPutTransferThreads);
            for (Future transferState : transferThreadStates) {
                try {
                    transferState.get();
                }
                catch (ExecutionException e) {
                    throw new JargonException(e.getCause());
                }
            }
            log.info("executor completed");
        }
        catch (InterruptedException e) {
            log.error("interrupted exception in thread", (Throwable)e);
            throw new JargonException(e);
        }
        catch (Exception e) {
            log.error("an error occurred in a parallel put", (Throwable)e);
            throw new JargonException(e);
        }
    }
}

