/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.query;

import java.util.ArrayList;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.query.AbstractIRODSGenQuery;
import org.irods.jargon.core.query.GenQueryBuilderCondition;
import org.irods.jargon.core.query.GenQueryBuilderException;
import org.irods.jargon.core.query.IRODSGenQueryBuilderQueryData;
import org.irods.jargon.core.query.JargonQueryException;
import org.irods.jargon.core.query.TranslatedGenQueryCondition;
import org.irods.jargon.core.query.TranslatedIRODSGenQuery;

public class IRODSGenQueryFromBuilder
extends AbstractIRODSGenQuery {
    private final IRODSGenQueryBuilderQueryData irodsGenQueryBuilderData;

    public static IRODSGenQueryFromBuilder instance(IRODSGenQueryBuilderQueryData irodsGenQueryBuilderData, int numberOfResultsDesired) {
        return new IRODSGenQueryFromBuilder(irodsGenQueryBuilderData, numberOfResultsDesired);
    }

    private IRODSGenQueryFromBuilder(IRODSGenQueryBuilderQueryData irodsGenQueryBuilderData, int numberOfResultsDesired) {
        super(numberOfResultsDesired);
        if (irodsGenQueryBuilderData == null) {
            throw new IllegalArgumentException("irodsGenQueryBuilderData is null");
        }
        if (!irodsGenQueryBuilderData.isQueryValid()) {
            throw new IllegalArgumentException("query is not valid to process");
        }
        this.irodsGenQueryBuilderData = irodsGenQueryBuilderData;
    }

    public IRODSGenQueryBuilderQueryData getIrodsGenQueryBuilderData() {
        return this.irodsGenQueryBuilderData;
    }

    public TranslatedIRODSGenQuery convertToTranslatedIRODSGenQuery() throws GenQueryBuilderException {
        if (!this.irodsGenQueryBuilderData.isQueryValid()) {
            throw new GenQueryBuilderException("Query is not valid");
        }
        ArrayList<TranslatedGenQueryCondition> conditions = new ArrayList<TranslatedGenQueryCondition>();
        for (GenQueryBuilderCondition builderCondition : this.irodsGenQueryBuilderData.getConditions()) {
            String value = this.irodsGenQueryBuilderData.isUpperCase() ? builderCondition.getValue().toUpperCase() : builderCondition.getValue();
            try {
                conditions.add(TranslatedGenQueryCondition.instanceWithFieldNameAndNumericTranslation(builderCondition.getSelectFieldColumnName(), builderCondition.getOperator().getOperatorAsString(), value, builderCondition.getSelectFieldNumericTranslation()));
            }
            catch (JargonQueryException e) {
                throw new GenQueryBuilderException("error building translated query", e);
            }
        }
        try {
            return TranslatedIRODSGenQuery.instance(this.irodsGenQueryBuilderData.getSelectFields(), conditions, this.irodsGenQueryBuilderData.getOrderByFields(), this, this.irodsGenQueryBuilderData.isDistinct(), this.irodsGenQueryBuilderData.isUpperCase(), this.irodsGenQueryBuilderData.isComputeTotalRowCount());
        }
        catch (JargonException e) {
            throw new GenQueryBuilderException("exception building a translated query from this builder query", e);
        }
    }
}

