/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.query;

import java.util.Collections;
import java.util.List;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.IRODSQueryResultSetInterface;

public abstract class AbstractIRODSQueryResultSet
implements IRODSQueryResultSetInterface {
    protected final List<IRODSQueryResultRow> results;
    protected final boolean hasMoreRecords;
    protected final List<String> columnNames;
    protected final int continuationIndex;
    protected final int totalRecords;

    protected AbstractIRODSQueryResultSet(List<IRODSQueryResultRow> results, List<String> columnNames, boolean hasMoreRecords, int continuationIndex) {
        this(results, columnNames, hasMoreRecords, continuationIndex, 0);
    }

    protected AbstractIRODSQueryResultSet(List<IRODSQueryResultRow> results, List<String> columnNames, boolean hasMoreRecords, int continuationIndex, int totalRecords) {
        if (results == null) {
            throw new IllegalArgumentException("results was null");
        }
        if (columnNames == null) {
            throw new IllegalArgumentException("columnNames is null");
        }
        if (totalRecords < 0) {
            throw new IllegalArgumentException("totalRecords < 0");
        }
        this.results = Collections.unmodifiableList(results);
        this.hasMoreRecords = hasMoreRecords;
        this.columnNames = columnNames;
        this.continuationIndex = continuationIndex;
        this.totalRecords = totalRecords;
    }

    @Override
    public List<IRODSQueryResultRow> getResults() {
        return this.results;
    }

    @Override
    public IRODSQueryResultRow getFirstResult() throws DataNotFoundException {
        if (this.results.size() == 0) {
            throw new DataNotFoundException("no result found");
        }
        return this.results.get(0);
    }

    @Override
    public boolean isHasMoreRecords() {
        return this.hasMoreRecords;
    }

    @Override
    public int getNumberOfResultColumns() {
        return this.columnNames.size();
    }

    @Override
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public int getContinuationIndex() {
        return this.continuationIndex;
    }

    @Override
    public int getTotalRecords() {
        return this.totalRecords;
    }
}

