/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.JargonRuntimeException;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.pub.io.IRODSFileFactory;
import org.irods.jargon.core.pub.io.IRODSFileOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRODSFileWriter
extends Writer {
    private final IRODSFileOutputStream irodsFileOutputStream;
    public static Logger log = LoggerFactory.getLogger(IRODSFileWriter.class);
    private final String connectionEncoding;

    public IRODSFileWriter(IRODSFile irodsFile, IRODSFileFactory irodsFileFactory) throws IOException {
        if (irodsFile == null) {
            throw new JargonRuntimeException("irodsFile Is null");
        }
        if (irodsFileFactory == null) {
            throw new JargonRuntimeException("irodsFileFactory is null");
        }
        try {
            this.irodsFileOutputStream = irodsFileFactory.instanceIRODSFileOutputStream(irodsFile);
        }
        catch (JargonException e) {
            throw new IOException("unable to open IRODSFileOutputStream for:" + irodsFile.getAbsolutePath());
        }
        this.connectionEncoding = this.irodsFileOutputStream.getFileIOOperations().getIRODSSession().buildPipelineConfigurationBasedOnJargonProperties().getDefaultEncoding();
    }

    @Override
    public void close() throws IOException {
        log.info("closing irodsFileWriter");
        this.irodsFileOutputStream.close();
    }

    @Override
    public void flush() throws IOException {
        this.irodsFileOutputStream.flush();
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)bos, this.connectionEncoding);
        osw.write(cbuf, off, len);
        osw.flush();
        byte[] oswBytes = bos.toByteArray();
        log.debug("converted {} bytes", (Object)oswBytes.length);
        if (oswBytes.length > 0) {
            this.irodsFileOutputStream.write(bos.toByteArray());
        }
    }
}

