/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.NoResourceDefinedException;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.irods.jargon.core.pub.Stream2StreamAO;
import org.irods.jargon.core.pub.TransferStatistics;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.pub.io.IRODSFileInputStream;
import org.irods.jargon.core.pub.io.IRODSFileOutputStream;
import org.irods.jargon.core.utils.ChannelTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Stream2StreamAOImpl
extends IRODSGenericAO
implements Stream2StreamAO {
    private static final int bufferSize = 32768;
    public static final Logger log = LoggerFactory.getLogger(Stream2StreamAOImpl.class);

    public Stream2StreamAOImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
    }

    @Override
    public void streamBytesToIRODSFile(byte[] bytesToStream, IRODSFile irodsTargetFile) throws JargonException {
        if (bytesToStream == null || bytesToStream.length == 0) {
            throw new IllegalArgumentException("null or empty bytesToStream");
        }
        if (irodsTargetFile == null) {
            throw new IllegalArgumentException("null irodsTargetFile");
        }
        irodsTargetFile.delete();
        log.info("streamBytesToIRODSFile(), irodsFile:{}", (Object)irodsTargetFile);
        log.info("bytesToStream length:{}", (Object)bytesToStream.length);
        IRODSFileOutputStream ifOs = this.getIRODSFileFactory().instanceIRODSFileOutputStream(irodsTargetFile);
        ByteArrayInputStream bis = new ByteArrayInputStream(bytesToStream);
        ReadableByteChannel inputChannel = Channels.newChannel(bis);
        WritableByteChannel outputChannel = Channels.newChannel(ifOs);
        try {
            ChannelTools.fastChannelCopy(inputChannel, outputChannel, 32768);
        }
        catch (IOException e) {
            log.error("IO Exception copying buffers", (Throwable)e);
            throw new JargonException("io exception copying buffers", e);
        }
        finally {
            try {
                inputChannel.close();
                outputChannel.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public TransferStatistics transferStreamToFileUsingIOStreams(InputStream inputStream, File targetFile, long length, int readBuffSize) throws NoResourceDefinedException, JargonException {
        if (inputStream == null) {
            throw new IllegalArgumentException("null or empty inputStream");
        }
        if (targetFile == null) {
            throw new IllegalArgumentException("null targetFile");
        }
        log.info("transferStreamToFile(), inputStream:{}", (Object)inputStream);
        log.info("targetFile:{}", (Object)targetFile);
        InputStream myInputStream = null;
        if (inputStream instanceof BufferedInputStream) {
            log.info("input stream already buffered");
            myInputStream = inputStream;
        } else {
            log.info("adding buffer around input stream");
            myInputStream = new BufferedInputStream(inputStream);
        }
        long timeStart = System.currentTimeMillis();
        OutputStream fileOutputStream = null;
        try {
            int outputBufferSize = this.getJargonProperties().getLocalFileOutputStreamBufferSize();
            if (targetFile instanceof IRODSFile) {
                log.info("target file is an iRODS file");
                if (this.getJargonProperties().isAllowPutGetResourceRedirects()) {
                    log.info("using transfer redirects, so check for stream re-routing");
                    fileOutputStream = this.getIRODSFileFactory().instanceIRODSFileOutputStreamWithRerouting((IRODSFile)((Object)targetFile));
                } else {
                    log.info("not using transfer redirects, so do not do any stream re-routing");
                    fileOutputStream = this.getIRODSFileFactory().instanceIRODSFileOutputStream((IRODSFile)((Object)targetFile));
                }
            } else {
                log.info("target file is a normal file");
                if (!targetFile.exists()) {
                    targetFile.createNewFile();
                }
                fileOutputStream = new FileOutputStream(targetFile);
            }
            log.debug("output buffer size for file output stream in copy:{}", (Object)outputBufferSize);
            if (outputBufferSize == -1) {
                log.info("no buffer on file output stream to local file");
            } else if (outputBufferSize == 0) {
                log.info("default buffered io to file output stream to local file");
                fileOutputStream = new BufferedOutputStream(fileOutputStream);
            } else {
                log.info("buffer io to file output stream to local file with size of: {}", (Object)outputBufferSize);
                fileOutputStream = new BufferedOutputStream(fileOutputStream, outputBufferSize);
            }
            int myBuffSize = readBuffSize;
            if (myBuffSize <= 0) {
                myBuffSize = this.getJargonProperties().getInputToOutputCopyBufferByteSize();
            }
            if (myBuffSize <= 0) {
                throw new JargonException("invalid stream to stream copy buffer size of {}", myBuffSize);
            }
            log.debug("using {} as copy buffer size", (Object)myBuffSize);
            int doneCnt = -1;
            byte[] buf = new byte[myBuffSize];
            while ((doneCnt = myInputStream.read(buf, 0, myBuffSize)) >= 0) {
                if (doneCnt == 0) {
                    Thread.yield();
                    continue;
                }
                fileOutputStream.write(buf, 0, doneCnt);
            }
            fileOutputStream.flush();
        }
        catch (FileNotFoundException e) {
            log.error("File not found exception copying buffers", (Throwable)e);
            throw new JargonException("file not found exception copying buffers", e);
        }
        catch (IOException e) {
            log.error("io exception copying buffers", (Throwable)e);
            throw new JargonException("io exception copying buffers", e);
        }
        finally {
            try {
                myInputStream.close();
            }
            catch (Exception exception) {}
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {}
        }
        long timeEnd = System.currentTimeMillis();
        TransferStatistics transferStatistics = new TransferStatistics();
        long seconds = (timeEnd - timeStart) / 1000L;
        if (seconds == 0L) {
            seconds = 1L;
        }
        transferStatistics.setSeconds((int)seconds);
        transferStatistics.setTotalBytes(length);
        if (transferStatistics.getSeconds() > 0) {
            transferStatistics.setKbPerSecond((int)(transferStatistics.getTotalBytes() / seconds));
        }
        log.info("transfer stats:{}", (Object)transferStatistics);
        return transferStatistics;
    }

    @Override
    public TransferStatistics streamToStreamCopyUsingStandardIO(InputStream inputStream, OutputStream outputStream) throws JargonException {
        log.info("streamToStreamCopyUsingStandardIO()");
        if (inputStream == null) {
            throw new IllegalArgumentException("null inputStream");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("null outputStream");
        }
        InputStream myInput = null;
        OutputStream myOutput = null;
        long timeStart = System.currentTimeMillis();
        if (inputStream instanceof BufferedInputStream) {
            log.info("input already buffered");
            myInput = inputStream;
        } else {
            log.info("wrapping input with a buffer");
            myInput = new BufferedInputStream(inputStream);
        }
        if (outputStream instanceof BufferedOutputStream) {
            log.info("output already buffered");
            myOutput = outputStream;
        } else {
            log.info("wrapping output with a buffer");
            myOutput = new BufferedOutputStream(outputStream);
        }
        byte[] buffer = new byte[this.getJargonProperties().getInputToOutputCopyBufferByteSize()];
        log.info("buffer length for read/write will be:{}", (Object)buffer.length);
        long count = 0L;
        int n = 0;
        try {
            while (-1 != (n = myInput.read(buffer))) {
                myOutput.write(buffer, 0, n);
                count += (long)n;
            }
            myOutput.flush();
        }
        catch (IOException e) {
            log.error("IO Exception copying buffers", (Throwable)e);
            throw new JargonException("io exception copying buffers", e);
        }
        finally {
            try {
                myInput.close();
                myOutput.close();
            }
            catch (Exception exception) {}
        }
        long timeEnd = System.currentTimeMillis();
        TransferStatistics transferStatistics = new TransferStatistics();
        long seconds = (timeEnd - timeStart) / 1000L;
        if (seconds == 0L) {
            seconds = 1L;
        }
        transferStatistics.setSeconds((int)seconds);
        transferStatistics.setTotalBytes(count);
        if (transferStatistics.getSeconds() > 0) {
            transferStatistics.setKbPerSecond((int)(transferStatistics.getTotalBytes() / seconds));
        }
        log.info("transfer stats:{}", (Object)transferStatistics);
        return transferStatistics;
    }

    @Override
    public void streamToStreamCopy(InputStream inputStream, OutputStream outputStream) throws JargonException {
        if (inputStream == null) {
            throw new IllegalArgumentException("null inputStream");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("null outputStream");
        }
        log.info("streamToStreamCopy()");
        ReadableByteChannel inputChannel = Channels.newChannel(inputStream);
        WritableByteChannel outputChannel = Channels.newChannel(outputStream);
        try {
            ChannelTools.fastChannelCopy(inputChannel, outputChannel, 32768);
        }
        catch (IOException e) {
            log.error("IO Exception copying buffers", (Throwable)e);
            throw new JargonException("io exception copying buffers", e);
        }
        finally {
            try {
                inputChannel.close();
                outputChannel.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public byte[] streamFileToByte(IRODSFile irodsFile) throws JargonException {
        if (irodsFile == null) {
            throw new IllegalArgumentException("null irodsTargetFile");
        }
        log.info("streamFileToByte() file:{}", (Object)irodsFile);
        if (!irodsFile.exists() || !irodsFile.isFile()) {
            throw new JargonException("cannot stream, does not exist or is not a file");
        }
        log.info("verified as an existing data object");
        IRODSFileInputStream is = this.getIRODSFileFactory().instanceIRODSFileInputStream(irodsFile);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ReadableByteChannel inputChannel = Channels.newChannel(is);
        WritableByteChannel outputChannel = Channels.newChannel(bos);
        try {
            ChannelTools.fastChannelCopy(inputChannel, outputChannel, 32768);
        }
        catch (IOException e) {
            log.error("IO Exception copying buffers", (Throwable)e);
            throw new JargonException("io exception copying buffers", e);
        }
        finally {
            try {
                inputChannel.close();
                outputChannel.close();
            }
            catch (Exception exception) {}
        }
        return bos.toByteArray();
    }

    @Override
    public void streamClasspathResourceToIRODSFile(String resourcePath, String irodsFileAbsolutePath) throws JargonException {
        if (resourcePath == null || resourcePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty resourcePath");
        }
        if (irodsFileAbsolutePath == null || irodsFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsFileAbsolutePath");
        }
        IRODSFile irodsTarget = this.getIRODSFileFactory().instanceIRODSFile(irodsFileAbsolutePath);
        irodsTarget.getParentFile().mkdirs();
        irodsTarget.delete();
        BufferedInputStream inputStream = new BufferedInputStream(this.getClass().getResourceAsStream(resourcePath));
        IRODSFileOutputStream irodsFileOutputStream = this.getIRODSFileFactory().instanceIRODSFileOutputStream(irodsFileAbsolutePath);
        byte[] buff = new byte[4096];
        try {
            int i = 0;
            while ((i = ((InputStream)inputStream).read(buff)) > -1) {
                irodsFileOutputStream.write(buff, 0, i);
            }
        }
        catch (IOException ioe) {
            log.error("io exception reading rule data from resource", (Throwable)ioe);
            throw new JargonException("error reading rule from resource", ioe);
        }
        finally {
            try {
                irodsFileOutputStream.close();
            }
            catch (IOException iOException) {}
            try {
                ((InputStream)inputStream).close();
            }
            catch (IOException iOException) {}
        }
    }
}

