/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.CatalogAlreadyHasItemByThatNameException;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.DuplicateDataException;
import org.irods.jargon.core.exception.FileNotFoundException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.JargonFileOrCollAlreadyExistsException;
import org.irods.jargon.core.exception.NoResourceDefinedException;
import org.irods.jargon.core.packinstr.CollInp;
import org.irods.jargon.core.packinstr.DataObjCopyInp;
import org.irods.jargon.core.packinstr.DataObjInp;
import org.irods.jargon.core.packinstr.OpenedDataObjInp;
import org.irods.jargon.core.packinstr.Tag;
import org.irods.jargon.core.protovalues.FilePermissionEnum;
import org.irods.jargon.core.pub.CollectionAO;
import org.irods.jargon.core.pub.CollectionAndDataObjectListAndSearchAO;
import org.irods.jargon.core.pub.DataObjectAO;
import org.irods.jargon.core.pub.IRODSFileSystemAO;
import org.irods.jargon.core.pub.IRODSGenQueryExecutor;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.irods.jargon.core.pub.ResourceAO;
import org.irods.jargon.core.pub.domain.ObjStat;
import org.irods.jargon.core.pub.domain.Resource;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.pub.io.IRODSFileSystemAOHelper;
import org.irods.jargon.core.query.CollectionAndDataObjectListingEntry;
import org.irods.jargon.core.query.GenQueryBuilderException;
import org.irods.jargon.core.query.IRODSGenQueryBuilder;
import org.irods.jargon.core.query.IRODSGenQueryFromBuilder;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.IRODSQueryResultSet;
import org.irods.jargon.core.query.JargonQueryException;
import org.irods.jargon.core.query.QueryConditionOperators;
import org.irods.jargon.core.query.RodsGenQueryEnum;
import org.irods.jargon.core.utils.MiscIRODSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IRODSFileSystemAOImpl
extends IRODSGenericAO
implements IRODSFileSystemAO {
    static Logger log = LoggerFactory.getLogger(IRODSFileSystemAOImpl.class);
    private final IRODSGenQueryExecutor irodsGenQueryExecutor = this.getIRODSAccessObjectFactory().getIRODSGenQueryExecutor(this.getIRODSAccount());
    private final CollectionAndDataObjectListAndSearchAO collectionAndDataObjectListAndSearchAO = this.getIRODSAccessObjectFactory().getCollectionAndDataObjectListAndSearchAO(this.getIRODSAccount());

    public IRODSFileSystemAOImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
    }

    @Override
    public boolean isFileReadable(IRODSFile irodsFile) throws JargonException {
        log.info("isFileReadable()");
        boolean readable = false;
        if (irodsFile == null) {
            throw new IllegalArgumentException("irods file is null");
        }
        log.info("checking read permissions on:{}", (Object)irodsFile);
        int filePermissions = 0;
        log.info("checking if isFile or isDirectory to properly build permissions query...");
        if (irodsFile.isFile()) {
            log.debug("getting file permissions");
            filePermissions = this.getFilePermissions(irodsFile);
        } else if (irodsFile.isDirectory()) {
            log.debug("getting directory permissions");
            filePermissions = this.getDirectoryPermissions(irodsFile);
        }
        if (filePermissions >= 1050) {
            readable = true;
        }
        return readable;
    }

    @Override
    public boolean isFileExecutable(IRODSFile irodsFile) throws JargonException {
        log.info("isFileExecutable()");
        if (irodsFile == null) {
            throw new IllegalArgumentException("irodsFile is null");
        }
        boolean executable = false;
        if (irodsFile.exists()) {
            executable = irodsFile.isDirectory() ? false : this.checkIfDataObjectExecutable(irodsFile);
        }
        log.info("is executable:{}", (Object)executable);
        return executable;
    }

    private boolean checkIfDataObjectExecutable(IRODSFile irodsFile) throws JargonException {
        log.info("checkIfDataObjectExecutable");
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
        try {
            builder.addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_DATA_MODE).addConditionAsGenQueryField(RodsGenQueryEnum.COL_COLL_NAME, QueryConditionOperators.EQUAL, irodsFile.getParent()).addConditionAsGenQueryField(RodsGenQueryEnum.COL_DATA_NAME, QueryConditionOperators.EQUAL, irodsFile.getName());
            CollectionAndDataObjectListAndSearchAO listAndSearchAO = this.getIRODSAccessObjectFactory().getCollectionAndDataObjectListAndSearchAO(this.getIRODSAccount());
            ObjStat objStat = listAndSearchAO.retrieveObjectStatForPath(irodsFile.getAbsolutePath());
            String absPath = MiscIRODSUtils.determineAbsolutePathBasedOnCollTypeInObjectStat(objStat);
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(100);
            boolean executable = false;
            IRODSQueryResultSet resultSet = this.irodsGenQueryExecutor.executeIRODSQueryAndCloseResultInZone(irodsQuery, 0, MiscIRODSUtils.getZoneInPath(absPath));
            IRODSQueryResultRow resultRow = resultSet.getFirstResult();
            if (resultRow.getColumn(0).equals("33261")) {
                executable = true;
            }
            return executable;
        }
        catch (DataNotFoundException dnf) {
            log.info("no result found");
            return false;
        }
        catch (JargonQueryException e) {
            log.error("query exception for  query", (Throwable)e);
            throw new JargonException("error in file permissions query");
        }
        catch (GenQueryBuilderException e) {
            log.error("query exception for  query", (Throwable)e);
            throw new JargonException("error in file permissions query");
        }
    }

    @Override
    public boolean isFileWriteable(IRODSFile irodsFile) throws JargonException {
        log.info("isFileWriteable()");
        boolean writeable = false;
        if (irodsFile == null) {
            throw new IllegalArgumentException("irods file is null");
        }
        if (log.isInfoEnabled()) {
            log.info("checking write permissions on:" + irodsFile);
        }
        int filePermissions = 0;
        if (irodsFile.isFile()) {
            log.debug("getting file permissions");
            filePermissions = this.getFilePermissions(irodsFile);
        } else if (irodsFile.isDirectory()) {
            log.debug("getting directory permissions");
            filePermissions = this.getDirectoryPermissions(irodsFile);
        }
        if (filePermissions >= 1120) {
            writeable = true;
        }
        return writeable;
    }

    @Override
    public int getFilePermissions(IRODSFile irodsFile) throws JargonException {
        log.info("getFilePermissions()");
        if (irodsFile == null) {
            throw new IllegalArgumentException("irods file is null");
        }
        log.info("checking permissions on:{}", (Object)irodsFile);
        return this.getFilePermissionsForGivenUser(irodsFile, this.getIRODSAccount().getUserName());
    }

    @Override
    public int getFilePermissionsForGivenUser(IRODSFile irodsFile, String userName) throws JargonException {
        log.info("getFilePermissionsForGivenUser()");
        if (irodsFile == null) {
            throw new IllegalArgumentException("null irodsFile");
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        DataObjectAO dataObjectAO = this.getIRODSAccessObjectFactory().getDataObjectAO(this.getIRODSAccount());
        log.info("delegating to DataObjectAO");
        FilePermissionEnum permissionEnum = dataObjectAO.getPermissionForDataObject(irodsFile.getAbsolutePath(), userName, this.getIRODSAccount().getZone());
        if (permissionEnum == null) {
            return FilePermissionEnum.NONE.getPermissionNumericValue();
        }
        return permissionEnum.getPermissionNumericValue();
    }

    @Override
    public int getDirectoryPermissions(IRODSFile irodsFile) throws JargonException {
        return this.getDirectoryPermissionsForGivenUser(irodsFile, this.getIRODSAccount().getUserName());
    }

    @Override
    public int getDirectoryPermissionsForGivenUser(IRODSFile irodsFile, String userName) throws FileNotFoundException, JargonException {
        log.info("getDirectoryPermissionsForGivenUser()");
        if (irodsFile == null) {
            throw new IllegalArgumentException("null irodsFile");
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        CollectionAO collectionAO = this.getIRODSAccessObjectFactory().getCollectionAO(this.getIRODSAccount());
        log.info("delegating to CollectionAO");
        FilePermissionEnum permissionEnum = collectionAO.getPermissionForCollection(irodsFile.getAbsolutePath(), userName, this.getIRODSAccount().getZone());
        if (permissionEnum == null) {
            return FilePermissionEnum.NONE.getPermissionNumericValue();
        }
        return permissionEnum.getPermissionNumericValue();
    }

    @Override
    public boolean isFileExists(IRODSFile irodsFile) throws JargonException {
        log.info("isFileExists()");
        boolean exists = false;
        if (irodsFile == null) {
            throw new IllegalArgumentException("irods file is null");
        }
        log.info("checking existence of: {}", (Object)irodsFile.getAbsolutePath());
        try {
            ObjStat objStat = this.getObjStat(irodsFile.getAbsolutePath());
            exists = objStat.getObjectType() != CollectionAndDataObjectListingEntry.ObjectType.UNKNOWN;
        }
        catch (FileNotFoundException e) {
            log.info("file not found, will treat as not exists");
        }
        return exists;
    }

    @Override
    public boolean isDirectory(IRODSFile irodsFile) throws JargonException {
        log.info("isDirectory()");
        if (irodsFile == null) {
            throw new IllegalArgumentException("irods file is null");
        }
        boolean isDir = false;
        log.info("checking is dir for: {}", (Object)irodsFile.getAbsolutePath());
        try {
            ObjStat objStat = this.getObjStat(irodsFile.getAbsolutePath());
            if (objStat.getObjectType() == CollectionAndDataObjectListingEntry.ObjectType.COLLECTION || objStat.getObjectType() == CollectionAndDataObjectListingEntry.ObjectType.LOCAL_DIR) {
                isDir = true;
            }
        }
        catch (FileNotFoundException e) {
            log.info("file not found, will treat as not dir");
        }
        return isDir;
    }

    @Override
    public boolean isFile(IRODSFile irodsFile) throws JargonException {
        log.info("isFile()");
        if (irodsFile == null) {
            throw new IllegalArgumentException("irods file is null");
        }
        boolean isFile = false;
        log.info("checking is file for: {}", (Object)irodsFile.getAbsolutePath());
        try {
            ObjStat objStat = this.getObjStat(irodsFile.getAbsolutePath());
            if (objStat.getObjectType() == CollectionAndDataObjectListingEntry.ObjectType.DATA_OBJECT || objStat.getObjectType() == CollectionAndDataObjectListingEntry.ObjectType.LOCAL_FILE) {
                isFile = true;
            }
        }
        catch (FileNotFoundException e) {
            log.info("file not found, will treat as not file");
        }
        return isFile;
    }

    @Override
    public ObjStat getObjStat(String irodsAbsolutePath) throws FileNotFoundException, JargonException {
        log.info("getObjStat(final String irodsAbsolutePath)");
        return this.collectionAndDataObjectListAndSearchAO.retrieveObjectStatForPathWithHeuristicPathGuessing(irodsAbsolutePath);
    }

    @Override
    public List<String> getListInDir(IRODSFile irodsFile) throws FileNotFoundException, JargonException {
        List<CollectionAndDataObjectListingEntry> entries;
        log.info("getListInDir()");
        if (irodsFile == null) {
            throw new JargonException("irods file is null");
        }
        ArrayList<String> subdirs = new ArrayList<String>();
        boolean lastEntry = false;
        int ctr = 0;
        if (!lastEntry) {
            entries = this.collectionAndDataObjectListAndSearchAO.listCollectionsUnderPath(irodsFile.getAbsolutePath(), ctr);
            for (CollectionAndDataObjectListingEntry entry : entries) {
                subdirs.add(MiscIRODSUtils.getLastPathComponentForGiveAbsolutePath(entry.getPathOrName()));
                lastEntry = entry.isLastResult();
                ctr = entry.getCount();
            }
        }
        lastEntry = false;
        ctr = 0;
        if (!lastEntry) {
            entries = this.collectionAndDataObjectListAndSearchAO.listDataObjectsUnderPath(irodsFile.getAbsolutePath(), ctr);
            for (CollectionAndDataObjectListingEntry entry : entries) {
                subdirs.add(entry.getPathOrName());
                lastEntry = entry.isLastResult();
                ctr = entry.getCount();
            }
        }
        return subdirs;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> getListInDirWithFilter(IRODSFile irodsFile, FilenameFilter fileNameFilter) throws JargonException, DataNotFoundException {
        IRODSGenQueryFromBuilder irodsQuery;
        IRODSQueryResultSet resultSet;
        IRODSGenQueryBuilder builder;
        String path;
        ArrayList<String> subdirs;
        block21: {
            log.info("getListInDirWithFilter(final IRODSFile irodsFile,final FilenameFilter fileNameFilter) ");
            if (irodsFile == null) {
                throw new JargonException("irods file is null");
            }
            if (fileNameFilter == null) {
                throw new JargonException("file name filter is null");
            }
            subdirs = new ArrayList<String>();
            path = irodsFile.getAbsolutePath();
            log.debug("path for query:{}", (Object)path);
            builder = new IRODSGenQueryBuilder(true, null);
            resultSet = null;
            try {
                IRODSFileSystemAOHelper.buildQueryListAllCollections(path, builder);
                irodsQuery = builder.exportIRODSQueryFromBuilder(this.getJargonProperties().getMaxFilesAndDirsQueryMax());
                resultSet = this.irodsGenQueryExecutor.executeIRODSQuery(irodsQuery, 0);
                for (IRODSQueryResultRow row : resultSet.getResults()) {
                    this.processRowForSubdirWhenListDirWithFilter(fileNameFilter, subdirs, row);
                }
                while (resultSet.isHasMoreRecords()) {
                    log.debug("more results to get for listing files, requerying");
                    resultSet = this.irodsGenQueryExecutor.getMoreResults(resultSet);
                    for (IRODSQueryResultRow row : resultSet.getResults()) {
                        this.processRowForSubdirWhenListDirWithFilter(fileNameFilter, subdirs, row);
                    }
                }
                if (resultSet == null) break block21;
            }
            catch (JargonQueryException e) {
                try {
                    log.error("query exception for  query", (Throwable)e);
                    throw new JargonException("error in exists query");
                    catch (GenQueryBuilderException e2) {
                        log.error("query exception for  query", (Throwable)e2);
                        throw new JargonException("error in exists query");
                    }
                }
                catch (Throwable throwable) {
                    if (resultSet == null) throw throwable;
                    this.irodsGenQueryExecutor.closeResults(resultSet);
                    throw throwable;
                }
            }
            this.irodsGenQueryExecutor.closeResults(resultSet);
        }
        resultSet = null;
        builder = new IRODSGenQueryBuilder(true, null);
        IRODSFileSystemAOHelper.buildQueryListAllFiles(path, builder);
        try {
            irodsQuery = builder.exportIRODSQueryFromBuilder(this.getJargonProperties().getMaxFilesAndDirsQueryMax());
            resultSet = this.irodsGenQueryExecutor.executeIRODSQuery(irodsQuery, 0);
            for (IRODSQueryResultRow row : resultSet.getResults()) {
                this.processRowWhenListDirWithFilter(fileNameFilter, subdirs, row);
            }
            while (resultSet.isHasMoreRecords()) {
                log.debug("more results to get for listing files, requerying");
                resultSet = this.irodsGenQueryExecutor.getMoreResults(resultSet);
                for (IRODSQueryResultRow row : resultSet.getResults()) {
                    this.processRowWhenListDirWithFilter(fileNameFilter, subdirs, row);
                }
            }
            return subdirs;
        }
        catch (JargonQueryException e) {
            log.error("query exception for  query", (Throwable)e);
            throw new JargonException("error in exists query");
        }
        catch (GenQueryBuilderException e) {
            log.error("query exception for  query", (Throwable)e);
            throw new JargonException("error in exists query");
        }
        finally {
            if (resultSet != null) {
                this.irodsGenQueryExecutor.closeResults(resultSet);
            }
        }
    }

    private void processRowForSubdirWhenListDirWithFilter(FilenameFilter fileNameFilter, List<String> subdirs, IRODSQueryResultRow row) throws JargonException {
        File fileFromResult = new File(row.getColumn(1));
        if (fileNameFilter.accept(fileFromResult.getParentFile(), fileFromResult.getName())) {
            subdirs.add(row.getColumn(1));
        }
    }

    private void processRowWhenListDirWithFilter(FilenameFilter fileNameFilter, List<String> subdirs, IRODSQueryResultRow row) throws JargonException {
        String thisFileName = row.getColumn(1);
        String thisFileDir = row.getColumn(0);
        StringBuilder sb = new StringBuilder();
        sb.append(thisFileDir);
        sb.append('/');
        sb.append(thisFileName);
        String fileName = sb.toString();
        if (fileNameFilter.accept(new File(thisFileDir), thisFileName)) {
            subdirs.add(fileName);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<File> getListInDirWithFileFilter(IRODSFile irodsFile, FileFilter fileFilter) throws JargonException, DataNotFoundException {
        IRODSGenQueryFromBuilder irodsQuery;
        IRODSQueryResultSet resultSet;
        IRODSGenQueryBuilder builder;
        String path;
        ArrayList<File> subdirs;
        block21: {
            log.info("getListInDirWithFileFilter(final IRODSFile irodsFile,final FileFilter fileFilter)");
            if (irodsFile == null) {
                throw new JargonException("irods file is null");
            }
            if (fileFilter == null) {
                throw new JargonException("file filter is null");
            }
            subdirs = new ArrayList<File>();
            path = "";
            path = irodsFile.isDirectory() ? irodsFile.getAbsolutePath() : irodsFile.getParent();
            builder = new IRODSGenQueryBuilder(true, null);
            resultSet = null;
            try {
                IRODSFileSystemAOHelper.buildQueryListAllCollections(path, builder);
                irodsQuery = builder.exportIRODSQueryFromBuilder(this.getJargonProperties().getMaxFilesAndDirsQueryMax());
                resultSet = this.irodsGenQueryExecutor.executeIRODSQuery(irodsQuery, 0);
                for (IRODSQueryResultRow row : resultSet.getResults()) {
                    this.processSubdirRowWhenListFilesWithFileFilter(fileFilter, subdirs, row);
                }
                while (resultSet.isHasMoreRecords()) {
                    log.debug("more results to get for listing files, requerying");
                    resultSet = this.irodsGenQueryExecutor.getMoreResults(resultSet);
                    for (IRODSQueryResultRow row : resultSet.getResults()) {
                        this.processSubdirRowWhenListFilesWithFileFilter(fileFilter, subdirs, row);
                    }
                }
                if (resultSet == null) break block21;
            }
            catch (JargonQueryException e) {
                try {
                    log.error("query exception for  query", (Throwable)e);
                    throw new JargonException("error in exists query");
                    catch (GenQueryBuilderException e2) {
                        log.error("query exception for  query", (Throwable)e2);
                        throw new JargonException("error in exists query");
                    }
                }
                catch (Throwable throwable) {
                    if (resultSet == null) throw throwable;
                    this.irodsGenQueryExecutor.closeResults(resultSet);
                    throw throwable;
                }
            }
            this.irodsGenQueryExecutor.closeResults(resultSet);
        }
        resultSet = null;
        log.debug("path for query:{}", (Object)path);
        builder = new IRODSGenQueryBuilder(true, null);
        IRODSFileSystemAOHelper.buildQueryListAllFiles(path, builder);
        try {
            irodsQuery = builder.exportIRODSQueryFromBuilder(this.getJargonProperties().getMaxFilesAndDirsQueryMax());
            resultSet = this.irodsGenQueryExecutor.executeIRODSQuery(irodsQuery, 0);
            for (IRODSQueryResultRow row : resultSet.getResults()) {
                this.processFileRowWhenListFilesWithFileFilter(fileFilter, subdirs, row);
            }
            while (resultSet.isHasMoreRecords()) {
                log.debug("more results to get for listing files, requerying");
                resultSet = this.irodsGenQueryExecutor.getMoreResults(resultSet);
                for (IRODSQueryResultRow row : resultSet.getResults()) {
                    this.processFileRowWhenListFilesWithFileFilter(fileFilter, subdirs, row);
                }
            }
            return subdirs;
        }
        catch (JargonQueryException e) {
            log.error("query exception for  query}", (Throwable)e);
            throw new JargonException("error in exists query");
        }
        catch (GenQueryBuilderException e) {
            log.error("query exception for  query}", (Throwable)e);
            throw new JargonException("error in exists query");
        }
        finally {
            if (resultSet != null) {
                this.irodsGenQueryExecutor.closeResults(resultSet);
            }
        }
    }

    private void processSubdirRowWhenListFilesWithFileFilter(FileFilter fileFilter, List<File> subdirs, IRODSQueryResultRow row) throws JargonException {
        String thisFileDir = row.getColumn(1);
        File irodsFile = (File)((Object)this.getIRODSFileFactory().instanceIRODSFile(thisFileDir));
        if (fileFilter.accept(irodsFile)) {
            subdirs.add(irodsFile);
        }
    }

    private void processFileRowWhenListFilesWithFileFilter(FileFilter fileFilter, List<File> subdirs, IRODSQueryResultRow row) throws JargonException {
        String thisFileDir = row.getColumn(0);
        String thisFileName = row.getColumn(1);
        File irodsFile = (File)((Object)this.getIRODSFileFactory().instanceIRODSFile(thisFileDir, thisFileName));
        if (fileFilter.accept(irodsFile)) {
            subdirs.add(irodsFile);
        }
    }

    @Override
    public CollectionAndDataObjectListingEntry.ObjectType getFileDataType(IRODSFile irodsFile) throws FileNotFoundException, JargonException {
        log.info("getFileDataType(final IRODSFile irodsFile)");
        if (irodsFile == null) {
            throw new JargonException("irods file is null");
        }
        ObjStat objStat = this.getObjStat(irodsFile.getAbsolutePath());
        return objStat.getObjectType();
    }

    @Override
    public int createFile(String absolutePath, DataObjInp.OpenFlags openFlags, int createMode) throws NoResourceDefinedException, JargonFileOrCollAlreadyExistsException, JargonException {
        log.info("createFile(final String absolutePath,final DataObjInp.OpenFlags openFlags, final int createMode)");
        String defaultResource = this.getIRODSAccount().getDefaultStorageResource();
        log.debug("setting resource to account default:{}", (Object)defaultResource);
        int fileId = 0;
        try {
            fileId = this.createFileInResource(absolutePath, openFlags, createMode, defaultResource);
        }
        catch (JargonFileOrCollAlreadyExistsException jfcae) {
            log.error("file or collection already exists");
            throw jfcae;
        }
        log.info("file created and closed");
        return fileId;
    }

    @Override
    public int openFile(IRODSFile irodsFile, DataObjInp.OpenFlags openFlags) throws JargonException {
        Tag response;
        log.info("openFile(final IRODSFile irodsFile,final DataObjInp.OpenFlags openFlags)");
        if (irodsFile == null) {
            throw new JargonException("irodsFile is null");
        }
        String absPath = this.resolveAbsolutePathGivenObjStat(this.getObjStat(irodsFile.getAbsolutePath()));
        DataObjInp dataObjInp = DataObjInp.instanceForOpen(absPath, openFlags);
        if (log.isInfoEnabled()) {
            log.info("opening file:" + absPath);
        }
        if ((response = this.getIRODSProtocol().irodsFunction("RODS_API_REQ", dataObjInp.getParsedTags(), 602)) == null) {
            String msg = "null response from IRODS call";
            log.error(msg);
            throw new JargonException(msg);
        }
        int fileId = response.getTag("MsgHeader_PI").getTag("intInfo").getIntValue();
        log.debug("file id for opened file:{}", (Object)fileId);
        return fileId;
    }

    @Override
    public int createFileInResource(String absolutePath, DataObjInp.OpenFlags openFlags, int createMode, String resource) throws NoResourceDefinedException, JargonFileOrCollAlreadyExistsException, JargonException {
        Tag response;
        log.info("createFileInResource(final String absolutePath,final DataObjInp.OpenFlags openFlags, final int createMode,final String resource)");
        if (absolutePath == null || absolutePath.length() == 0) {
            throw new JargonException("absolute path is null or empty");
        }
        if (openFlags == null) {
            throw new JargonException("open flags are null");
        }
        if (resource == null) {
            throw new JargonException("resource is null, set to blank to automatically have the irods system select the default storage resource by rule");
        }
        String thisResource = null;
        thisResource = !MiscIRODSUtils.isFileInThisZone(absolutePath, this.getIRODSAccount()) ? "" : resource;
        long offset = 0L;
        long dataSize = 0L;
        int responseFileNbr = 0;
        DataObjInp dataObjInp = DataObjInp.instance(absolutePath, createMode, openFlags, offset, dataSize, thisResource, null);
        if (openFlags == DataObjInp.OpenFlags.WRITE || openFlags == DataObjInp.OpenFlags.READ_WRITE_CREATE_IF_NOT_EXISTS || openFlags == DataObjInp.OpenFlags.WRITE_FAIL_IF_EXISTS || openFlags == DataObjInp.OpenFlags.READ_WRITE || openFlags == DataObjInp.OpenFlags.WRITE_TRUNCATE) {
            dataObjInp.setOperationType(1);
        }
        if ((response = this.getIRODSProtocol().irodsFunction("RODS_API_REQ", dataObjInp.getParsedTags(), 601)) == null) {
            String msg = "null response from IRODS call";
            log.error(msg);
            throw new JargonException(msg);
        }
        responseFileNbr = response.getTag("MsgHeader_PI").getTag("intInfo").getIntValue();
        log.debug("response file nbr:{}", (Object)responseFileNbr);
        return responseFileNbr;
    }

    @Override
    public void mkdir(IRODSFile irodsFile, boolean recursiveOpr) throws JargonException {
        log.info("mkdir(final IRODSFile irodsFile, final boolean recursiveOpr)");
        if (irodsFile == null) {
            throw new JargonException("irodsFile is null");
        }
        log.info("making dir for:{}", (Object)irodsFile.getAbsolutePath());
        CollInp collInp = CollInp.instance(irodsFile.getAbsolutePath(), recursiveOpr);
        try {
            Tag response = this.getIRODSProtocol().irodsFunction("RODS_API_REQ", collInp.getParsedTags(), 681);
            if (response != null) {
                log.warn("expected null response to mkdir, logged but not an error, received:{}", (Object)response.parseTag());
            }
        }
        catch (CatalogAlreadyHasItemByThatNameException e) {
            log.info("directory already exists in mkdir, log and ignore");
        }
        log.debug("mkdir succesful");
    }

    @Override
    public void fileClose(int fileDescriptor, boolean putOpr) throws JargonException {
        log.info("fileClose(final int fileDescriptor) :{}", (Object)fileDescriptor);
        if (fileDescriptor <= 0) {
            throw new JargonException("attempting to close file with no valid descriptor");
        }
        OpenedDataObjInp openedDataObjInp = null;
        if (putOpr) {
            log.info("close with putOpr to trigger post proc for put");
            openedDataObjInp = OpenedDataObjInp.instanceForFileCloseWithPutOpr(fileDescriptor);
        } else {
            openedDataObjInp = OpenedDataObjInp.instanceForFileClose(fileDescriptor);
        }
        Tag response = this.getIRODSProtocol().irodsFunction("RODS_API_REQ", openedDataObjInp.getParsedTags(), openedDataObjInp.getApiNumber());
        if (response != null) {
            log.warn("expected null response to close, logged but not an error, received:{}", (Object)response.parseTag());
        }
        log.debug("file close successful");
    }

    @Override
    public void fileDeleteForce(IRODSFile irodsFile) throws JargonException {
        log.info("ileDeleteForce(final IRODSFile irodsFile)");
        if (irodsFile == null) {
            throw new JargonException("irodsFile is null");
        }
        log.info("deleting:{}", (Object)irodsFile.getAbsolutePath());
        if (!irodsFile.isFile()) {
            String msg = "file delete, given irodsFile is not a file";
            log.error(msg);
            throw new JargonException(msg);
        }
        DataObjInp dataObjInp = DataObjInp.instanceForDeleteWithForce(irodsFile.getAbsolutePath());
        Tag response = this.getIRODSProtocol().irodsFunction("RODS_API_REQ", dataObjInp.getParsedTags(), 615);
        if (response != null) {
            String msg = "unexpected response from irods, expected null message - logged and ignored ";
            log.warn(msg);
        }
    }

    @Override
    public void fileDeleteNoForce(IRODSFile irodsFile) throws JargonException {
        log.info("fileDeleteNoForce(final IRODSFile irodsFile)");
        if (irodsFile == null) {
            throw new JargonException("irodsFile is null");
        }
        log.info("deleting without force option:{}", (Object)irodsFile.getAbsolutePath());
        if (!irodsFile.isFile()) {
            String msg = "file delete, given irodsFile is not a file";
            log.error(msg);
            throw new JargonException(msg);
        }
        DataObjInp dataObjInp = DataObjInp.instanceForDeleteWithNoForce(irodsFile.getAbsolutePath());
        try {
            Tag response = this.getIRODSProtocol().irodsFunction(dataObjInp);
            if (response != null) {
                log.warn("unexpected response from irods, expected null message - logged and ignored ");
            }
        }
        catch (DuplicateDataException dde) {
            log.warn("duplicate data exception logged and ignored, see GForge: [#639] 809000 errors on delete operations when trash file already exists");
        }
    }

    @Override
    public void directoryDeleteForce(IRODSFile irodsFile) throws JargonException {
        log.info("directoryDeleteForce(final IRODSFile irodsFile)");
        if (irodsFile == null) {
            throw new JargonException("irodsFile is null");
        }
        log.info("deleting:{}", (Object)irodsFile.getAbsolutePath());
        if (!irodsFile.isDirectory()) {
            String msg = "directory delete, given irodsFile is not a collection";
            log.error(msg);
            throw new JargonException(msg);
        }
        CollInp collInp = CollInp.instance(irodsFile.getAbsolutePath(), true, true);
        Tag response = this.getIRODSProtocol().irodsFunction("RODS_API_REQ", collInp.getParsedTags(), 679);
        this.processClientStatusMessages(response);
        log.info("deletion successful");
    }

    @Override
    public void directoryDeleteNoForce(IRODSFile irodsFile) throws JargonException {
        log.info("directoryDeleteNoForce(final IRODSFile irodsFile)");
        if (irodsFile == null) {
            throw new JargonException("irodsFile is null");
        }
        log.info("deleting:{}", (Object)irodsFile.getAbsolutePath());
        if (!irodsFile.isDirectory()) {
            String msg = "directory delete, given irodsFile is not a collection";
            log.error(msg);
            throw new JargonException(msg);
        }
        CollInp collInp = CollInp.instance(irodsFile.getAbsolutePath(), true);
        Tag response = this.getIRODSProtocol().irodsFunction("RODS_API_REQ", collInp.getParsedTags(), 679);
        this.processClientStatusMessages(response);
        log.info("deletion successful");
    }

    protected Resource getFileResource(IRODSFile irodsFile) throws JargonException, DataNotFoundException {
        log.info("getFileResource(final IRODSFile irodsFile)");
        log.info("looking up resource");
        if (!irodsFile.isFile()) {
            String msg = "IRODSFileImpl is not a file, and has no associated resource, file:" + irodsFile.getAbsolutePath();
            log.warn(msg);
            throw new DataNotFoundException(msg);
        }
        ResourceAO resourceAO = this.getIRODSAccessObjectFactory().getResourceAO(this.getIRODSAccount());
        Resource resource = resourceAO.getFirstResourceForIRODSFile(irodsFile);
        log.debug("found resource for file:{}", (Object)resource);
        return resource;
    }

    @Override
    public void renameDirectory(IRODSFile fromFile, IRODSFile toFile) throws JargonException {
        log.info("renaming directory:{}", (Object)fromFile);
        log.info(" to:{}", (Object)toFile);
        if (!fromFile.isDirectory()) {
            String msg = "from file:" + fromFile.getAbsolutePath() + " is not a directory";
            log.error(msg);
            throw new JargonException(msg);
        }
        DataObjCopyInp dataObjCopyInp = DataObjCopyInp.instanceForRenameCollection(fromFile.getAbsolutePath(), toFile.getAbsolutePath());
        Tag response = this.getIRODSProtocol().irodsFunction("RODS_API_REQ", dataObjCopyInp.getParsedTags(), 627);
        if (response != null) {
            log.warn("unexpected response from irods, expected null message - logged and ignored ");
        }
        log.debug("rename successful");
    }

    @Override
    public void renameFile(IRODSFile fromFile, IRODSFile toFile) throws JargonException {
        log.info("renaming file:{}", (Object)fromFile.getAbsolutePath());
        log.info(" to:{}", (Object)toFile.getAbsolutePath());
        if (!fromFile.isFile()) {
            String msg = "from file:" + fromFile.getAbsolutePath() + " is not a file";
            log.error(msg);
            throw new JargonException(msg);
        }
        DataObjCopyInp dataObjCopyInp = DataObjCopyInp.instanceForRenameFile(fromFile.getAbsolutePath(), toFile.getAbsolutePath());
        Tag response = this.getIRODSProtocol().irodsFunction("RODS_API_REQ", dataObjCopyInp.getParsedTags(), 627);
        if (response != null) {
            log.warn("unexpected response from irods, expected null message - logged and ignored ");
        }
        log.debug("rename successful");
    }

    @Override
    public String getResourceNameForFile(IRODSFile irodsFile) throws JargonException {
        log.info("getResourceNameForFile(final IRODSFile irodsFile)");
        if (irodsFile == null) {
            String msg = "null irodsFile";
            log.error(msg);
            throw new JargonException(msg);
        }
        log.info("getting resource for:{}", (Object)irodsFile.getAbsolutePath());
        String resource = "";
        if (!irodsFile.isFile()) {
            String msg = "this is not a file, does not have an associated resource";
            log.error(msg);
            throw new JargonException(msg);
        }
        ResourceAO resourceAO = this.getIRODSAccessObjectFactory().getResourceAO(this.getIRODSAccount());
        try {
            resource = resourceAO.getFirstResourceForIRODSFile(irodsFile).getName();
        }
        catch (DataNotFoundException e) {
            log.info("no resource found");
        }
        return resource;
    }

    @Override
    public void physicalMove(IRODSFile fromFile, String targetResource) throws JargonException {
        log.info("physicalMove(final IRODSFile fromFile,final String targetResource) ");
        if (fromFile == null) {
            throw new JargonException("from file is null");
        }
        if (targetResource == null || targetResource.length() == 0) {
            throw new JargonException("to resource is null or blank");
        }
        log.info("physical move of file:{}", (Object)fromFile.getAbsolutePath());
        log.info(" to resource:{}", (Object)targetResource);
        if (!fromFile.isFile()) {
            String msg = "from file:" + fromFile.getAbsolutePath() + " is not a file";
            log.error(msg);
            throw new JargonException(msg);
        }
        this.physicalMove(fromFile.getAbsolutePath(), targetResource);
    }

    @Override
    public void physicalMove(String absolutePathToSourceFile, String targetResource) throws JargonException {
        log.info("physicalMove(final String absolutePathToSourceFile,final String targetResource)");
        if (absolutePathToSourceFile == null || absolutePathToSourceFile.isEmpty()) {
            throw new JargonException("null or empy absolutePathToSourceFile");
        }
        if (targetResource == null || targetResource.isEmpty()) {
            throw new JargonException("null or empty targetResource");
        }
        DataObjInp dataObjCopyInp = DataObjInp.instanceForPhysicalMoveSpecifyingResource(absolutePathToSourceFile, targetResource);
        int apiNbr = this.getIRODSServerProperties().isAtLeastIrods410() ? 697 : 631;
        Tag response = this.getIRODSProtocol().irodsFunction("RODS_API_REQ", dataObjCopyInp.getParsedTags(), apiNbr);
        if (response != null) {
            log.warn("unexpected response from irods, expected null message - logged and ignored ");
        }
        log.info("physical move successful");
    }

    private void processClientStatusMessages(Tag reply) throws JargonException {
        boolean done = false;
        Tag ackResult = reply;
        while (!done) {
            if (ackResult.getLength() <= 0 || !ackResult.getName().equals("CollOprStat_PI")) continue;
            Tag fileCountTag = ackResult.getTag("filesCnt");
            int fileCount = Integer.parseInt((String)fileCountTag.getValue());
            if (fileCount < 10) {
                done = true;
                continue;
            }
            this.getIRODSProtocol().sendInNetworkOrder(99999997);
            ackResult = this.getIRODSProtocol().readMessage();
        }
    }

    private String resolveAbsolutePathGivenObjStat(ObjStat objStat) throws JargonException {
        if (objStat == null) {
            throw new IllegalArgumentException("null objStat");
        }
        MiscIRODSUtils.evaluateSpecCollSupport(objStat);
        return MiscIRODSUtils.determineAbsolutePathBasedOnCollTypeInObjectStat(objStat);
    }
}

