/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.DuplicateDataException;
import org.irods.jargon.core.exception.FileNotFoundException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.ModAccessControlInp;
import org.irods.jargon.core.packinstr.ModAvuMetadataInp;
import org.irods.jargon.core.protovalues.FilePermissionEnum;
import org.irods.jargon.core.protovalues.UserTypeEnum;
import org.irods.jargon.core.pub.BulkAVUOperationResponse;
import org.irods.jargon.core.pub.CollectionAO;
import org.irods.jargon.core.pub.CollectionAndDataObjectListAndSearchAO;
import org.irods.jargon.core.pub.FileCatalogObjectAOImpl;
import org.irods.jargon.core.pub.IRODSGenQueryExecutor;
import org.irods.jargon.core.pub.IRODSGenQueryExecutorImpl;
import org.irods.jargon.core.pub.RuleProcessingAO;
import org.irods.jargon.core.pub.SpecificQueryAO;
import org.irods.jargon.core.pub.UserAO;
import org.irods.jargon.core.pub.aohelper.CollectionAOHelper;
import org.irods.jargon.core.pub.domain.AvuData;
import org.irods.jargon.core.pub.domain.Collection;
import org.irods.jargon.core.pub.domain.ObjStat;
import org.irods.jargon.core.pub.domain.User;
import org.irods.jargon.core.pub.domain.UserFilePermission;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.pub.io.IRODSFileFactory;
import org.irods.jargon.core.pub.io.IRODSFileFactoryImpl;
import org.irods.jargon.core.query.AVUQueryElement;
import org.irods.jargon.core.query.AVUQueryOperatorEnum;
import org.irods.jargon.core.query.GenQueryBuilderException;
import org.irods.jargon.core.query.GenQueryField;
import org.irods.jargon.core.query.IRODSGenQueryBuilder;
import org.irods.jargon.core.query.IRODSGenQueryFromBuilder;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.IRODSQueryResultSet;
import org.irods.jargon.core.query.JargonQueryException;
import org.irods.jargon.core.query.MetaDataAndDomainData;
import org.irods.jargon.core.query.QueryConditionOperators;
import org.irods.jargon.core.query.RodsGenQueryEnum;
import org.irods.jargon.core.query.SpecificQuery;
import org.irods.jargon.core.query.SpecificQueryResultSet;
import org.irods.jargon.core.rule.IRODSRuleExecResult;
import org.irods.jargon.core.rule.IRODSRuleParameter;
import org.irods.jargon.core.utils.AccessObjectQueryProcessingUtils;
import org.irods.jargon.core.utils.CollectionAndPath;
import org.irods.jargon.core.utils.IRODSDataConversionUtil;
import org.irods.jargon.core.utils.MiscIRODSUtils;
import org.irods.jargon.core.utils.RuleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CollectionAOImpl
extends FileCatalogObjectAOImpl
implements CollectionAO {
    public static final String ERROR_IN_COLECTION_QUERY = "An error occurred in the query for the collection";
    private final IRODSFileFactory irodsFileFactory = new IRODSFileFactoryImpl(this.getIRODSSession(), this.getIRODSAccount());
    private final IRODSGenQueryExecutor irodsGenQueryExecutor = new IRODSGenQueryExecutorImpl(this.getIRODSSession(), this.getIRODSAccount());
    public static final Logger log = LoggerFactory.getLogger(CollectionAOImpl.class);

    protected CollectionAOImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
    }

    @Override
    public IRODSFile instanceIRODSFileForCollectionPath(String collectionPath) throws JargonException {
        log.info("returning a collection for path: {}", (Object)collectionPath);
        IRODSFile collection = this.irodsFileFactory.instanceIRODSFile(collectionPath);
        return collection;
    }

    @Override
    public List<Collection> findDomainByMetadataQuery(List<AVUQueryElement> avuQueryElements) throws JargonQueryException, JargonException {
        return this.findDomainByMetadataQuery(avuQueryElements, 0);
    }

    @Override
    public List<Collection> findDomainByMetadataQuery(List<AVUQueryElement> avuQueryElements, int partialStartIndex) throws JargonQueryException, JargonException {
        return this.findDomainByMetadataQuery(avuQueryElements, partialStartIndex, false);
    }

    @Override
    public List<Collection> findDomainByMetadataQuery(List<AVUQueryElement> avuQueryElements, int partialStartIndex, boolean caseInsensitive) throws JargonQueryException, JargonException {
        IRODSQueryResultSet resultSet;
        log.info("findDomainByMetadataQuery()");
        if (avuQueryElements == null || avuQueryElements.isEmpty()) {
            throw new IllegalArgumentException("null or empty avuQueryElements");
        }
        if (caseInsensitive) {
            if (this.getIRODSServerProperties().isSupportsCaseInsensitiveQueries()) {
                log.info("this is eirods, case insensitive is supported");
            } else {
                throw new JargonException("case insensitive queries not supported on this iRODS version");
            }
        }
        log.info("avuQueryElements:{}", avuQueryElements);
        log.info("partialStartIndex:}{}", (Object)partialStartIndex);
        log.info("caseInsensitive:{}", (Object)caseInsensitive);
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, caseInsensitive, null);
        try {
            CollectionAOHelper.buildSelectsByAppendingToBuilder(builder);
            builder.addSelectAsGenQueryValue(RodsGenQueryEnum.COL_META_COLL_ATTR_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_META_COLL_ATTR_VALUE).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_META_COLL_ATTR_UNITS);
            for (AVUQueryElement queryElement : avuQueryElements) {
                CollectionAOHelper.appendConditionPartToBuilderQuery(queryElement, builder);
            }
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(this.getJargonProperties().getMaxFilesAndDirsQueryMax());
            resultSet = this.irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(irodsQuery, partialStartIndex);
        }
        catch (GenQueryBuilderException e) {
            log.error("error building query", (Throwable)e);
            throw new JargonException("error building query", e);
        }
        catch (JargonQueryException jqe) {
            log.error("error executing query", (Throwable)jqe);
            throw new JargonException("error executing query", jqe);
        }
        return CollectionAOHelper.buildListFromResultSet(resultSet);
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesByMetadataQuery(List<AVUQueryElement> avuQuery, int offset) throws JargonQueryException, JargonException {
        return this.findMetadataValuesByMetadataQueryForCollection(avuQuery, "", offset, false);
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesByMetadataQuery(List<AVUQueryElement> avuQuery, int offset, boolean caseInsensitive) throws JargonQueryException, JargonException {
        return this.findMetadataValuesByMetadataQueryForCollection(avuQuery, "", offset, caseInsensitive);
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesByMetadataQuery(List<AVUQueryElement> avuQuery) throws JargonQueryException, JargonException {
        return this.findMetadataValuesByMetadataQueryForCollection(avuQuery, "");
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesByMetadataQuery(List<AVUQueryElement> avuQuery, boolean caseInsensitive) throws JargonQueryException, JargonException {
        return this.findMetadataValuesByMetadataQueryForCollection(avuQuery, "", 0, caseInsensitive);
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesByMetadataQueryForCollection(List<AVUQueryElement> avuQuery, String collectionAbsolutePath) throws JargonQueryException, JargonException {
        return this.findMetadataValuesByMetadataQueryForCollection(avuQuery, collectionAbsolutePath, 0);
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesByMetadataQueryForCollection(List<AVUQueryElement> avuQuery, String collectionAbsolutePath, int partialStartIndex) throws JargonQueryException, JargonException {
        return this.findMetadataValuesByMetadataQueryForCollection(avuQuery, collectionAbsolutePath, partialStartIndex, false);
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesByMetadataQueryForCollection(List<AVUQueryElement> avuQuery, String collectionAbsolutePath, int partialStartIndex, boolean caseInsensitive) throws FileNotFoundException, JargonQueryException, JargonException {
        IRODSQueryResultSet resultSet;
        if (avuQuery == null || avuQuery.isEmpty()) {
            throw new IllegalArgumentException("null or empty query");
        }
        if (collectionAbsolutePath == null) {
            throw new IllegalArgumentException("Null absolutePath for collection");
        }
        if (caseInsensitive && !this.getIRODSServerProperties().isSupportsCaseInsensitiveQueries()) {
            throw new JargonException("case insensitive queries not supported on this iRODS version");
        }
        String myPath = MiscIRODSUtils.checkPathSizeForMax(collectionAbsolutePath);
        log.info("absPath for querying iCAT:{}", (Object)collectionAbsolutePath);
        log.info("building a metadata query for: {}", avuQuery);
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, caseInsensitive, null);
        try {
            this.addSelectsForMetadataAndDomainDataToBuilder(builder);
            if (!myPath.isEmpty()) {
                builder.addConditionAsGenQueryField(RodsGenQueryEnum.COL_COLL_NAME, QueryConditionOperators.EQUAL, myPath);
            }
            for (AVUQueryElement queryElement : avuQuery) {
                CollectionAOHelper.appendConditionPartToBuilderQuery(queryElement, builder);
            }
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(this.getJargonProperties().getMaxFilesAndDirsQueryMax());
            resultSet = myPath.isEmpty() ? this.irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(irodsQuery, partialStartIndex) : this.irodsGenQueryExecutor.executeIRODSQueryAndCloseResultInZone(irodsQuery, partialStartIndex, MiscIRODSUtils.getZoneInPath(myPath));
        }
        catch (GenQueryBuilderException e) {
            log.error("error building query", (Throwable)e);
            throw new JargonException("error building query", e);
        }
        catch (JargonQueryException jqe) {
            log.error("error executing query", (Throwable)jqe);
            throw new JargonException("error executing query", jqe);
        }
        return AccessObjectQueryProcessingUtils.buildMetaDataAndDomainDatalistFromResultSet(MetaDataAndDomainData.MetadataDomain.COLLECTION, resultSet);
    }

    @Override
    public List<BulkAVUOperationResponse> addBulkAVUMetadataToCollection(String absolutePath, List<AvuData> avuData) throws JargonException {
        log.info("addBulkAVUMetadataToCollection()");
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolute path");
        }
        if (avuData == null || avuData.isEmpty()) {
            throw new IllegalArgumentException("null or empty avuData");
        }
        ArrayList<BulkAVUOperationResponse> responses = new ArrayList<BulkAVUOperationResponse>();
        for (AvuData value : avuData) {
            try {
                this.addAVUMetadata(absolutePath, value);
            }
            catch (FileNotFoundException dnf) {
                log.error("FileNotFoundException when adding an AVU, catch and add to response data", (Throwable)dnf);
                responses.add(BulkAVUOperationResponse.instance(BulkAVUOperationResponse.ResultStatus.MISSING_METADATA_TARGET, value, dnf.getMessage()));
                continue;
            }
            catch (DuplicateDataException dde) {
                log.error("DuplicateDataException when adding an AVU, catch and add to response data", (Throwable)dde);
                responses.add(BulkAVUOperationResponse.instance(BulkAVUOperationResponse.ResultStatus.DUPLICATE_AVU, value, dde.getMessage()));
                continue;
            }
            log.info("treat as success...", (Object)value);
            responses.add(BulkAVUOperationResponse.instance(BulkAVUOperationResponse.ResultStatus.OK, value, ""));
        }
        log.info("...complete");
        return responses;
    }

    @Override
    public List<BulkAVUOperationResponse> deleteBulkAVUMetadataFromCollection(String absolutePath, List<AvuData> avuData) throws JargonException {
        log.info("deleteBulkAVUMetadataToCollection()");
        if (avuData == null || avuData.isEmpty()) {
            throw new IllegalArgumentException("null or empty avuData");
        }
        ArrayList<BulkAVUOperationResponse> responses = new ArrayList<BulkAVUOperationResponse>();
        for (AvuData value : avuData) {
            try {
                this.deleteAVUMetadata(absolutePath, value);
            }
            catch (FileNotFoundException dnf) {
                log.error("FileNotFoundException when deleti an AVU, catch and add to response data", (Throwable)dnf);
                responses.add(BulkAVUOperationResponse.instance(BulkAVUOperationResponse.ResultStatus.MISSING_METADATA_TARGET, value, dnf.getMessage()));
                continue;
            }
            log.info("treat as success...", (Object)value);
            responses.add(BulkAVUOperationResponse.instance(BulkAVUOperationResponse.ResultStatus.OK, value, ""));
        }
        log.info("...complete");
        return responses;
    }

    @Override
    public void addAVUMetadata(String absolutePath, AvuData avuData) throws FileNotFoundException, DuplicateDataException, JargonException {
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePath");
        }
        if (avuData == null) {
            throw new IllegalArgumentException("null AVU data");
        }
        log.info("adding avu metadata to collection: {}", (Object)avuData);
        log.info("absolute path: {}", (Object)absolutePath);
        String myPath = MiscIRODSUtils.checkPathSizeForMax(absolutePath);
        ModAvuMetadataInp modifyAvuMetadataInp = ModAvuMetadataInp.instanceForAddCollectionMetadata(myPath, avuData);
        log.debug("sending avu request");
        try {
            this.getIRODSProtocol().irodsFunction(modifyAvuMetadataInp);
        }
        catch (JargonException je) {
            if (je.getMessage().indexOf("-814000") > -1) {
                throw new DataNotFoundException("Target collection was not found, could not add AVU");
            }
            if (je.getMessage().indexOf("-809000") > -1) {
                throw new DuplicateDataException("Duplicate AVU exists, cannot add");
            }
            log.error("jargon exception adding AVU metadata", (Throwable)je);
            throw je;
        }
        log.debug("metadata added");
    }

    @Override
    public void deleteAVUMetadata(String absolutePath, AvuData avuData) throws FileNotFoundException, JargonException {
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePath");
        }
        if (avuData == null) {
            throw new IllegalArgumentException("null AVU data");
        }
        log.info("deleting avu metadata from collection: {}", (Object)avuData);
        log.info("absolute path: {}", (Object)absolutePath);
        String myPath = MiscIRODSUtils.checkPathSizeForMax(absolutePath);
        ModAvuMetadataInp modifyAvuMetadataInp = ModAvuMetadataInp.instanceForDeleteCollectionMetadata(myPath, avuData);
        log.debug("sending avu request");
        try {
            this.getIRODSProtocol().irodsFunction(modifyAvuMetadataInp);
        }
        catch (JargonException je) {
            if (je.getMessage().indexOf("-814000") > -1) {
                throw new FileNotFoundException("Target collection was not found, could not remove AVU");
            }
            log.error("jargon exception removing AVU metadata", (Throwable)je);
            throw je;
        }
        log.debug("metadata removed");
    }

    @Override
    public void deleteAllAVUMetadata(String absolutePath) throws FileNotFoundException, JargonException {
        List<MetaDataAndDomainData> metadatas;
        log.info("deleteAllAVUMetadata");
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePath");
        }
        log.info("absolute path: {}", (Object)absolutePath);
        ObjStat objStat = this.retrieveObjStat(absolutePath);
        if (objStat.getSpecColType() == ObjStat.SpecColType.MOUNTED_COLL) {
            log.info("objStat indicates collection type that does not support this operation:{}", (Object)objStat);
            return;
        }
        try {
            metadatas = this.findMetadataValuesForCollection(objStat, 0);
        }
        catch (JargonQueryException e) {
            throw new JargonException(e);
        }
        ArrayList<AvuData> avusToDelete = new ArrayList<AvuData>();
        for (MetaDataAndDomainData metadata : metadatas) {
            avusToDelete.add(AvuData.instance(metadata.getAvuAttribute(), metadata.getAvuValue(), metadata.getAvuUnit()));
        }
        this.deleteBulkAVUMetadataFromCollection(objStat.getAbsolutePath(), avusToDelete);
        log.debug("metadata removed");
    }

    @Override
    public void modifyAvuValueBasedOnGivenAttributeAndUnit(String absolutePath, AvuData avuData) throws DataNotFoundException, JargonException {
        List<MetaDataAndDomainData> result;
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePath");
        }
        if (avuData == null) {
            throw new IllegalArgumentException("null avuData");
        }
        log.info("setting avu metadata value for collection");
        log.info("with  avu metadata:{}", (Object)avuData);
        log.info("absolute path: {}", (Object)absolutePath);
        String myPath = MiscIRODSUtils.checkPathSizeForMax(absolutePath);
        ArrayList<AVUQueryElement> queryElements = new ArrayList<AVUQueryElement>();
        try {
            queryElements.add(AVUQueryElement.instanceForValueQuery(AVUQueryElement.AVUQueryPart.ATTRIBUTE, AVUQueryOperatorEnum.EQUAL, avuData.getAttribute()));
            queryElements.add(AVUQueryElement.instanceForValueQuery(AVUQueryElement.AVUQueryPart.UNITS, AVUQueryOperatorEnum.EQUAL, avuData.getUnit()));
            result = this.findMetadataValuesByMetadataQueryForCollection(queryElements, myPath);
        }
        catch (JargonQueryException e) {
            log.error("error querying data for avu", (Throwable)e);
            throw new JargonException("error querying data for AVU");
        }
        if (result.isEmpty()) {
            throw new DataNotFoundException("no avu data found");
        }
        if (result.size() > 1) {
            throw new JargonException("more than one AVU found with given attribute and unit, cannot modify non-unique AVU's in this way");
        }
        AvuData currentAvuData = new AvuData(result.get(0).getAvuAttribute(), result.get(0).getAvuValue(), result.get(0).getAvuUnit());
        AvuData modAvuData = new AvuData(result.get(0).getAvuAttribute(), avuData.getValue(), result.get(0).getAvuUnit());
        this.modifyAVUMetadata(myPath, currentAvuData, modAvuData);
        log.info("metadata modified to:{}", (Object)modAvuData);
    }

    @Override
    public void modifyAVUMetadata(String absolutePath, AvuData currentAvuData, AvuData newAvuData) throws DataNotFoundException, JargonException {
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePath");
        }
        if (currentAvuData == null) {
            throw new IllegalArgumentException("null currentAvuData");
        }
        if (newAvuData == null) {
            throw new IllegalArgumentException("null newAvuData");
        }
        log.info("overwrite avu metadata for collection: {}", (Object)currentAvuData);
        log.info("with new avu metadata:{}", (Object)newAvuData);
        log.info("absolute path: {}", (Object)absolutePath);
        String myPath = MiscIRODSUtils.checkPathSizeForMax(absolutePath);
        ModAvuMetadataInp modifyAvuMetadataInp = ModAvuMetadataInp.instanceForModifyCollectionMetadata(myPath, currentAvuData, newAvuData);
        log.debug("sending avu request");
        try {
            this.getIRODSProtocol().irodsFunction(modifyAvuMetadataInp);
        }
        catch (JargonException je) {
            if (je.getMessage().indexOf("-814000") > -1) {
                throw new DataNotFoundException("Target collection was not found, could not modify AVU");
            }
            log.error("jargon exception modifying AVU metadata", (Throwable)je);
            throw je;
        }
        log.debug("metadata rewritten");
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesForCollection(String collectionAbsolutePath, int partialStartIndex) throws FileNotFoundException, JargonException, JargonQueryException {
        if (collectionAbsolutePath == null || collectionAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty collectionAbsolutePath");
        }
        if (partialStartIndex < 0) {
            throw new IllegalArgumentException("partialStartIndex must be 0 or greater, set to 0 if no offset desired");
        }
        log.info("find metadata values for collection:{}", (Object)collectionAbsolutePath);
        log.info("with partial start of:{}", (Object)partialStartIndex);
        ObjStat objStat = this.getObjectStatForAbsolutePath(collectionAbsolutePath);
        return this.findMetadataValuesForCollection(objStat, partialStartIndex);
    }

    @Override
    public MetaDataAndDomainData findMetadataValueForCollectionByMetadataId(String collectionAbsolutePath, int id) throws FileNotFoundException, DataNotFoundException, JargonException {
        log.info("findMetadataValueForCollectionByMetadataId()");
        if (collectionAbsolutePath == null || collectionAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty collectionAbsolutePath");
        }
        if (id < 0) {
            throw new IllegalArgumentException("id must be 0 or greater");
        }
        log.info("find metadata values for collection:{}", (Object)collectionAbsolutePath);
        log.info("with id:{}", (Object)id);
        ObjStat objStat = this.getObjectStatForAbsolutePath(collectionAbsolutePath);
        return this.findMetadataValueForCollectionById(objStat, id);
    }

    @Override
    public MetaDataAndDomainData findMetadataValueForCollectionById(ObjStat objStat, int id) throws DataNotFoundException, JargonException {
        if (objStat == null) {
            throw new IllegalArgumentException("null or empty objStat");
        }
        if (id < 0) {
            throw new IllegalArgumentException("id must be 0 or greater");
        }
        log.info("find metadata values for collection:{}", (Object)objStat);
        log.info("with id of:{}", (Object)id);
        String absPath = MiscIRODSUtils.determineAbsolutePathBasedOnCollTypeInObjectStat(objStat);
        log.info("absPath for querying iCAT:{}", (Object)absPath);
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
        try {
            this.addSelectsForMetadataAndDomainDataToBuilder(builder).addConditionAsGenQueryField(RodsGenQueryEnum.COL_COLL_NAME, QueryConditionOperators.EQUAL, absPath).addConditionAsGenQueryField(RodsGenQueryEnum.COL_META_COLL_ATTR_ID, QueryConditionOperators.EQUAL, id);
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(this.getJargonProperties().getMaxFilesAndDirsQueryMax());
            IRODSQueryResultSet resultSet = this.irodsGenQueryExecutor.executeIRODSQueryAndCloseResultInZone(irodsQuery, 0, MiscIRODSUtils.getZoneInPath(absPath));
            return AccessObjectQueryProcessingUtils.buildMetaDataAndDomainDataFromResultSetRow(MetaDataAndDomainData.MetadataDomain.COLLECTION, resultSet.getFirstResult(), 1);
        }
        catch (GenQueryBuilderException e) {
            log.error("error building query", (Throwable)e);
            throw new JargonException("error building query", e);
        }
        catch (JargonQueryException jqe) {
            log.error("error executing query", (Throwable)jqe);
            throw new JargonException("error executing query", jqe);
        }
    }

    private IRODSGenQueryBuilder addSelectsForMetadataAndDomainDataToBuilder(IRODSGenQueryBuilder builder) throws GenQueryBuilderException {
        return builder.addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_ID).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_CREATE_TIME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_MODIFY_TIME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_META_COLL_ATTR_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_META_COLL_ATTR_VALUE).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_META_COLL_ATTR_UNITS).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_META_COLL_ATTR_ID);
    }

    private List<MetaDataAndDomainData> findMetadataValuesForCollection(ObjStat objStat, int partialStartIndex) throws FileNotFoundException, JargonException, JargonQueryException {
        IRODSQueryResultSet resultSet;
        if (objStat == null) {
            throw new IllegalArgumentException("null or empty objStat");
        }
        if (partialStartIndex < 0) {
            throw new IllegalArgumentException("partialStartIndex must be 0 or greater, set to 0 if no offset desired");
        }
        log.info("find metadata values for collection:{}", (Object)objStat);
        log.info("with partial start of:{}", (Object)partialStartIndex);
        String absPath = MiscIRODSUtils.determineAbsolutePathBasedOnCollTypeInObjectStat(objStat);
        log.info("absPath for querying iCAT:{}", (Object)absPath);
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
        try {
            this.addSelectsForMetadataAndDomainDataToBuilder(builder).addConditionAsGenQueryField(RodsGenQueryEnum.COL_COLL_NAME, QueryConditionOperators.EQUAL, absPath);
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(this.getJargonProperties().getMaxFilesAndDirsQueryMax());
            resultSet = this.irodsGenQueryExecutor.executeIRODSQueryAndCloseResultInZone(irodsQuery, partialStartIndex, MiscIRODSUtils.getZoneInPath(absPath));
        }
        catch (GenQueryBuilderException e) {
            log.error("error building query", (Throwable)e);
            throw new JargonException("error building query", e);
        }
        catch (JargonQueryException jqe) {
            log.error("error executing query", (Throwable)jqe);
            throw new JargonException("error executing query", jqe);
        }
        return AccessObjectQueryProcessingUtils.buildMetaDataAndDomainDatalistFromResultSet(MetaDataAndDomainData.MetadataDomain.COLLECTION, resultSet);
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesForCollection(String collectionAbsolutePath) throws JargonException, JargonQueryException {
        return this.findMetadataValuesForCollection(collectionAbsolutePath, 0);
    }

    @Override
    public Collection findGivenObjStat(ObjStat objStat) throws DataNotFoundException, JargonException {
        IRODSQueryResultSet resultSet;
        log.info("findGivenObjStat()");
        if (objStat == null) {
            throw new IllegalArgumentException("null objStat");
        }
        log.info("objStat:{}", (Object)objStat);
        if (!objStat.isSomeTypeOfCollection()) {
            log.error("objStat is not for a collection, wrong method called:{}", (Object)objStat);
            throw new JargonException("object is not a collection");
        }
        MiscIRODSUtils.evaluateSpecCollSupport(objStat);
        String absPath = MiscIRODSUtils.determineAbsolutePathBasedOnCollTypeInObjectStat(objStat);
        log.info("absPath for querying iCAT:{}", (Object)absPath);
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
        try {
            CollectionAOHelper.buildSelectsByAppendingToBuilder(builder);
            builder.addConditionAsGenQueryField(RodsGenQueryEnum.COL_COLL_NAME, QueryConditionOperators.EQUAL, absPath);
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(1);
            resultSet = this.irodsGenQueryExecutor.executeIRODSQueryAndCloseResultInZone(irodsQuery, 0, MiscIRODSUtils.getZoneInPath(absPath));
        }
        catch (GenQueryBuilderException e) {
            log.error("builder exception in query", (Throwable)e);
            throw new JargonException("error in query", e);
        }
        catch (JargonQueryException e) {
            log.error(" exception in query", (Throwable)e);
            throw new JargonException("error in query", e);
        }
        List<Collection> collectionList = CollectionAOHelper.buildListFromResultSet(resultSet);
        if (collectionList.size() == 0) {
            log.error("No collection found for path:{}", (Object)absPath);
            throw new DataNotFoundException("no collection found for path");
        }
        Collection collection = collectionList.get(0);
        if (objStat.getSpecColType() == ObjStat.SpecColType.LINKED_COLL) {
            log.info("this is a special collection,so update the paths and add an object path");
        }
        collection.setObjectPath(objStat.getObjectPath());
        CollectionAndPath collectionAndPath = MiscIRODSUtils.separateCollectionAndPathFromGivenAbsolutePath(objStat.getAbsolutePath());
        StringBuilder sb = new StringBuilder();
        sb.append(collectionAndPath.getCollectionParent());
        sb.append("/");
        collection.setCollectionParentName(sb.toString());
        collection.setCollectionName(objStat.getAbsolutePath());
        collection.setSpecColType(objStat.getSpecColType());
        return collection;
    }

    @Override
    public Collection findByAbsolutePath(String irodsCollectionAbsolutePath) throws DataNotFoundException, JargonException {
        log.info("findByAbsolutePath()");
        if (irodsCollectionAbsolutePath == null || irodsCollectionAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsCollectionAbsolutePath");
        }
        log.info("irodsCollectionAbsolutePath:{}", (Object)irodsCollectionAbsolutePath);
        ObjStat objStat = this.retrieveObjStat(irodsCollectionAbsolutePath);
        return this.findGivenObjStat(objStat);
    }

    @Override
    public Collection findById(int id) throws DataNotFoundException, JargonException {
        IRODSQueryResultSet resultSet;
        log.info("findById() with id:{}", (Object)id);
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
        try {
            CollectionAOHelper.buildSelectsByAppendingToBuilder(builder);
            builder.addConditionAsGenQueryField(RodsGenQueryEnum.COL_COLL_ID, QueryConditionOperators.EQUAL, String.valueOf(id));
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(1);
            resultSet = this.irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (GenQueryBuilderException e) {
            log.error("builder exception in query", (Throwable)e);
            throw new JargonException("error in query", e);
        }
        catch (JargonQueryException e) {
            log.error(" exception in query", (Throwable)e);
            throw new JargonException("error in query", e);
        }
        return CollectionAOHelper.buildCollectionFromResultSetRow(resultSet.getFirstResult());
    }

    @Override
    public int countAllFilesUnderneathTheGivenCollection(String irodsCollectionAbsolutePath) throws FileNotFoundException, JargonException {
        IRODSQueryResultSet resultSet;
        if (irodsCollectionAbsolutePath == null) {
            throw new IllegalArgumentException("irodsCollectionAbsolutePath is null");
        }
        ObjStat objStat = this.collectionAndDataObjectListAndSearchAO.retrieveObjectStatForPath(irodsCollectionAbsolutePath);
        MiscIRODSUtils.evaluateSpecCollSupport(objStat);
        String effectiveAbsolutePath = MiscIRODSUtils.determineAbsolutePathBasedOnCollTypeInObjectStat(objStat);
        log.info("determined effectiveAbsolutePathToBe:{}", (Object)effectiveAbsolutePath);
        if (!objStat.isSomeTypeOfCollection()) {
            log.error("this is a file, not a directory, and therefore I cannot get a count of the children: {}", (Object)irodsCollectionAbsolutePath);
            throw new JargonException("attempting to count children under a file at path:" + irodsCollectionAbsolutePath);
        }
        IRODSGenQueryExecutorImpl irodsGenQueryExecutor = new IRODSGenQueryExecutorImpl(this.getIRODSSession(), this.getIRODSAccount());
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
        try {
            builder.addSelectAsAgregateGenQueryValue(RodsGenQueryEnum.COL_COLL_NAME, GenQueryField.SelectFieldTypes.COUNT).addSelectAsAgregateGenQueryValue(RodsGenQueryEnum.COL_DATA_NAME, GenQueryField.SelectFieldTypes.COUNT).addConditionAsGenQueryField(RodsGenQueryEnum.COL_DATA_REPL_NUM, QueryConditionOperators.EQUAL, 0).addConditionAsGenQueryField(RodsGenQueryEnum.COL_COLL_NAME, QueryConditionOperators.LIKE, effectiveAbsolutePath + "%");
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(1);
            resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResultInZone(irodsQuery, 0, MiscIRODSUtils.getZoneInPath(effectiveAbsolutePath));
        }
        catch (JargonQueryException e) {
            log.error("error in query", (Throwable)e);
            throw new JargonException("error in exists query", e);
        }
        catch (GenQueryBuilderException e) {
            log.error("error in query", (Throwable)e);
            throw new JargonException("error in exists query", e);
        }
        int fileCtr = 0;
        if (resultSet.getResults().size() > 0) {
            fileCtr = IRODSDataConversionUtil.getIntOrZeroFromIRODSValue(resultSet.getFirstResult().getColumn(0));
        }
        return fileCtr;
    }

    @Override
    public void setAccessPermissionInherit(String zone, String absolutePath, boolean recursive) throws JargonException {
        if (zone == null) {
            throw new IllegalArgumentException("null zone");
        }
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePath");
        }
        log.info("setAccessPermissionInherit on absPath:{}", (Object)absolutePath);
        String effectiveAbsPath = this.resolveAbsolutePathViaObjStat(absolutePath);
        boolean collNeedsRecursive = this.adjustRecursiveOption(effectiveAbsPath, recursive);
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetInheritOnACollection(collNeedsRecursive, zone, effectiveAbsPath);
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void setAccessPermissionInheritAsAdmin(String zone, String absolutePath, boolean recursive) throws JargonException {
        if (zone == null) {
            throw new IllegalArgumentException("null zone");
        }
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePath");
        }
        log.info("setAccessPermissionInherit on absPath:{}", (Object)absolutePath);
        String effectiveAbsPath = this.resolveAbsolutePathViaObjStat(absolutePath);
        boolean collNeedsRecursive = this.adjustRecursiveOption(effectiveAbsPath, recursive);
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetInheritOnACollectionInAdminMode(collNeedsRecursive, zone, effectiveAbsPath);
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void setAccessPermissionToNotInherit(String zone, String absolutePath, boolean recursive) throws JargonException {
        if (zone == null) {
            throw new IllegalArgumentException("null zone");
        }
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePath");
        }
        log.info("setAccessPermissionToNotInherit on absPath:{}", (Object)absolutePath);
        String effectiveAbsPath = this.resolveAbsolutePathViaObjStat(absolutePath);
        boolean collNeedsRecursive = this.adjustRecursiveOption(effectiveAbsPath, recursive);
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetNoInheritOnACollection(collNeedsRecursive, zone, effectiveAbsPath);
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void setAccessPermissionToNotInheritInAdminMode(String zone, String absolutePath, boolean recursive) throws JargonException {
        if (zone == null) {
            throw new IllegalArgumentException("null zone");
        }
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePath");
        }
        log.info("setAccessPermissionToNotInherit on absPath:{}", (Object)absolutePath);
        String effectiveAbsPath = this.resolveAbsolutePathViaObjStat(absolutePath);
        boolean collNeedsRecursive = this.adjustRecursiveOption(effectiveAbsPath, recursive);
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetNoInheritOnACollectionInAdminMode(collNeedsRecursive, zone, effectiveAbsPath);
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void setAccessPermissionRead(String zone, String absolutePath, String userName, boolean recursive) throws JargonException {
        if (zone == null) {
            throw new IllegalArgumentException("null zone");
        }
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePath");
        }
        log.info("setAccessPermissionRead on absPath:{}", (Object)absolutePath);
        String effectiveAbsPath = this.resolveAbsolutePathViaObjStat(absolutePath);
        boolean collNeedsRecursive = this.adjustRecursiveOption(effectiveAbsPath, recursive);
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetPermission(collNeedsRecursive, zone, effectiveAbsPath, userName, "read");
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void setAccessPermissionReadAsAdmin(String zone, String absolutePath, String userName, boolean recursive) throws JargonException {
        if (zone == null) {
            throw new IllegalArgumentException("null zone");
        }
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePath");
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        log.info("setAccessPermissionReadAsAdmin on absPath:{}", (Object)absolutePath);
        String effectiveAbsPath = this.resolveAbsolutePathViaObjStat(absolutePath);
        boolean collNeedsRecursive = this.adjustRecursiveOption(effectiveAbsPath, recursive);
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetPermissionInAdminMode(collNeedsRecursive, zone, effectiveAbsPath, userName, "read");
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void setAccessPermission(String zone, String absolutePath, String userName, boolean recursive, FilePermissionEnum filePermission) throws JargonException {
        if (zone == null) {
            throw new IllegalArgumentException("null zone");
        }
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePath");
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        if (filePermission == null) {
            throw new IllegalArgumentException("null filePermission");
        }
        if (filePermission == FilePermissionEnum.OWN) {
            this.setAccessPermissionOwn(zone, absolutePath, userName, recursive);
        } else if (filePermission == FilePermissionEnum.READ) {
            this.setAccessPermissionRead(zone, absolutePath, userName, recursive);
        } else if (filePermission == FilePermissionEnum.WRITE) {
            this.setAccessPermissionWrite(zone, absolutePath, userName, recursive);
        } else if (filePermission == FilePermissionEnum.NONE) {
            this.removeAccessPermissionForUser(zone, absolutePath, userName, recursive);
        } else {
            throw new JargonException("Cannot update permission, currently only READ, WRITE, and OWN, and NONE are supported");
        }
    }

    @Override
    public void setAccessPermissionWrite(String zone, String absolutePath, String userName, boolean recursive) throws JargonException {
        if (zone == null) {
            throw new IllegalArgumentException("null zone");
        }
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePath");
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        log.info("setAccessPermissionWrite on absPath:{}", (Object)absolutePath);
        String effectiveAbsPath = this.resolveAbsolutePathViaObjStat(absolutePath);
        boolean collNeedsRecursive = this.adjustRecursiveOption(effectiveAbsPath, recursive);
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetPermission(collNeedsRecursive, zone, effectiveAbsPath, userName, "write");
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void setAccessPermissionWriteAsAdmin(String zone, String absolutePath, String userName, boolean recursive) throws JargonException {
        if (zone == null) {
            throw new IllegalArgumentException("null zone");
        }
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePath");
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        log.info("setAccessPermissionWriteAsAdmin on absPath:{}", (Object)absolutePath);
        String effectiveAbsPath = this.resolveAbsolutePathViaObjStat(absolutePath);
        boolean collNeedsRecursive = this.adjustRecursiveOption(effectiveAbsPath, recursive);
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetPermissionInAdminMode(collNeedsRecursive, zone, effectiveAbsPath, userName, "write");
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void setAccessPermissionOwn(String zone, String absolutePath, String userName, boolean recursive) throws JargonException {
        if (zone == null) {
            throw new IllegalArgumentException("null zone");
        }
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePath");
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        log.info("setAccessPermissionOwn on absPath:{}", (Object)absolutePath);
        String effectiveAbsPath = this.resolveAbsolutePathViaObjStat(absolutePath);
        boolean collNeedsRecursive = this.adjustRecursiveOption(effectiveAbsPath, recursive);
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetPermission(collNeedsRecursive, zone, effectiveAbsPath, userName, "own");
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void setAccessPermissionOwnAsAdmin(String zone, String absolutePath, String userName, boolean recursive) throws JargonException {
        if (zone == null) {
            throw new IllegalArgumentException("null zone");
        }
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePath");
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        log.info("setAccessPermissionOwnAsAdmin on absPath:{}", (Object)absolutePath);
        String effectiveAbsPath = this.resolveAbsolutePathViaObjStat(absolutePath);
        boolean collNeedsRecursive = this.adjustRecursiveOption(effectiveAbsPath, recursive);
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetPermissionInAdminMode(collNeedsRecursive, zone, effectiveAbsPath, userName, "own");
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void removeAccessPermissionForUser(String zone, String absolutePath, String userName, boolean recursive) throws JargonException {
        if (zone == null) {
            throw new IllegalArgumentException("null zone");
        }
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePath");
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        log.info("removeAccessPermission on absPath:{}", (Object)absolutePath);
        log.info("for user:{}", (Object)userName);
        String effectiveAbsPath = this.resolveAbsolutePathViaObjStat(absolutePath);
        boolean collNeedsRecursive = this.adjustRecursiveOption(effectiveAbsPath, recursive);
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetPermission(collNeedsRecursive, zone, effectiveAbsPath, userName, "null");
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void removeAccessPermissionForUserAsAdmin(String zone, String absolutePath, String userName, boolean recursive) throws JargonException {
        if (zone == null) {
            throw new IllegalArgumentException("null zone");
        }
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePath");
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        log.info("removeAccessPermissionAsAdmin on absPath:{}", (Object)absolutePath);
        log.info("for user:{}", (Object)userName);
        String effectiveAbsPath = this.resolveAbsolutePathViaObjStat(absolutePath);
        boolean collNeedsRecursive = this.adjustRecursiveOption(effectiveAbsPath, recursive);
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetPermissionInAdminMode(collNeedsRecursive, zone, effectiveAbsPath, userName, "null");
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public boolean isCollectionSetForPermissionInheritance(String absolutePath) throws FileNotFoundException, JargonException {
        IRODSQueryResultSet resultSet;
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePathToCollection");
        }
        ObjStat objStat = this.getObjectStatForAbsolutePath(absolutePath);
        String absPath = this.resolveAbsolutePathGivenObjStat(objStat);
        IRODSGenQueryExecutor irodsGenQueryExecutor = this.getIRODSAccessObjectFactory().getIRODSGenQueryExecutor(this.getIRODSAccount());
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
        CollectionAOHelper.buildInheritanceQueryForCollectionAbsolutePath(absPath, builder);
        try {
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(1);
            resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResultInZone(irodsQuery, 0, MiscIRODSUtils.getZoneInPath(absPath));
        }
        catch (JargonQueryException e) {
            throw new JargonException("error querying for inheritance flag", e);
        }
        catch (GenQueryBuilderException e) {
            throw new JargonException("error querying for inheritance flag", e);
        }
        String inheritanceFlag = resultSet.getFirstResult().getColumn(0);
        boolean returnInheritanceVal = false;
        if (inheritanceFlag.trim().equals("1")) {
            returnInheritanceVal = true;
        }
        return returnInheritanceVal;
    }

    @Override
    public FilePermissionEnum getPermissionForCollection(String irodsAbsolutePath, String userName, String zone) throws FileNotFoundException, JargonException {
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsAbsolutePath");
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        if (zone == null) {
            throw new IllegalArgumentException("null zone");
        }
        String myPath = MiscIRODSUtils.checkPathSizeForMax(irodsAbsolutePath);
        log.info("getPermissionForCollection for absPath:{}", (Object)irodsAbsolutePath);
        log.info("userName:{}", (Object)userName);
        UserFilePermission permission = this.getPermissionForUserName(myPath, userName);
        if (permission == null) {
            log.info("no permission found, return 'none'");
            return FilePermissionEnum.NONE;
        }
        log.info("returning permission:{}", (Object)permission);
        return permission.getFilePermissionEnum();
    }

    private boolean adjustRecursiveOption(String absolutePath, boolean recursive) throws FileNotFoundException, JargonException {
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePath");
        }
        String myPath = MiscIRODSUtils.checkPathSizeForMax(absolutePath);
        IRODSFile collFile = this.getIRODSFileFactory().instanceIRODSFile(myPath);
        if (!collFile.exists()) {
            throw new JargonException("irodsFile does not exist for given path, cannot set permissions on it");
        }
        boolean collNeedsRecursive = recursive;
        CollectionAndDataObjectListAndSearchAO collectionAndDataObjectListAndSearchAO = this.getIRODSAccessObjectFactory().getCollectionAndDataObjectListAndSearchAO(this.getIRODSAccount());
        int countFilesUnderParent = collectionAndDataObjectListAndSearchAO.countDataObjectsAndCollectionsUnderPath(myPath);
        if (recursive && countFilesUnderParent == 0) {
            log.info("overridding recursive flag, file has no children");
            collNeedsRecursive = false;
        }
        return collNeedsRecursive;
    }

    @Override
    public UserFilePermission getPermissionForUserName(String irodsCollectionAbsolutePath, String userName) throws FileNotFoundException, JargonException {
        if (irodsCollectionAbsolutePath == null || irodsCollectionAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsCollectionAbsolutePath");
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        log.info("getPermissionForUserName with irodsCollectionAbsolutePath: {}", (Object)irodsCollectionAbsolutePath);
        log.info("   userName:{}", (Object)userName);
        ObjStat objStat = this.getObjectStatForAbsolutePath(irodsCollectionAbsolutePath);
        String absPath = this.resolveAbsolutePathGivenObjStat(objStat);
        UserFilePermission userFilePermission = this.getPermissionViaGenQuery(userName, absPath);
        UserFilePermission groupFilePermission = this.getPermissionViaSpecQueryAsGroupMember(userName, objStat, absPath);
        return this.scoreAndReturnHighestPermission(userFilePermission, groupFilePermission);
    }

    private UserFilePermission getPermissionViaSpecQueryAsGroupMember(String userName, ObjStat objStat, String absPath) throws JargonException {
        log.info("see if there is a permission based on group membership...");
        UserFilePermission permissionViaGroup = null;
        if (this.getJargonProperties().isUsingSpecQueryForDataObjPermissionsForUserInGroup()) {
            log.info("is set to use specific query for group permissions via isUsingSpecQueryForDataObjPermissionsForUserInGroup()");
            permissionViaGroup = this.findPermissionForUserGrantedThroughUserGroup(userName, MiscIRODSUtils.getZoneInPath(absPath), objStat.determineAbsolutePathBasedOnCollTypeInObjectStat());
            return permissionViaGroup;
        }
        log.info("no group membership data found, not using specific query");
        return null;
    }

    private UserFilePermission findPermissionForUserGrantedThroughUserGroup(String userName, String zone, String absPath) throws JargonException {
        log.info("findPermissionForUserGrantedThroughUserGroup()");
        IRODSFile collFile = this.getIRODSFileFactory().instanceIRODSFile(absPath);
        SpecificQueryAO specificQueryAO = this.getIRODSAccessObjectFactory().getSpecificQueryAO(this.getIRODSAccount());
        if (!specificQueryAO.isSupportsSpecificQuery()) {
            log.info("no specific query support, so just return null");
            return null;
        }
        ArrayList<String> arguments = new ArrayList<String>(2);
        arguments.add(collFile.getAbsolutePath());
        arguments.add(userName);
        SpecificQuery specificQuery = SpecificQuery.instanceArguments("listUserACLForCollectionViaGroup", arguments, 0, zone);
        UserFilePermission userFilePermission = null;
        try {
            IRODSQueryResultRow row = null;
            try {
                SpecificQueryResultSet specificQueryResultSet = specificQueryAO.executeSpecificQueryUsingAlias(specificQuery, this.getJargonProperties().getMaxFilesAndDirsQueryMax(), 0);
                row = specificQueryResultSet.getFirstResult();
                userFilePermission = this.buildUserFilePermissionFromResultRow(row);
            }
            catch (DataNotFoundException dnf) {
                log.info("no result, return null");
                return null;
            }
        }
        catch (JargonQueryException e) {
            log.error("jargon query exception looking up permission via specific query", (Throwable)e);
            throw new JargonException(e);
        }
        return userFilePermission;
    }

    private UserFilePermission buildUserFilePermissionFromResultRow(IRODSQueryResultRow row) throws JargonException {
        UserFilePermission userFilePermission = new UserFilePermission(row.getColumn(0), row.getColumn(1), FilePermissionEnum.valueOf(IRODSDataConversionUtil.getIntOrZeroFromIRODSValue(row.getColumn(2))), UserTypeEnum.findTypeByString(row.getColumn(3)), row.getColumn(4));
        return userFilePermission;
    }

    private UserFilePermission getPermissionViaGenQuery(String userName, String absPath) throws JargonException {
        String theUser = MiscIRODSUtils.getUserInUserName(userName);
        String theZone = MiscIRODSUtils.getZoneInUserName(userName);
        IRODSGenQueryExecutor irodsGenQueryExecutor = this.getIRODSAccessObjectFactory().getIRODSGenQueryExecutor(this.getIRODSAccount());
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
        CollectionAOHelper.buildACLQueryForCollectionName(absPath, builder);
        builder.addConditionAsGenQueryField(RodsGenQueryEnum.COL_COLL_ACCESS_USER_NAME, QueryConditionOperators.EQUAL, theUser.trim());
        if (!theZone.isEmpty()) {
            builder.addConditionAsGenQueryField(RodsGenQueryEnum.COL_COLL_ACCESS_USER_ZONE, QueryConditionOperators.EQUAL, theZone.trim());
        }
        UserAO userAO = this.getIRODSAccessObjectFactory().getUserAO(this.getIRODSAccount());
        User user = null;
        try {
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(this.getJargonProperties().getMaxFilesAndDirsQueryMax());
            IRODSQueryResultSet resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResultInZone(irodsQuery, 0, MiscIRODSUtils.getZoneInPath(absPath));
            IRODSQueryResultRow row = resultSet.getFirstResult();
            user = userAO.findByIdInZone(row.getColumn(2), this.getIRODSAccount().getZone());
            StringBuilder userAndZone = null;
            String displayUserName = null;
            userAndZone = new StringBuilder(row.getColumn(0));
            userAndZone.append('#');
            userAndZone.append(row.getColumn(1));
            displayUserName = row.getColumn(1).equals(MiscIRODSUtils.getZoneInPath(absPath)) ? row.getColumn(0) : userAndZone.toString();
            UserFilePermission userFilePermission = new UserFilePermission(displayUserName, row.getColumn(2), FilePermissionEnum.valueOf(IRODSDataConversionUtil.getIntOrZeroFromIRODSValue(row.getColumn(3))), user.getUserType(), row.getColumn(1));
            log.info("loaded filePermission:{}", (Object)userFilePermission);
            return userFilePermission;
        }
        catch (JargonQueryException e) {
            log.error("query exception for  query", (Throwable)e);
            throw new JargonException("error in query loading user file permissions for collection", e);
        }
        catch (DataNotFoundException dnf) {
            log.info("no data found for user ACL");
            return null;
        }
        catch (GenQueryBuilderException e) {
            log.error("query exception for  query", (Throwable)e);
            throw new JargonException("error in query loading user file permissions for collection", e);
        }
    }

    @Override
    public List<UserFilePermission> listPermissionsForCollection(String irodsCollectionAbsolutePath) throws FileNotFoundException, JargonException {
        if (irodsCollectionAbsolutePath == null || irodsCollectionAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty collectionAbsolutePath");
        }
        log.info("listPermissionsForCollection: {}", (Object)irodsCollectionAbsolutePath);
        ObjStat objStat = this.getObjectStatForAbsolutePath(irodsCollectionAbsolutePath);
        String absPath = this.resolveAbsolutePathGivenObjStat(objStat);
        String zoneName = MiscIRODSUtils.getZoneInPath(absPath);
        ArrayList<UserFilePermission> userFilePermissions = new ArrayList<UserFilePermission>();
        IRODSGenQueryExecutor irodsGenQueryExecutor = this.getIRODSAccessObjectFactory().getIRODSGenQueryExecutor(this.getIRODSAccount());
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
        CollectionAOHelper.buildACLQueryForCollectionName(absPath, builder);
        UserAO userAO = this.getIRODSAccessObjectFactory().getUserAO(this.getIRODSAccount());
        User user = null;
        try {
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(this.getJargonProperties().getMaxFilesAndDirsQueryMax());
            IRODSQueryResultSet resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResultInZone(irodsQuery, 0, zoneName);
            UserFilePermission userFilePermission = null;
            for (IRODSQueryResultRow row : resultSet.getResults()) {
                user = userAO.findByIdInZone(row.getColumn(2), zoneName);
                userFilePermission = new UserFilePermission(row.getColumn(0), row.getColumn(2), FilePermissionEnum.valueOf(IRODSDataConversionUtil.getIntOrZeroFromIRODSValue(row.getColumn(3))), user.getUserType(), row.getColumn(1));
                log.debug("loaded filePermission:{}", (Object)userFilePermission);
                userFilePermissions.add(userFilePermission);
            }
        }
        catch (JargonQueryException e) {
            log.error("query exception for  query", (Throwable)e);
            throw new JargonException("error in query loading user file permissions for collection", e);
        }
        catch (GenQueryBuilderException e) {
            log.error("query exception for  query", (Throwable)e);
            throw new JargonException("error in query loading user file permissions for collection", e);
        }
        return userFilePermissions;
    }

    @Override
    public boolean isUserHasAccess(String irodsAbsolutePath, String userName) throws JargonException {
        log.info("isUserHasAccess()");
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsAbsolutePath");
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        String myPath = MiscIRODSUtils.checkPathSizeForMax(irodsAbsolutePath);
        log.info("irodsAbsolutePath:{}", (Object)irodsAbsolutePath);
        log.info("userName:{}", (Object)userName);
        UserFilePermission derivedPermission = this.getPermissionForUserName(myPath, userName);
        boolean hasPermission = false;
        if (derivedPermission != null) {
            hasPermission = true;
        }
        log.info("has permision? {}", (Object)hasPermission);
        return hasPermission;
    }

    @Override
    public void replicateCollectionAsynchronously(String irodsCollectionAbsolutePath, String resourceName, int delayInMinutes) throws JargonException {
        log.info("replicateCollectionAsynchronously()");
        if (irodsCollectionAbsolutePath == null || irodsCollectionAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsCollectionAbsolutePath");
        }
        if (resourceName == null || resourceName.isEmpty()) {
            throw new IllegalArgumentException("null or empty resourceName");
        }
        if (delayInMinutes <= 0) {
            throw new IllegalArgumentException("delay in minutes must be > 0");
        }
        log.info("irodsCollectionAbsolutePath:{}", (Object)irodsCollectionAbsolutePath);
        log.info("resourceName:{}", (Object)resourceName);
        log.info("delayInMinutes:{}", (Object)delayInMinutes);
        if (!this.getIRODSServerProperties().isTheIrodsServerAtLeastAtTheGivenReleaseVersion("rods3.0")) {
            throw new JargonException("service not available on servers prior to rods3.0");
        }
        RuleProcessingAO ruleProcessingAO = this.getIRODSAccessObjectFactory().getRuleProcessingAO(this.getIRODSAccount());
        ArrayList<IRODSRuleParameter> irodsRuleParameters = new ArrayList<IRODSRuleParameter>();
        irodsRuleParameters.add(new IRODSRuleParameter("*SourceFile", MiscIRODSUtils.wrapStringInQuotes(irodsCollectionAbsolutePath)));
        irodsRuleParameters.add(new IRODSRuleParameter("*Resource", MiscIRODSUtils.wrapStringInQuotes(resourceName)));
        irodsRuleParameters.add(new IRODSRuleParameter("*DelayInfo", RuleUtils.buildDelayParamForMinutes(delayInMinutes)));
        IRODSRuleExecResult result = ruleProcessingAO.executeRuleFromResource("/rules/rulemsiCollReplAsync.r", irodsRuleParameters, RuleProcessingAO.RuleProcessingType.EXTERNAL);
        log.info("result of action:{}", (Object)result.getRuleExecOut().trim());
    }
}

