/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.packinstr;

import java.util.ArrayList;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.AbstractIRODSPackingInstruction;
import org.irods.jargon.core.packinstr.ChecksumOptions;
import org.irods.jargon.core.packinstr.KeyValuePair;
import org.irods.jargon.core.packinstr.Tag;

public class DataObjInpForChecksum
extends AbstractIRODSPackingInstruction {
    public static final String PI_TAG = "DataObjInp_PI";
    public static final String MY_STR = "myStr";
    public static final String FORCE_CHECKSUM_KW = "forceChecksum";
    public static final String VERIFY_CHECKSUM_KW = "verifyChecksum";
    public static final String CHECKSUM_ALL_KW = "chksumAll";
    public static final String REPL_NUM_KW = "replNum";
    public static final String RESC_NAME_KW = "rescName";
    public static final String TRANSLATED_PATH_KW = "translatedPath";
    public static final int CHECKSUM_API_NBR = 629;
    private String fileAbsolutePath = "";
    private final ChecksumOptions checksumOptions;
    private final String resourceName;
    private final int replicaNumber;

    private DataObjInpForChecksum(String fileAbsolutePath, String resourceName, int replicaNumber, ChecksumOptions checksumOptions) {
        if (fileAbsolutePath == null || fileAbsolutePath.length() == 0) {
            throw new IllegalArgumentException("file absolute path is null or empty");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("resourceName is null, may be set to blank if not required");
        }
        if (checksumOptions == null) {
            throw new IllegalArgumentException("checksumOptions is null");
        }
        this.fileAbsolutePath = fileAbsolutePath;
        this.checksumOptions = checksumOptions;
        this.replicaNumber = replicaNumber;
        this.resourceName = resourceName;
    }

    @Override
    public Tag getTagValue() throws JargonException {
        Tag message = new Tag(PI_TAG, new Tag[]{new Tag("objPath", this.getFileAbsolutePath()), new Tag("createMode", 0), new Tag("openFlags", 0), new Tag("offset", 0), new Tag("dataSize", 0), new Tag("numThreads", 0), new Tag("oprType", 0)});
        ArrayList<KeyValuePair> kvps = new ArrayList<KeyValuePair>();
        if (this.checksumOptions.isForce()) {
            kvps.add(KeyValuePair.instance(FORCE_CHECKSUM_KW, ""));
        }
        if (this.checksumOptions.isChecksumAllReplicas()) {
            kvps.add(KeyValuePair.instance(CHECKSUM_ALL_KW, ""));
        }
        if (this.checksumOptions.isVerifyChecksumInIcat()) {
            kvps.add(KeyValuePair.instance(VERIFY_CHECKSUM_KW, ""));
        }
        if (this.checksumOptions.isRecursive()) {
            kvps.add(KeyValuePair.instance(TRANSLATED_PATH_KW, ""));
        }
        if (!this.resourceName.isEmpty()) {
            kvps.add(KeyValuePair.instance(RESC_NAME_KW, this.resourceName));
        } else if (this.replicaNumber > -1) {
            kvps.add(KeyValuePair.instance(REPL_NUM_KW, this.resourceName));
        }
        message.addTag(this.createKeyValueTag(kvps));
        return message;
    }

    public String getFileAbsolutePath() {
        return this.fileAbsolutePath;
    }
}

