/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.packinstr;

import java.util.ArrayList;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.AbstractIRODSPackingInstruction;
import org.irods.jargon.core.packinstr.DataObjInp;
import org.irods.jargon.core.packinstr.KeyValuePair;
import org.irods.jargon.core.packinstr.Tag;

public class DataObjCopyInp
extends AbstractIRODSPackingInstruction {
    public static final String PI_TAG = "DataObjCopyInp_PI";
    public static final int RENAME_API_NBR = 601;
    public static final int RENAME_FILE_API_NBR = 627;
    public static final int COPY_API_NBR = 613;
    public static final int COPY_API_NBR_410 = 696;
    private final String fromFileAbsolutePath;
    private final String toFileAbsolutePath;
    private final int operationType;
    private final String resourceName;
    private final long sourceFileLength;
    private final boolean force;

    public static final DataObjCopyInp instanceForRenameFile(String sourceFileAbsolutePath, String targetFileAbsolutePath) throws JargonException {
        DataObjCopyInp dataObjCopyInp = new DataObjCopyInp(627, sourceFileAbsolutePath, targetFileAbsolutePath, 11, "", 0L, false);
        return dataObjCopyInp;
    }

    public static final DataObjCopyInp instanceForCopy410(String sourceFileAbsolutePath, String targetFileAbsolutePath, String copyToResource, long sourceFileLength, boolean force) throws JargonException {
        DataObjCopyInp dataObjCopyInp = new DataObjCopyInp(696, sourceFileAbsolutePath, targetFileAbsolutePath, 10, copyToResource, sourceFileLength, force);
        return dataObjCopyInp;
    }

    public static final DataObjCopyInp instanceForCopy(String sourceFileAbsolutePath, String targetFileAbsolutePath, String copyToResource, long sourceFileLength, boolean force) throws JargonException {
        DataObjCopyInp dataObjCopyInp = new DataObjCopyInp(613, sourceFileAbsolutePath, targetFileAbsolutePath, 10, copyToResource, sourceFileLength, force);
        return dataObjCopyInp;
    }

    public static final DataObjCopyInp instanceForRenameCollection(String sourceFileAbsolutePath, String targetFileAbsolutePath) throws JargonException {
        DataObjCopyInp dataObjCopyInp = new DataObjCopyInp(627, sourceFileAbsolutePath, targetFileAbsolutePath, 12, "", 0L, false);
        return dataObjCopyInp;
    }

    public static final DataObjCopyInp instanceForCopyCollection(String sourceFileAbsolutePath, String targetFileAbsolutePath, String targetResourceName, long sourceFileLength, boolean force) throws JargonException {
        DataObjCopyInp dataObjCopyInp = new DataObjCopyInp(613, sourceFileAbsolutePath, targetFileAbsolutePath, 10, targetResourceName, sourceFileLength, force);
        return dataObjCopyInp;
    }

    private DataObjCopyInp(int apiNumber, String fromFileAbsolutePath, String toFileAbsolutePath, int operationType, String resourceName, long sourceFileLength, boolean force) throws JargonException {
        if (fromFileAbsolutePath == null || fromFileAbsolutePath.length() == 0) {
            throw new IllegalArgumentException("from file absolute path is null or empty");
        }
        if (toFileAbsolutePath == null || toFileAbsolutePath.length() == 0) {
            throw new IllegalArgumentException("to file absolute path is null or empty");
        }
        if (operationType != 12 && operationType != 11 && operationType != 10) {
            throw new IllegalArgumentException("unknown operation type:" + operationType);
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("null resourceName");
        }
        if (sourceFileLength < 0L) {
            throw new IllegalArgumentException("negative sourceFileLength");
        }
        this.setApiNumber(apiNumber);
        this.fromFileAbsolutePath = fromFileAbsolutePath;
        this.toFileAbsolutePath = toFileAbsolutePath;
        this.operationType = operationType;
        this.resourceName = resourceName;
        this.sourceFileLength = sourceFileLength;
        this.force = force;
    }

    private Tag buildDataObjInpTag(String filePath, int operationType) throws JargonException {
        ArrayList<KeyValuePair> kvps = new ArrayList<KeyValuePair>();
        Tag fileTag = new Tag("DataObjInp_PI", new Tag[]{new Tag("objPath", filePath), new Tag("createMode", 0), new Tag("openFlags", 0), new Tag("offset", 0), new Tag("dataSize", 0), new Tag("numThreads", 0), new Tag("oprType", operationType), this.createKeyValueTag(kvps)});
        return fileTag;
    }

    @Override
    public Tag getTagValue() throws JargonException {
        if (this.getApiNumber() == 613 || this.getApiNumber() == 696) {
            return this.getTagValueForCopy();
        }
        return this.getTagValueForReplicate();
    }

    private Tag getTagValueForReplicate() throws JargonException {
        Tag fromFileTag = this.buildDataObjInpTag(this.fromFileAbsolutePath, this.operationType);
        Tag toFileTag = this.buildDataObjInpTag(this.toFileAbsolutePath, this.operationType);
        Tag message = new Tag(PI_TAG, new Tag[]{fromFileTag, toFileTag});
        return message;
    }

    private Tag getTagValueForCopy() throws JargonException {
        Tag fromFileTag = this.buildDataObjInpTagForCopySource(this.fromFileAbsolutePath, this.sourceFileLength);
        Tag toFileTag = this.buildDataObjInpTagForCopyDest(this.toFileAbsolutePath, this.resourceName, this.force);
        Tag message = new Tag(PI_TAG, new Tag[]{fromFileTag, toFileTag});
        return message;
    }

    private Tag buildDataObjInpTagForCopySource(String fromFileAbsolutePath, long sourceFileLength) throws JargonException {
        ArrayList<KeyValuePair> kvps = new ArrayList<KeyValuePair>();
        Tag fileTag = new Tag("DataObjInp_PI", new Tag[]{new Tag("objPath", fromFileAbsolutePath), new Tag("createMode", 0), new Tag("openFlags", 0), new Tag("offset", 0), new Tag("dataSize", sourceFileLength), new Tag("numThreads", 0), new Tag("oprType", 10), this.createKeyValueTag(kvps)});
        return fileTag;
    }

    private Tag buildDataObjInpTagForCopyDest(String destFileAbsolutePath, String destResource, boolean overwrite) throws JargonException {
        DataObjInp dataObjInp = DataObjInp.instanceForCopyDest(destFileAbsolutePath, destResource, overwrite);
        return dataObjInp.getTagValue();
    }

    public String getFromFileAbsolutePath() {
        return this.fromFileAbsolutePath;
    }

    public String getToFileAbsolutePath() {
        return this.toFileAbsolutePath;
    }

    public int getOperationType() {
        return this.operationType;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public long getSourceFileLength() {
        return this.sourceFileLength;
    }
}

