/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import org.irods.jargon.core.connection.IrodsVersion;
import org.irods.jargon.core.connection.NegotiatedClientServerConfiguration;

public class StartupResponseData {
    private final int status;
    private final String relVersion;
    private final String apiVersion;
    private final int reconnPort;
    private final String reconnAddr;
    private final String cookie;
    private NegotiatedClientServerConfiguration negotiatedClientServerConfiguration = new NegotiatedClientServerConfiguration(false);

    public StartupResponseData(int status, String relVersion, String apiVersion, int reconnPort, String reconnAddr, String cookie) {
        if (relVersion == null || relVersion.isEmpty()) {
            throw new IllegalArgumentException("null or empty relVersion");
        }
        if (apiVersion == null || apiVersion.isEmpty()) {
            throw new IllegalArgumentException("null or empty apiVersion");
        }
        if (reconnAddr == null) {
            throw new IllegalArgumentException("null reconnAddr");
        }
        if (cookie == null) {
            throw new IllegalArgumentException("null cookie");
        }
        this.status = status;
        this.relVersion = relVersion;
        this.apiVersion = apiVersion;
        this.reconnPort = reconnPort;
        this.reconnAddr = reconnAddr;
        this.cookie = cookie;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("StartupResponseData:");
        sb.append("\n   status:");
        sb.append(this.status);
        sb.append("\n   relVersion:");
        sb.append(this.relVersion);
        sb.append("\n   apiVersion:");
        sb.append(this.apiVersion);
        sb.append("\n   reconnPort:");
        sb.append(this.reconnPort);
        sb.append("\n   reconnAddr:");
        sb.append(this.reconnAddr);
        sb.append("\n   cookie:");
        sb.append(this.cookie);
        return sb.toString();
    }

    public int getStatus() {
        return this.status;
    }

    public String getRelVersion() {
        return this.relVersion;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public int getReconnPort() {
        return this.reconnPort;
    }

    public String getReconnAddr() {
        return this.reconnAddr;
    }

    public String getCookie() {
        return this.cookie;
    }

    public boolean checkIs410OrLater() {
        IrodsVersion irodsVersion = new IrodsVersion(this.getRelVersion());
        return irodsVersion.compareTo(new IrodsVersion("rods4.1.0")) >= 0;
    }

    public NegotiatedClientServerConfiguration getNegotiatedClientServerConfiguration() {
        return this.negotiatedClientServerConfiguration;
    }

    public void setNegotiatedClientServerConfiguration(NegotiatedClientServerConfiguration negotiatedClientServerConfiguration) {
        this.negotiatedClientServerConfiguration = negotiatedClientServerConfiguration;
    }
}

