/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.X509TrustManager;
import org.irods.jargon.core.checksum.LocalChecksumComputerFactory;
import org.irods.jargon.core.checksum.LocalChecksumComputerFactoryImpl;
import org.irods.jargon.core.connection.AbstractIRODSMidLevelProtocol;
import org.irods.jargon.core.connection.AuthScheme;
import org.irods.jargon.core.connection.DefaultPropertiesJargonConfig;
import org.irods.jargon.core.connection.DiscoveredServerPropertiesCache;
import org.irods.jargon.core.connection.GSIIRODSAccount;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSProtocolManager;
import org.irods.jargon.core.connection.JargonProperties;
import org.irods.jargon.core.connection.PipelineConfiguration;
import org.irods.jargon.core.connection.RejectedParallelThreadExecutionHandler;
import org.irods.jargon.core.connection.SettableJargonProperties;
import org.irods.jargon.core.connection.SslConnectionUtilities;
import org.irods.jargon.core.connection.TrustAllX509TrustManager;
import org.irods.jargon.core.exception.AuthenticationException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.JargonRuntimeException;
import org.irods.jargon.core.packinstr.TransferOptions;
import org.irods.jargon.core.pub.IRODSGenQueryExecutorImpl;
import org.irods.jargon.core.query.GenQueryBuilderException;
import org.irods.jargon.core.query.GenQueryProcessor;
import org.irods.jargon.core.query.IRODSGenQueryBuilder;
import org.irods.jargon.core.query.IRODSGenQueryFromBuilder;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.IRODSQueryResultSet;
import org.irods.jargon.core.query.JargonQueryException;
import org.irods.jargon.core.query.QueryConditionOperators;
import org.irods.jargon.core.query.RodsGenQueryEnum;
import org.irods.jargon.core.query.TranslatedIRODSGenQuery;
import org.irods.jargon.core.transfer.AbstractRestartManager;
import org.irods.jargon.core.transfer.DefaultTransferControlBlock;
import org.irods.jargon.core.transfer.MemoryBasedTransferRestartManager;
import org.irods.jargon.core.transfer.TransferControlBlock;
import org.irods.jargon.core.utils.MiscIRODSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRODSSession {
    private AbstractIRODSMidLevelProtocol irodsMidLevelProtocol = null;
    private ExecutorService parallelTransferThreadPool = null;
    private IRODSProtocolManager irodsProtocolManager;
    private static final Logger log = LoggerFactory.getLogger(IRODSSession.class);
    private X509TrustManager x509TrustManager = null;
    private AbstractRestartManager restartManager = null;
    private JargonProperties jargonProperties;
    private final LocalChecksumComputerFactory localChecksumComputerFactory = new LocalChecksumComputerFactoryImpl();
    private final DiscoveredServerPropertiesCache discoveredServerPropertiesCache = new DiscoveredServerPropertiesCache();

    public synchronized X509TrustManager getX509TrustManager() {
        return this.x509TrustManager;
    }

    public synchronized void setX509TrustManager(X509TrustManager x509TrustManager) {
        this.x509TrustManager = x509TrustManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JargonProperties getJargonProperties() {
        IRODSSession iRODSSession = this;
        synchronized (iRODSSession) {
            return this.jargonProperties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferControlBlock buildDefaultTransferControlBlockBasedOnJargonProperties() throws JargonException {
        TransferControlBlock transferControlBlock = DefaultTransferControlBlock.instance();
        IRODSSession iRODSSession = this;
        synchronized (iRODSSession) {
            transferControlBlock.setTransferOptions(this.buildTransferOptionsBasedOnJargonProperties());
        }
        return transferControlBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PipelineConfiguration buildPipelineConfigurationBasedOnJargonProperties() {
        IRODSSession iRODSSession = this;
        synchronized (iRODSSession) {
            return PipelineConfiguration.instance(this.jargonProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferOptions buildTransferOptionsBasedOnJargonProperties() {
        TransferOptions transferOptions = new TransferOptions();
        IRODSSession iRODSSession = this;
        synchronized (iRODSSession) {
            transferOptions.setMaxThreads(this.jargonProperties.getMaxParallelThreads());
            transferOptions.setUseParallelTransfer(this.jargonProperties.isUseParallelTransfer());
            transferOptions.setAllowPutGetResourceRedirects(this.jargonProperties.isAllowPutGetResourceRedirects());
            transferOptions.setComputeAndVerifyChecksumAfterTransfer(this.jargonProperties.isComputeAndVerifyChecksumAfterTransfer());
            transferOptions.setComputeChecksumAfterTransfer(this.jargonProperties.isComputeChecksumAfterTransfer());
            transferOptions.setIntraFileStatusCallbacks(this.jargonProperties.isIntraFileStatusCallbacks());
            transferOptions.setIntraFileStatusCallbacksNumberCallsInterval(this.jargonProperties.getIntraFileStatusCallbacksNumberCallsInterval());
            transferOptions.setIntraFileStatusCallbacksTotalBytesInterval(this.jargonProperties.getIntraFileStatusCallbacksTotalBytesInterval());
            transferOptions.setChecksumEncoding(this.jargonProperties.getChecksumEncoding());
        }
        log.debug("transfer options based on properties:{}", (Object)transferOptions);
        return transferOptions;
    }

    public void closeSession() throws JargonException {
        log.debug("found and am closing connection to : {}", (Object)this.irodsMidLevelProtocol.getIrodsAccount().toString());
        this.getIrodsProtocolManager().returnIRODSProtocol(this.irodsMidLevelProtocol);
    }

    public IRODSSession(JargonProperties jargonProperties) {
        log.info("IRODSSession(jargonProperties) with properties of: {}", (Object)jargonProperties);
        if (jargonProperties == null) {
            throw new IllegalArgumentException("null jargonProperties");
        }
        this.jargonProperties = jargonProperties;
        this.checkInitTrustManager();
    }

    public IRODSSession() {
        log.debug("IRODS Session creation, loading default properties, these may be overridden...");
        try {
            this.jargonProperties = new SettableJargonProperties(new DefaultPropertiesJargonConfig());
            if (this.jargonProperties.isLongTransferRestart()) {
                this.restartManager = new MemoryBasedTransferRestartManager();
            }
            log.info("setting system prop for TLS...");
        }
        catch (Exception e) {
            log.warn("unable to load default jargon properties", (Throwable)e);
            throw new JargonRuntimeException("unable to load jargon props", e);
        }
        this.checkInitTrustManager();
    }

    private void checkInitTrustManager() {
        log.info("checkInitTrustManager()");
        if (this.getJargonProperties().isBypassSslCertChecks()) {
            log.warn(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            log.warn("setting trustAllX509TrustManager, not recommended for production!!!");
            log.warn(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            this.setX509TrustManager(new TrustAllX509TrustManager());
        }
    }

    public IRODSSession(IRODSProtocolManager irodsConnectionManager) throws JargonException {
        this();
        if (irodsConnectionManager == null) {
            throw new JargonException("irods connection manager cannot be null");
        }
        this.irodsProtocolManager = irodsConnectionManager;
    }

    public static IRODSSession instance(IRODSProtocolManager irodsConnectionManager) throws JargonException {
        return new IRODSSession(irodsConnectionManager);
    }

    public AbstractIRODSMidLevelProtocol currentConnection(IRODSAccount irodsAccount) throws JargonException {
        if (this.irodsProtocolManager == null) {
            log.error("no irods connection manager provided");
            throw new JargonRuntimeException("IRODSSession improperly initialized, requires the IRODSConnectionManager to be initialized");
        }
        if (irodsAccount == null) {
            log.error("irodsAccount is null in connection");
            throw new IllegalArgumentException("irodsAccount is null");
        }
        if (this.irodsMidLevelProtocol == null) {
            this.irodsMidLevelProtocol = this.connect(irodsAccount);
            return this.irodsMidLevelProtocol;
        }
        if (this.irodsMidLevelProtocol.isConnected()) {
            log.debug("session using previously established connection:{}", (Object)this.irodsMidLevelProtocol);
        } else {
            log.warn("***************** session has a connection marked closed, create a new one and put back into the cache:{}", (Object)this.irodsMidLevelProtocol);
            this.irodsMidLevelProtocol = this.connect(irodsAccount);
        }
        return this.irodsMidLevelProtocol;
    }

    public AbstractIRODSMidLevelProtocol currentConnectionCheckRenewalOfSocket(IRODSAccount irodsAccount) throws AuthenticationException, JargonException {
        log.info("renewConnection()");
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null irodsAccount");
        }
        AbstractIRODSMidLevelProtocol irodsMidLevelProtocol = this.currentConnection(irodsAccount);
        log.info("evaluate conn for renewal:{}", (Object)irodsAccount);
        boolean shutdown = this.evaluateConnectionForRenewal(irodsMidLevelProtocol);
        if (!shutdown) {
            return irodsMidLevelProtocol;
        }
        log.info("return a refreshed connection");
        return this.currentConnection(irodsAccount);
    }

    private boolean evaluateConnectionForRenewal(AbstractIRODSMidLevelProtocol irodsMidLevelProtocol) throws AuthenticationException, JargonException {
        int renewalInterval = irodsMidLevelProtocol.getPipelineConfiguration().getSocketRenewalIntervalInSeconds();
        if (renewalInterval == 0) {
            return false;
        }
        long renewalWindow = irodsMidLevelProtocol.getConnectTimeInMillis() + (long)(renewalInterval * 1000);
        long currTime = System.currentTimeMillis();
        if (currTime > renewalWindow) {
            log.debug("renewing:{}", (Object)irodsMidLevelProtocol);
            this.closeSession(irodsMidLevelProtocol.getIrodsAccount());
            return true;
        }
        return false;
    }

    private AbstractIRODSMidLevelProtocol connect(IRODSAccount irodsAccount) throws JargonException {
        AbstractIRODSMidLevelProtocol irodsProtocol = this.irodsProtocolManager.getIRODSProtocol(irodsAccount, this.buildPipelineConfigurationBasedOnJargonProperties(), this);
        if (irodsProtocol == null) {
            log.error("no connection returned from connection manager");
            throw new JargonRuntimeException("null connection returned from connection manager");
        }
        if (irodsAccount.getAuthenticationScheme() == AuthScheme.GSI) {
            log.debug("adding user information to iRODS account for GSI");
            this.addUserInfoForGSIAccount(irodsAccount, irodsProtocol);
        }
        log.debug("returned new connection:{}", (Object)irodsProtocol);
        return irodsProtocol;
    }

    private void addUserInfoForGSIAccount(IRODSAccount irodsAccount, AbstractIRODSMidLevelProtocol irodsCommands) throws JargonException {
        log.debug("addUserInfoForGSIAccount()");
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null irodsAccount");
        }
        if (!(irodsAccount instanceof GSIIRODSAccount)) {
            throw new IllegalArgumentException("irodsAccount parameter is not a GSIIRODSAccount");
        }
        GSIIRODSAccount gsiIRODSAccount = (GSIIRODSAccount)irodsAccount;
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
        try {
            String dn = gsiIRODSAccount.getDistinguishedName().trim();
            builder.addSelectAsGenQueryValue(RodsGenQueryEnum.COL_USER_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_USER_ZONE).addConditionAsGenQueryField(RodsGenQueryEnum.COL_USER_DN, QueryConditionOperators.EQUAL, dn);
            GenQueryProcessor genQueryProcessor = new GenQueryProcessor(irodsCommands);
            IRODSGenQueryFromBuilder query = builder.exportIRODSQueryFromBuilder(1);
            TranslatedIRODSGenQuery translatedIRODSQuery = genQueryProcessor.translateProvidedQuery(query);
            IRODSQueryResultSet resultSet = genQueryProcessor.executeTranslatedIRODSQuery(translatedIRODSQuery, 0, 0, IRODSGenQueryExecutorImpl.QueryCloseBehavior.AUTO_CLOSE, "");
            IRODSQueryResultRow row = resultSet.getFirstResult();
            gsiIRODSAccount.setUserName(row.getColumn(0));
            gsiIRODSAccount.setZone(row.getColumn(1));
            gsiIRODSAccount.setHomeDirectory(MiscIRODSUtils.computeHomeDirectoryForIRODSAccount(gsiIRODSAccount));
        }
        catch (GenQueryBuilderException e) {
            log.error("error building query for user DN", (Throwable)e);
            throw new JargonException("query builder exception building user DN query", e);
        }
        catch (JargonQueryException e) {
            log.error("error building query for user DN", (Throwable)e);
            throw new JargonException("jargon query  exception building user DN query", e);
        }
    }

    public synchronized IRODSProtocolManager getIrodsConnectionManager() {
        return this.irodsProtocolManager;
    }

    public void setIrodsConnectionManager(IRODSProtocolManager irodsConnectionManager) {
        this.irodsProtocolManager = irodsConnectionManager;
    }

    public void closeSession(IRODSAccount irodsAccount) throws JargonException {
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null irodsAccount");
        }
        if (this.irodsMidLevelProtocol == null) {
            log.warn("closing a connection that is not held, silently ignore");
            return;
        }
        log.debug("found and am closing connection to : {}", (Object)irodsAccount.toString());
        this.getIrodsProtocolManager().returnIRODSProtocol(this.irodsMidLevelProtocol);
        this.irodsMidLevelProtocol = null;
    }

    public void discardSessionForErrors(IRODSAccount irodsAccount) {
        log.warn("discarding irods session for: {}", (Object)irodsAccount.toString());
        this.getIrodsProtocolManager().returnWithForce(this.irodsMidLevelProtocol);
    }

    public AbstractIRODSMidLevelProtocol getIrodsMidLevelProtocol() {
        return this.irodsMidLevelProtocol;
    }

    public IRODSProtocolManager getIrodsProtocolManager() {
        return this.irodsProtocolManager;
    }

    public void setIrodsProtocolManager(IRODSProtocolManager irodsProtocolManager) {
        this.irodsProtocolManager = irodsProtocolManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService getParallelTransferThreadPool() throws JargonException {
        log.debug("getting the ParallelTransferThreadPool");
        IRODSSession iRODSSession = this;
        synchronized (iRODSSession) {
            if (!this.jargonProperties.isUseTransferThreadsPool()) {
                log.debug("I am not using the parallel transfer threads pool, return null");
                return null;
            }
            if (this.parallelTransferThreadPool != null) {
                log.debug("returning already created ParallelTransferThreadPool");
                return this.parallelTransferThreadPool;
            }
            int poolSize = this.jargonProperties.getTransferThreadPoolMaxSimultaneousTransfers() * this.jargonProperties.getMaxParallelThreads();
            int maxParallelThreads = this.jargonProperties.getMaxParallelThreads();
            log.debug("creating the parallel transfer threads pool");
            log.debug("   max # threads: {}", (Object)maxParallelThreads);
            log.debug("   pool timeout millis:{}", (Object)this.jargonProperties.getTransferThreadPoolTimeoutMillis());
            this.parallelTransferThreadPool = new ThreadPoolExecutor(maxParallelThreads, poolSize, (long)this.jargonProperties.getTransferThreadPoolTimeoutMillis(), TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(poolSize), new RejectedParallelThreadExecutionHandler());
            log.debug("parallelTransferThreadPool created");
            return this.parallelTransferThreadPool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJargonProperties(JargonProperties jargonProperties) {
        IRODSSession iRODSSession = this;
        synchronized (iRODSSession) {
            this.jargonProperties = jargonProperties;
        }
    }

    public DiscoveredServerPropertiesCache getDiscoveredServerPropertiesCache() {
        return this.discoveredServerPropertiesCache;
    }

    public boolean isUsingDynamicServerPropertiesCache() {
        return this.getJargonProperties().isUsingDiscoveredServerPropertiesCache();
    }

    public LocalChecksumComputerFactory getLocalChecksumComputerFactory() {
        return this.localChecksumComputerFactory;
    }

    public synchronized AbstractRestartManager getRestartManager() {
        if (this.restartManager == null && this.jargonProperties.isLongTransferRestart()) {
            log.warn("no restart manager provided, long file restart is on, create default memory based manager");
            this.restartManager = new MemoryBasedTransferRestartManager();
        }
        return this.restartManager;
    }

    public synchronized void setRestartManager(AbstractRestartManager restartManager) {
        this.restartManager = restartManager;
    }

    SslConnectionUtilities instanceSslConnectionUtilities() {
        return new SslConnectionUtilities(this);
    }
}

