/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.files.ExportMetadata;
import com.dropbox.core.v2.files.FileMetadata;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class ExportResult {
    protected final ExportMetadata exportMetadata;
    protected final FileMetadata fileMetadata;

    public ExportResult(ExportMetadata exportMetadata, FileMetadata fileMetadata) {
        if (exportMetadata == null) {
            throw new IllegalArgumentException("Required value for 'exportMetadata' is null");
        }
        this.exportMetadata = exportMetadata;
        if (fileMetadata == null) {
            throw new IllegalArgumentException("Required value for 'fileMetadata' is null");
        }
        this.fileMetadata = fileMetadata;
    }

    public ExportMetadata getExportMetadata() {
        return this.exportMetadata;
    }

    public FileMetadata getFileMetadata() {
        return this.fileMetadata;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.exportMetadata, this.fileMetadata});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            ExportResult other = (ExportResult)obj;
            return !(this.exportMetadata != other.exportMetadata && !this.exportMetadata.equals(other.exportMetadata) || this.fileMetadata != other.fileMetadata && !this.fileMetadata.equals(other.fileMetadata));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    public static class Serializer
    extends StructSerializer<ExportResult> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(ExportResult value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("export_metadata");
            ExportMetadata.Serializer.INSTANCE.serialize(value.exportMetadata, g);
            g.writeFieldName("file_metadata");
            FileMetadata.Serializer.INSTANCE.serialize(value.fileMetadata, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public ExportResult deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            FileMetadata f_fileMetadata;
            ExportMetadata f_exportMetadata;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_exportMetadata = null;
                f_fileMetadata = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("export_metadata".equals(field)) {
                        f_exportMetadata = (ExportMetadata)ExportMetadata.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("file_metadata".equals(field)) {
                        f_fileMetadata = (FileMetadata)FileMetadata.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_exportMetadata == null) {
                    throw new JsonParseException(p, "Required field \"export_metadata\" missing.");
                }
                if (f_fileMetadata == null) {
                    throw new JsonParseException(p, "Required field \"file_metadata\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            ExportResult value = new ExportResult(f_exportMetadata, f_fileMetadata);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

