/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.UpdateAuthTokenRestrictions;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Request model for updating general settings")
public class UpdateGeneralSettings {
    @JsonProperty(value="sharePasswordSmsEnabled")
    private Boolean sharePasswordSmsEnabled = null;
    @JsonProperty(value="cryptoEnabled")
    private Boolean cryptoEnabled = null;
    @JsonProperty(value="emailNotificationButtonEnabled")
    private Boolean emailNotificationButtonEnabled = null;
    @JsonProperty(value="eulaEnabled")
    private Boolean eulaEnabled = null;
    @JsonProperty(value="s3TagsEnabled")
    private Boolean s3TagsEnabled = null;
    @JsonProperty(value="authTokenRestrictions")
    private UpdateAuthTokenRestrictions authTokenRestrictions = null;
    @JsonProperty(value="hideLoginInputFields")
    private Boolean hideLoginInputFields = null;
    @JsonProperty(value="mediaServerEnabled")
    private Boolean mediaServerEnabled = null;
    @JsonProperty(value="weakPasswordEnabled")
    private Boolean weakPasswordEnabled = null;

    public UpdateGeneralSettings sharePasswordSmsEnabled(Boolean sharePasswordSmsEnabled) {
        this.sharePasswordSmsEnabled = sharePasswordSmsEnabled;
        return this;
    }

    @Schema(description="Allow sending of share passwords via SMS")
    public Boolean isSharePasswordSmsEnabled() {
        return this.sharePasswordSmsEnabled;
    }

    public void setSharePasswordSmsEnabled(Boolean sharePasswordSmsEnabled) {
        this.sharePasswordSmsEnabled = sharePasswordSmsEnabled;
    }

    public UpdateGeneralSettings cryptoEnabled(Boolean cryptoEnabled) {
        this.cryptoEnabled = cryptoEnabled;
        return this;
    }

    @Schema(description="Activation status of client-side encryption.  Can only be enabled once; disabling is not possible.")
    public Boolean isCryptoEnabled() {
        return this.cryptoEnabled;
    }

    public void setCryptoEnabled(Boolean cryptoEnabled) {
        this.cryptoEnabled = cryptoEnabled;
    }

    public UpdateGeneralSettings emailNotificationButtonEnabled(Boolean emailNotificationButtonEnabled) {
        this.emailNotificationButtonEnabled = emailNotificationButtonEnabled;
        return this;
    }

    @Schema(description="Enable email notification button")
    public Boolean isEmailNotificationButtonEnabled() {
        return this.emailNotificationButtonEnabled;
    }

    public void setEmailNotificationButtonEnabled(Boolean emailNotificationButtonEnabled) {
        this.emailNotificationButtonEnabled = emailNotificationButtonEnabled;
    }

    public UpdateGeneralSettings eulaEnabled(Boolean eulaEnabled) {
        this.eulaEnabled = eulaEnabled;
        return this;
    }

    @Schema(description="Each user has to confirm the EULA at first login.")
    public Boolean isEulaEnabled() {
        return this.eulaEnabled;
    }

    public void setEulaEnabled(Boolean eulaEnabled) {
        this.eulaEnabled = eulaEnabled;
    }

    public UpdateGeneralSettings s3TagsEnabled(Boolean s3TagsEnabled) {
        this.s3TagsEnabled = s3TagsEnabled;
        return this;
    }

    @Schema(description="&#128640; Since v4.9.0  Defines if S3 tags are enabled")
    public Boolean isS3TagsEnabled() {
        return this.s3TagsEnabled;
    }

    public void setS3TagsEnabled(Boolean s3TagsEnabled) {
        this.s3TagsEnabled = s3TagsEnabled;
    }

    public UpdateGeneralSettings authTokenRestrictions(UpdateAuthTokenRestrictions authTokenRestrictions) {
        this.authTokenRestrictions = authTokenRestrictions;
        return this;
    }

    @Schema(description="")
    public UpdateAuthTokenRestrictions getAuthTokenRestrictions() {
        return this.authTokenRestrictions;
    }

    public void setAuthTokenRestrictions(UpdateAuthTokenRestrictions authTokenRestrictions) {
        this.authTokenRestrictions = authTokenRestrictions;
    }

    public UpdateGeneralSettings hideLoginInputFields(Boolean hideLoginInputFields) {
        this.hideLoginInputFields = hideLoginInputFields;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.13.0  Defines if login fields should be hidden")
    public Boolean isHideLoginInputFields() {
        return this.hideLoginInputFields;
    }

    public void setHideLoginInputFields(Boolean hideLoginInputFields) {
        this.hideLoginInputFields = hideLoginInputFields;
    }

    public UpdateGeneralSettings mediaServerEnabled(Boolean mediaServerEnabled) {
        this.mediaServerEnabled = mediaServerEnabled;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.12.0  Determines if the media server is enabled")
    public Boolean isMediaServerEnabled() {
        return this.mediaServerEnabled;
    }

    public void setMediaServerEnabled(Boolean mediaServerEnabled) {
        this.mediaServerEnabled = mediaServerEnabled;
    }

    public UpdateGeneralSettings weakPasswordEnabled(Boolean weakPasswordEnabled) {
        this.weakPasswordEnabled = weakPasswordEnabled;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.14.0  Allow weak password  * A weak password has to fulfill the following criteria:     * is at least 8 characters long     * contains letters and numbers  * A strong password has to fulfill the following criteria in addition:     * contains at least one special character     * contains upper and lower case characters  Please use `PUT /system/config/policies/passwords` API to change configured password policies.")
    public Boolean isWeakPasswordEnabled() {
        return this.weakPasswordEnabled;
    }

    public void setWeakPasswordEnabled(Boolean weakPasswordEnabled) {
        this.weakPasswordEnabled = weakPasswordEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateGeneralSettings updateGeneralSettings = (UpdateGeneralSettings)o;
        return Objects.equals(this.sharePasswordSmsEnabled, updateGeneralSettings.sharePasswordSmsEnabled) && Objects.equals(this.cryptoEnabled, updateGeneralSettings.cryptoEnabled) && Objects.equals(this.emailNotificationButtonEnabled, updateGeneralSettings.emailNotificationButtonEnabled) && Objects.equals(this.eulaEnabled, updateGeneralSettings.eulaEnabled) && Objects.equals(this.s3TagsEnabled, updateGeneralSettings.s3TagsEnabled) && Objects.equals(this.authTokenRestrictions, updateGeneralSettings.authTokenRestrictions) && Objects.equals(this.hideLoginInputFields, updateGeneralSettings.hideLoginInputFields) && Objects.equals(this.mediaServerEnabled, updateGeneralSettings.mediaServerEnabled) && Objects.equals(this.weakPasswordEnabled, updateGeneralSettings.weakPasswordEnabled);
    }

    public int hashCode() {
        return Objects.hash(this.sharePasswordSmsEnabled, this.cryptoEnabled, this.emailNotificationButtonEnabled, this.eulaEnabled, this.s3TagsEnabled, this.authTokenRestrictions, this.hideLoginInputFields, this.mediaServerEnabled, this.weakPasswordEnabled);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateGeneralSettings {\n");
        sb.append("    sharePasswordSmsEnabled: ").append(this.toIndentedString(this.sharePasswordSmsEnabled)).append("\n");
        sb.append("    cryptoEnabled: ").append(this.toIndentedString(this.cryptoEnabled)).append("\n");
        sb.append("    emailNotificationButtonEnabled: ").append(this.toIndentedString(this.emailNotificationButtonEnabled)).append("\n");
        sb.append("    eulaEnabled: ").append(this.toIndentedString(this.eulaEnabled)).append("\n");
        sb.append("    s3TagsEnabled: ").append(this.toIndentedString(this.s3TagsEnabled)).append("\n");
        sb.append("    authTokenRestrictions: ").append(this.toIndentedString(this.authTokenRestrictions)).append("\n");
        sb.append("    hideLoginInputFields: ").append(this.toIndentedString(this.hideLoginInputFields)).append("\n");
        sb.append("    mediaServerEnabled: ").append(this.toIndentedString(this.mediaServerEnabled)).append("\n");
        sb.append("    weakPasswordEnabled: ").append(this.toIndentedString(this.weakPasswordEnabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

