/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.UserAuthData;
import ch.cyberduck.core.sds.io.swagger.client.model.UserAuthMethod;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="First administrator user")
public class FirstAdminUser {
    @JsonProperty(value="firstName")
    private String firstName = null;
    @JsonProperty(value="lastName")
    private String lastName = null;
    @JsonProperty(value="userName")
    private String userName = null;
    @JsonProperty(value="authData")
    private UserAuthData authData = null;
    @JsonProperty(value="receiverLanguage")
    private String receiverLanguage = null;
    @JsonProperty(value="notifyUser")
    private Boolean notifyUser = null;
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="phone")
    private String phone = null;
    @JsonProperty(value="title")
    private String title = null;
    @JsonProperty(value="language")
    private String language = null;
    @JsonProperty(value="authMethods")
    private List<UserAuthMethod> authMethods = null;
    @JsonProperty(value="needsToChangeUserName")
    private Boolean needsToChangeUserName = false;
    @JsonProperty(value="password")
    private String password = null;
    @JsonProperty(value="needsToChangePassword")
    private Boolean needsToChangePassword = null;
    @JsonProperty(value="login")
    private String login = null;
    @JsonProperty(value="gender")
    private String gender = "n";

    public FirstAdminUser firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Schema(required=true, description="User first name")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public FirstAdminUser lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Schema(required=true, description="User last name")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public FirstAdminUser userName(String userName) {
        this.userName = userName;
        return this;
    }

    @Schema(description="&#128640; Since v4.13.0  Username")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public FirstAdminUser authData(UserAuthData authData) {
        this.authData = authData;
        return this;
    }

    @Schema(description="")
    public UserAuthData getAuthData() {
        return this.authData;
    }

    public void setAuthData(UserAuthData authData) {
        this.authData = authData;
    }

    public FirstAdminUser receiverLanguage(String receiverLanguage) {
        this.receiverLanguage = receiverLanguage;
        return this;
    }

    @Schema(description="IETF language tag")
    public String getReceiverLanguage() {
        return this.receiverLanguage;
    }

    public void setReceiverLanguage(String receiverLanguage) {
        this.receiverLanguage = receiverLanguage;
    }

    public FirstAdminUser notifyUser(Boolean notifyUser) {
        this.notifyUser = notifyUser;
        return this;
    }

    @Schema(description="Notify user about his new account  * default: `true` for `basic` auth type  * default: `false` for `active_directory`, `openid` and `radius` auth types")
    public Boolean isNotifyUser() {
        return this.notifyUser;
    }

    public void setNotifyUser(Boolean notifyUser) {
        this.notifyUser = notifyUser;
    }

    public FirstAdminUser email(String email) {
        this.email = email;
        return this;
    }

    @Schema(description="Email ")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public FirstAdminUser phone(String phone) {
        this.phone = phone;
        return this;
    }

    @Schema(description="Phone number")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public FirstAdminUser title(String title) {
        this.title = title;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.18.0  Job title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public FirstAdminUser language(String language) {
        this.language = language;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.7.0  Language ID or ISO 639-1 code")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public FirstAdminUser authMethods(List<UserAuthMethod> authMethods) {
        this.authMethods = authMethods;
        return this;
    }

    public FirstAdminUser addAuthMethodsItem(UserAuthMethod authMethodsItem) {
        if (this.authMethods == null) {
            this.authMethods = new ArrayList<UserAuthMethod>();
        }
        this.authMethods.add(authMethodsItem);
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.13.0  Authentication methods:  * `sql`  * `active_directory`  * `radius`  * `openid`  use `authData` instead")
    public List<UserAuthMethod> getAuthMethods() {
        return this.authMethods;
    }

    public void setAuthMethods(List<UserAuthMethod> authMethods) {
        this.authMethods = authMethods;
    }

    public FirstAdminUser needsToChangeUserName(Boolean needsToChangeUserName) {
        this.needsToChangeUserName = needsToChangeUserName;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.13.0  If `true`, the user must change the `userName` at the first login.")
    public Boolean isNeedsToChangeUserName() {
        return this.needsToChangeUserName;
    }

    public void setNeedsToChangeUserName(Boolean needsToChangeUserName) {
        this.needsToChangeUserName = needsToChangeUserName;
    }

    public FirstAdminUser password(String password) {
        this.password = password;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.13.0  An initial password may be preset  use `authData` instead")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public FirstAdminUser needsToChangePassword(Boolean needsToChangePassword) {
        this.needsToChangePassword = needsToChangePassword;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.13.0  Determines whether user has to change his / her initial password.  use `authDate.mustChangePassword` instead")
    public Boolean isNeedsToChangePassword() {
        return this.needsToChangePassword;
    }

    public void setNeedsToChangePassword(Boolean needsToChangePassword) {
        this.needsToChangePassword = needsToChangePassword;
    }

    public FirstAdminUser login(String login) {
        this.login = login;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.13.0  User login name")
    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public FirstAdminUser gender(String gender) {
        this.gender = gender;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.12.0  Gender")
    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FirstAdminUser firstAdminUser = (FirstAdminUser)o;
        return Objects.equals(this.firstName, firstAdminUser.firstName) && Objects.equals(this.lastName, firstAdminUser.lastName) && Objects.equals(this.userName, firstAdminUser.userName) && Objects.equals(this.authData, firstAdminUser.authData) && Objects.equals(this.receiverLanguage, firstAdminUser.receiverLanguage) && Objects.equals(this.notifyUser, firstAdminUser.notifyUser) && Objects.equals(this.email, firstAdminUser.email) && Objects.equals(this.phone, firstAdminUser.phone) && Objects.equals(this.title, firstAdminUser.title) && Objects.equals(this.language, firstAdminUser.language) && Objects.equals(this.authMethods, firstAdminUser.authMethods) && Objects.equals(this.needsToChangeUserName, firstAdminUser.needsToChangeUserName) && Objects.equals(this.password, firstAdminUser.password) && Objects.equals(this.needsToChangePassword, firstAdminUser.needsToChangePassword) && Objects.equals(this.login, firstAdminUser.login) && Objects.equals(this.gender, firstAdminUser.gender);
    }

    public int hashCode() {
        return Objects.hash(this.firstName, this.lastName, this.userName, this.authData, this.receiverLanguage, this.notifyUser, this.email, this.phone, this.title, this.language, this.authMethods, this.needsToChangeUserName, this.password, this.needsToChangePassword, this.login, this.gender);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FirstAdminUser {\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("    authData: ").append(this.toIndentedString(this.authData)).append("\n");
        sb.append("    receiverLanguage: ").append(this.toIndentedString(this.receiverLanguage)).append("\n");
        sb.append("    notifyUser: ").append(this.toIndentedString(this.notifyUser)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    authMethods: ").append(this.toIndentedString(this.authMethods)).append("\n");
        sb.append("    needsToChangeUserName: ").append(this.toIndentedString(this.needsToChangeUserName)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    needsToChangePassword: ").append(this.toIndentedString(this.needsToChangePassword)).append("\n");
        sb.append("    login: ").append(this.toIndentedString(this.login)).append("\n");
        sb.append("    gender: ").append(this.toIndentedString(this.gender)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

