/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Algorithm information")
public class AlgorithmVersionInfo {
    @JsonProperty(value="version")
    private String version = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="status")
    private StatusEnum status = null;

    public AlgorithmVersionInfo version(String version) {
        this.version = version;
        return this;
    }

    @Schema(required=true, description="Algorithm version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public AlgorithmVersionInfo description(String description) {
        this.description = description;
        return this;
    }

    @Schema(required=true, description="Algorithm description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AlgorithmVersionInfo status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Schema(required=true, description="Algorithm status  Derived from preference value and threshold")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlgorithmVersionInfo algorithmVersionInfo = (AlgorithmVersionInfo)o;
        return Objects.equals(this.version, algorithmVersionInfo.version) && Objects.equals(this.description, algorithmVersionInfo.description) && Objects.equals((Object)this.status, (Object)algorithmVersionInfo.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.description, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlgorithmVersionInfo {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        REQUIRED("REQUIRED"),
        DISCOURAGED("DISCOURAGED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

