/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Version;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.sds.SDSApiClient;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.api.UploadsApi;
import ch.cyberduck.core.sds.io.swagger.client.model.CompleteUploadRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateFileUploadRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.FileKey;
import ch.cyberduck.core.sds.io.swagger.client.model.Node;
import ch.cyberduck.core.sds.io.swagger.client.model.SoftwareVersionData;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptConverter;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptExceptionMappingService;
import ch.cyberduck.core.transfer.TransferStatus;
import com.dracoon.sdk.crypto.Crypto;
import com.dracoon.sdk.crypto.error.CryptoSystemException;
import com.dracoon.sdk.crypto.error.InvalidFileKeyException;
import com.dracoon.sdk.crypto.error.InvalidKeyPairException;
import com.dracoon.sdk.crypto.error.UnknownVersionException;
import com.dracoon.sdk.crypto.model.EncryptedFileKey;
import com.dracoon.sdk.crypto.model.PlainFileKey;
import com.dracoon.sdk.crypto.model.UserPublicKey;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;

public class SDSUploadService {
    private static final Logger log = Logger.getLogger(SDSUploadService.class);
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;

    public SDSUploadService(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
    }

    public String start(Path file, TransferStatus status) throws BackgroundException {
        try {
            CreateFileUploadRequest body = new CreateFileUploadRequest().size(-1L == status.getLength() ? null : Long.valueOf(status.getLength())).parentId(Long.parseLong(this.nodeid.getFileid(file.getParent(), (ListProgressListener)new DisabledListProgressListener()))).name(file.getName()).directS3Upload(null);
            if (status.getTimestamp() != null) {
                SoftwareVersionData version = this.session.softwareVersion();
                Matcher matcher = Pattern.compile("(([0-9]+)\\.([0-9]+)\\.([0-9]+)).*").matcher(version.getRestApiVersion());
                if (matcher.matches() && new Version(matcher.group(1)).compareTo(new Version(String.valueOf(4.22))) >= 0) {
                    body.timestampModification(new DateTime((Object)status.getTimestamp()));
                }
            }
            return new NodesApi((ApiClient)this.session.getClient()).createFileUploadChannel(body, "").getToken();
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService().map("Upload {0} failed", e, file);
        }
    }

    public VersionId complete(Path file, String uploadToken, TransferStatus status) throws BackgroundException {
        try {
            Checksum server;
            Checksum checksum;
            Node upload;
            CompleteUploadRequest body = new CompleteUploadRequest().keepShareLinks(status.isExists() ? PreferencesFactory.get().getBoolean("sds.upload.sharelinks.keep") : false).resolutionStrategy(status.isExists() ? CompleteUploadRequest.ResolutionStrategyEnum.OVERWRITE : CompleteUploadRequest.ResolutionStrategyEnum.FAIL);
            if (status.getFilekey() != null) {
                ObjectReader reader = ((SDSApiClient)this.session.getClient()).getJSON().getContext(null).readerFor(FileKey.class);
                FileKey fileKey = (FileKey)reader.readValue(status.getFilekey().array());
                EncryptedFileKey encryptFileKey = Crypto.encryptFileKey((PlainFileKey)TripleCryptConverter.toCryptoPlainFileKey(fileKey), (UserPublicKey)TripleCryptConverter.toCryptoUserPublicKey(this.session.keyPair().getPublicKeyContainer()));
                body.setFileKey(TripleCryptConverter.toSwaggerFileKey(encryptFileKey));
            }
            if (!(upload = new UploadsApi((ApiClient)this.session.getClient()).completeFileUploadByToken(body, uploadToken)).isIsEncrypted().booleanValue() && Checksum.NONE != (checksum = status.getChecksum()) && Checksum.NONE != (server = Checksum.parse((String)upload.getHash())) && checksum.algorithm.equals((Object)server.algorithm) && !server.equals((Object)checksum)) {
                throw new ChecksumException(MessageFormat.format(LocaleFactory.localizedString((String)"Upload {0} failed", (String)"Error"), file.getName()), MessageFormat.format("Mismatch between MD5 hash {0} of uploaded data and ETag {1} returned by the server", checksum.hash, server.hash));
            }
            return new VersionId(String.valueOf(upload.getId()));
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService().map("Upload {0} failed", e, file);
        }
        catch (CryptoSystemException | InvalidFileKeyException | InvalidKeyPairException | UnknownVersionException e) {
            throw new TripleCryptExceptionMappingService().map("Upload {0} failed", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
        }
    }

    public void cancel(Path file, String uploadToken) throws BackgroundException {
        log.warn((Object)String.format("Cancel failed upload %s for %s", uploadToken, file));
        try {
            new UploadsApi((ApiClient)this.session.getClient()).cancelFileUploadByToken(uploadToken);
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService().map("Upload {0} failed", e, file);
        }
    }
}

