/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.AbstractProtocol;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.features.Scheduler;
import ch.cyberduck.core.sds.SDSMissingFileKeysSchedulerFeature;
import org.apache.commons.lang3.StringUtils;

public class SDSProtocol
extends AbstractProtocol {
    public String getIdentifier() {
        return "dracoon";
    }

    public String getName() {
        return "DRACOON";
    }

    public String getDescription() {
        return "DRACOON";
    }

    public Protocol.Type getType() {
        return Protocol.Type.dracoon;
    }

    public Scheme getScheme() {
        return Scheme.https;
    }

    public String getContext() {
        return "/api";
    }

    public String getAuthorization() {
        return Authorization.sql.name();
    }

    public String disk() {
        return String.format("%s.tiff", "ftp");
    }

    public String getPrefix() {
        return String.format("%s.%s", SDSProtocol.class.getPackage().getName(), StringUtils.upperCase((String)"sds"));
    }

    public boolean isUsernameConfigurable() {
        switch (Authorization.valueOf(this.getAuthorization())) {
            case oauth: {
                return false;
            }
        }
        return true;
    }

    public boolean isPasswordConfigurable() {
        switch (Authorization.valueOf(this.getAuthorization())) {
            case oauth: {
                return false;
            }
        }
        return true;
    }

    public Protocol.Case getCaseSensitivity() {
        return Protocol.Case.insensitive;
    }

    public Protocol.DirectoryTimestamp getDirectoryTimestamp() {
        return Protocol.DirectoryTimestamp.explicit;
    }

    public <T> T getFeature(Class<T> type) {
        if (type == Scheduler.class) {
            return (T)((Object)new SDSMissingFileKeysSchedulerFeature());
        }
        return (T)super.getFeature(type);
    }

    public static enum Authorization {
        sql,
        radius,
        active_directory,
        oauth;

    }
}

