/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.CaseInsensitivePathPredicate;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.Version;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.sds.SDSAttributesFinderFeature;
import ch.cyberduck.core.sds.SDSDeleteFeature;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSPathContainerService;
import ch.cyberduck.core.sds.SDSPermissionsFeature;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.SDSTouchFeature;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.MoveNode;
import ch.cyberduck.core.sds.io.swagger.client.model.MoveNodesRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.SoftwareVersionData;
import ch.cyberduck.core.sds.io.swagger.client.model.UpdateRoomRequest;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SDSMoveFeature
implements Move {
    private static final Logger log = Logger.getLogger(SDSMoveFeature.class);
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;
    private final PathContainerService containerService = new SDSPathContainerService();

    public SDSMoveFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
    }

    public Path move(Path file, Path renamed, TransferStatus status, Delete.Callback callback, ConnectionCallback connectionCallback) throws BackgroundException {
        try {
            long nodeId = Long.parseLong(this.nodeid.getFileid(file, (ListProgressListener)new DisabledListProgressListener()));
            if (this.containerService.isContainer(file)) {
                return new Path(renamed.getParent(), renamed.getName(), renamed.getType(), new SDSAttributesFinderFeature(this.session, this.nodeid).toAttributes(new NodesApi((ApiClient)this.session.getClient()).updateRoom(new UpdateRoomRequest().name(renamed.getName()), nodeId, "", null)));
            }
            if (status.isExists() && !new CaseInsensitivePathPredicate(file).test(renamed)) {
                log.warn((Object)String.format("Delete existing file %s", renamed));
                new SDSDeleteFeature(this.session, this.nodeid).delete(Collections.singletonMap(renamed, status), (PasswordCallback)connectionCallback, callback);
            }
            new NodesApi((ApiClient)this.session.getClient()).moveNodes(new MoveNodesRequest().resolutionStrategy(MoveNodesRequest.ResolutionStrategyEnum.OVERWRITE).addItemsItem(new MoveNode().id(nodeId).name(renamed.getName())).keepShareLinks(PreferencesFactory.get().getBoolean("sds.upload.sharelinks.keep")), Long.parseLong(this.nodeid.getFileid(renamed.getParent(), (ListProgressListener)new DisabledListProgressListener())), "", null);
            return new Path(renamed.getParent(), renamed.getName(), renamed.getType(), new PathAttributes(renamed.attributes()).withVersionId(file.attributes().getVersionId()));
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService().map("Cannot rename {0}", e, file);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }

    public boolean isSupported(Path source, Path target) {
        if (this.containerService.isContainer(source) && !new SimplePathPredicate(source.getParent()).test(target.getParent())) {
            log.warn((Object)String.format("Deny moving data room %s", source));
            return false;
        }
        if (target.getParent().isRoot() && !source.getParent().isRoot()) {
            log.warn((Object)String.format("Deny moving file %s to root", source));
            return false;
        }
        if (!new SDSTouchFeature(this.session, this.nodeid).validate(target.getName())) {
            log.warn((Object)String.format("Validation failed for target name %s", target));
            return false;
        }
        SDSPermissionsFeature acl = new SDSPermissionsFeature(this.session, this.nodeid);
        if (!new SimplePathPredicate(source.getParent()).test(target.getParent()) && !acl.containsRole(source, SDSPermissionsFeature.CHANGE_ROLE) && acl.containsRole(source, SDSPermissionsFeature.DELETE_ROLE) && acl.containsRole(target, SDSPermissionsFeature.CREATE_ROLE)) {
            log.warn((Object)String.format("Deny move of %s with missing permissions for user", source));
            return false;
        }
        if (!acl.containsRole(source, SDSPermissionsFeature.CHANGE_ROLE)) {
            log.warn((Object)String.format("Deny move of %s with missing permissions for user", source));
            return false;
        }
        if (!StringUtils.equals((CharSequence)source.getName(), (CharSequence)target.getName()) && new CaseInsensitivePathPredicate(source).test(target)) {
            try {
                SoftwareVersionData version = this.session.softwareVersion();
                Matcher matcher = Pattern.compile("(([0-9]+)\\.([0-9]+)\\.([0-9]+)).*").matcher(version.getRestApiVersion());
                if (matcher.matches() && new Version(matcher.group(1)).compareTo(new Version(String.valueOf(4.14))) < 0) {
                    return false;
                }
            }
            catch (BackgroundException e) {
                log.warn((Object)String.format("Ignore failure %s determining version", new Object[]{e}));
            }
        }
        return true;
    }
}

