/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptWriteFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import org.apache.log4j.Logger;

public class SDSDelegatingWriteFeature
implements MultipartWrite<VersionId> {
    private static final Logger log = Logger.getLogger(SDSDelegatingWriteFeature.class);
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;
    private final Write<VersionId> proxy;

    public SDSDelegatingWriteFeature(SDSSession session, SDSNodeIdProvider nodeid, Write<VersionId> proxy) {
        this.session = session;
        this.nodeid = nodeid;
        this.proxy = proxy;
    }

    public StatusOutputStream<VersionId> write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        if (this.nodeid.isEncrypted(file)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Return encrypting writer for %s", file));
            }
            return new TripleCryptWriteFeature(this.session, this.nodeid, this.proxy).write(file, status, callback);
        }
        return this.proxy.write(file, status, callback);
    }

    public Write.Append append(Path file, Long length, Cache<Path> cache) throws BackgroundException {
        if (this.nodeid.isEncrypted(file)) {
            return new TripleCryptWriteFeature(this.session, this.nodeid, this.proxy).append(file, length, cache);
        }
        return this.proxy.append(file, length, cache);
    }

    public boolean temporary() {
        return this.proxy.temporary();
    }

    public boolean random() {
        return this.proxy.random();
    }

    public ChecksumCompute checksum(Path file, TransferStatus status) {
        if (this.nodeid.isEncrypted(file)) {
            return new TripleCryptWriteFeature(this.session, this.nodeid, this.proxy).checksum(file, status);
        }
        return this.proxy.checksum(file, status);
    }
}

