/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.googlestorage.GoogleStorageAttributesFinderFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageExceptionMappingService;
import ch.cyberduck.core.googlestorage.GoogleStoragePathContainerService;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Objects;
import com.google.api.services.storage.model.StorageObject;
import java.io.IOException;
import java.util.EnumSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class GoogleStorageObjectListService
implements ListService {
    private static final Logger log = Logger.getLogger(GoogleStorageObjectListService.class);
    private final Preferences preferences = PreferencesFactory.get();
    private final GoogleStorageSession session;
    private final GoogleStorageAttributesFinderFeature attributes;
    private final PathContainerService containerService = new GoogleStoragePathContainerService();

    public GoogleStorageObjectListService(GoogleStorageSession session) {
        this.session = session;
        this.attributes = new GoogleStorageAttributesFinderFeature(session);
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        return this.list(directory, listener, String.valueOf('/'), this.preferences.getInteger("googlestorage.listing.chunksize"));
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener, String delimiter, int chunksize) throws BackgroundException {
        try {
            Path bucket = this.containerService.getContainer(directory);
            AttributedList objects = new AttributedList();
            long revision = 0L;
            String lastKey = null;
            String page = null;
            boolean hasDirectoryPlaceholder = this.containerService.isContainer(directory);
            do {
                String key;
                Objects response;
                if ((response = (Objects)((Storage)this.session.getClient()).objects().list(bucket.getName()).setPageToken(page).setVersions(Boolean.valueOf(false)).setMaxResults(Long.valueOf(chunksize)).setDelimiter(delimiter).setPrefix(this.createPrefix(directory)).execute()).getItems() != null) {
                    for (StorageObject object : response.getItems()) {
                        key = PathNormalizer.normalize((String)object.getName());
                        if (String.valueOf('/').equals(key)) {
                            log.warn((Object)String.format("Skipping prefix %s", key));
                            continue;
                        }
                        if (new Path(bucket, key, EnumSet.of(AbstractPath.Type.directory)).equals((Object)directory)) {
                            hasDirectoryPlaceholder = true;
                            continue;
                        }
                        if (!StringUtils.equals(lastKey, (CharSequence)key)) {
                            revision = 0L;
                        }
                        EnumSet<AbstractPath.Type> types = object.getName().endsWith(String.valueOf('/')) ? EnumSet.of(AbstractPath.Type.directory) : EnumSet.of(AbstractPath.Type.file);
                        PathAttributes attr = this.attributes.toAttributes(object);
                        attr.setRevision(Long.valueOf(++revision));
                        attr.setRegion(bucket.attributes().getRegion());
                        Path file = null == delimiter ? new Path(String.format("%s%s", bucket.getAbsolute(), key), types, attr) : new Path(directory, PathNormalizer.name((String)key), types, attr);
                        objects.add((Referenceable)file);
                        lastKey = key;
                    }
                }
                if (response.getPrefixes() != null) {
                    for (String prefix : response.getPrefixes()) {
                        if (String.valueOf('/').equals(prefix)) {
                            log.warn((Object)String.format("Skipping prefix %s", prefix));
                            continue;
                        }
                        key = PathNormalizer.normalize((String)prefix);
                        if (new Path(bucket, key, EnumSet.of(AbstractPath.Type.directory)).equals((Object)directory)) continue;
                        PathAttributes attributes = new PathAttributes();
                        Path file = null == delimiter ? new Path(String.format("%s%s", bucket.getAbsolute(), key), EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.placeholder), attributes) : new Path(directory, PathNormalizer.name((String)key), EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.placeholder), attributes);
                        attributes.setRegion(bucket.attributes().getRegion());
                        objects.add((Referenceable)file);
                    }
                }
                page = response.getNextPageToken();
                listener.chunk(directory, objects);
            } while (page != null);
            if (!hasDirectoryPlaceholder && objects.isEmpty()) {
                throw new NotfoundException(directory.getAbsolute());
            }
            return objects;
        }
        catch (IOException e) {
            throw new GoogleStorageExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
    }

    protected String createPrefix(Path directory) {
        String prefix = "";
        if (!this.containerService.isContainer(directory) && !(prefix = this.containerService.getKey(directory)).endsWith(String.valueOf('/'))) {
            prefix = prefix + '/';
        }
        return prefix;
    }

    public ListService withCache(Cache<Path> cache) {
        this.attributes.withCache(cache);
        return this;
    }
}

