/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.googlestorage.GoogleStorageAttributesFinderFeature;
import ch.cyberduck.core.googlestorage.GoogleStoragePathContainerService;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import java.util.Set;

public class GoogleStorageLocationFeature
implements Location {
    private final GoogleStorageSession session;
    private final PathContainerService containerService = new GoogleStoragePathContainerService();

    public GoogleStorageLocationFeature(GoogleStorageSession session) {
        this.session = session;
    }

    public Set<Location.Name> getLocations() {
        return this.session.getHost().getProtocol().getRegions();
    }

    public Location.Name getLocation(Path file) throws BackgroundException {
        Path container = this.containerService.getContainer(file);
        if (container.isRoot()) {
            return unknown;
        }
        return new Location.Name(new GoogleStorageAttributesFinderFeature(this.session).find(container).getRegion());
    }
}

