/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.sftp.SFTPExceptionMappingService;
import ch.cyberduck.core.sftp.SFTPHomeDirectoryService;
import ch.cyberduck.core.sftp.SFTPSession;
import java.io.IOException;
import net.schmizz.sshj.sftp.Request;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPEngine;
import org.apache.log4j.Logger;

public class SFTPQuotaFeature
implements Quota {
    private static final int MIN_SFTP_SPACE_AVAILABLE_VERSION = 6;
    private static final Logger log = Logger.getLogger(SFTPQuotaFeature.class);
    private final SFTPSession session;

    public SFTPQuotaFeature(SFTPSession session) {
        this.session = session;
    }

    public Quota.Space get() throws BackgroundException {
        Path home = new SFTPHomeDirectoryService(this.session).find();
        if (this.isSpaceAvailableExtensionAvailable()) {
            try {
                return this.getSpaceAvailable(this.session.sftp(), home);
            }
            catch (BackgroundException e) {
                log.info((Object)String.format("Failure obtaining disk quota. %s", new Object[]{e}));
            }
        }
        if (this.isStatVFSOpenSSHSupported()) {
            try {
                return this.getSpaceStatVFSOpenSSH(this.session.sftp(), home);
            }
            catch (BackgroundException e) {
                log.info((Object)String.format("Failure obtaining disk quota. %s", new Object[]{e}));
            }
        }
        return unknown;
    }

    private boolean isSpaceAvailableExtensionAvailable() {
        try {
            return this.session.sftp().getOperativeProtocolVersion() >= 6;
        }
        catch (BackgroundException e) {
            return false;
        }
    }

    private Quota.Space getSpaceAvailable(SFTPEngine sftp, Path directory) throws BackgroundException {
        try {
            Request request = (Request)sftp.newExtendedRequest("space-available").putString(directory.getAbsolute());
            Response response = (Response)sftp.request(request).retrieve();
            switch (response.getType()) {
                case EXTENDED_REPLY: {
                    long bytesOnDevice = response.readUInt64();
                    long unusedBytesOnDevice = response.readUInt64();
                    long bytesAvailableToUser = response.readUInt64();
                    long unusedBytesAvailableToUser = response.readUInt64();
                    int bytesPerAllocationUnit = response.readUInt32AsInt();
                    if (bytesAvailableToUser == 0L) {
                        if (bytesOnDevice == 0L) {
                            throw new IOException("SFTPv6 space-available did not return valid values.");
                        }
                        long available = unusedBytesOnDevice;
                        long used = bytesOnDevice - unusedBytesOnDevice;
                        return new Quota.Space(Long.valueOf(used), Long.valueOf(available));
                    }
                    long available = unusedBytesAvailableToUser;
                    long used = bytesAvailableToUser - unusedBytesAvailableToUser;
                    return new Quota.Space(Long.valueOf(used), Long.valueOf(available));
                }
            }
            throw new IOException(String.format("Unexpected response type %s", response.getType()));
        }
        catch (IOException e) {
            throw new SFTPExceptionMappingService().map("Failure to read attributes of {0}", e, directory);
        }
    }

    private boolean isStatVFSOpenSSHSupported() {
        try {
            return this.session.sftp().supportsServerExtension("statvfs", "openssh.com");
        }
        catch (BackgroundException e) {
            return false;
        }
    }

    private Quota.Space getSpaceStatVFSOpenSSH(SFTPEngine sftp, Path directory) throws BackgroundException {
        try {
            Request request = (Request)sftp.newExtendedRequest("statvfs@openssh.com").putString(directory.getAbsolute());
            Response response = (Response)sftp.request(request).retrieve();
            switch (response.getType()) {
                case EXTENDED_REPLY: {
                    long blockSize = response.readUInt64();
                    long filesystemBlockSize = response.readUInt64();
                    long totalBlocks = response.readUInt64();
                    long filesystemFreeBlocks = response.readUInt64();
                    long blocksAvailable = response.readUInt64();
                    long fileInodes = response.readUInt64();
                    long fileInodesFree = response.readUInt64();
                    long fileInodesAvailable = response.readUInt64();
                    byte[] filesystemID = new byte[8];
                    response.readRawBytes(filesystemID);
                    long flags = response.readUInt64();
                    long maximumFilenameLength = response.readUInt64();
                    long total = totalBlocks * filesystemBlockSize;
                    long available = blocksAvailable * filesystemBlockSize;
                    long used = total - available;
                    return new Quota.Space(Long.valueOf(used), Long.valueOf(available));
                }
            }
            throw new IOException(String.format("Unexpected response type %s", response.getType()));
        }
        catch (IOException e) {
            throw new SFTPExceptionMappingService().map("Failure to read attributes of {0}", e, directory);
        }
    }
}

