/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.sftp.SFTPAttributesFinderFeature;
import ch.cyberduck.core.sftp.SFTPSession;

public class SFTPFindFeature
implements Find {
    private final SFTPSession session;

    public SFTPFindFeature(SFTPSession session) {
        this.session = session;
    }

    public boolean find(Path file) throws BackgroundException {
        if (file.isRoot()) {
            return true;
        }
        try {
            new SFTPAttributesFinderFeature(this.session).find(file);
            return true;
        }
        catch (NotfoundException e) {
            return false;
        }
    }
}

