/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.openstack.swift.method;

import ch.iterate.openstack.swift.Client;
import ch.iterate.openstack.swift.method.Authentication11UsernameKeyRequest;
import ch.iterate.openstack.swift.method.AuthenticationRequest;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;

public class Authentication20UsernameKeyRequest
extends HttpPost
implements AuthenticationRequest {
    private static final Logger logger = Logger.getLogger(Authentication11UsernameKeyRequest.class.getName());

    public Authentication20UsernameKeyRequest(URI uri, String username, String key, String tenantName) {
        super(uri);
        JsonObject passwordCredentials = new JsonObject();
        passwordCredentials.addProperty("username", username);
        passwordCredentials.addProperty("apiKey", key);
        JsonObject auth = new JsonObject();
        auth.add("apiKeyCredentials", (JsonElement)passwordCredentials);
        if (tenantName != null) {
            auth.addProperty("tenantName", tenantName);
        }
        JsonObject container = new JsonObject();
        container.add("auth", (JsonElement)auth);
        ByteArrayEntity entity = null;
        try {
            entity = new ByteArrayEntity(container.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        this.setHeader("Accept", "application/json");
        this.setHeader("Content-Type", "application/json");
        this.setEntity((HttpEntity)entity);
    }

    @Override
    public Client.AuthVersion getVersion() {
        return Client.AuthVersion.v20;
    }
}

