/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.vault.VaultRegistry;
import ch.cyberduck.core.worker.Worker;
import java.text.MessageFormat;
import java.util.Objects;

public class LockVaultWorker
extends Worker<Path> {
    private final VaultRegistry registry;
    private final Path vault;

    public LockVaultWorker(VaultRegistry registry, Path vault) {
        this.registry = registry;
        this.vault = vault;
    }

    @Override
    public Path run(Session<?> session) throws BackgroundException {
        this.registry.close(this.vault);
        return this.vault;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Listing directory {0}", "Status"), this.vault.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LockVaultWorker that = (LockVaultWorker)o;
        return Objects.equals(this.vault, that.vault);
    }

    public int hashCode() {
        return Objects.hash(this.vault);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("LockVaultWorker{");
        sb.append("directory=").append(this.vault);
        sb.append('}');
        return sb.toString();
    }
}

