/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer.upload;

import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.UserDateFormatterFactory;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.symlink.SymlinkResolver;
import ch.cyberduck.core.transfer.upload.AbstractUploadFilter;
import ch.cyberduck.core.transfer.upload.UploadFilterOptions;
import java.text.MessageFormat;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class RenameExistingFilter
extends AbstractUploadFilter {
    private static final Logger log = Logger.getLogger(RenameExistingFilter.class);
    private final Move move;

    public RenameExistingFilter(SymlinkResolver<Local> symlinkResolver, Session<?> session) {
        this(symlinkResolver, session, new UploadFilterOptions());
    }

    public RenameExistingFilter(SymlinkResolver<Local> symlinkResolver, Session<?> session, UploadFilterOptions options) {
        super(symlinkResolver, session, options);
        this.move = session.getFeature(Move.class);
    }

    @Override
    public void apply(Path file, Local local, TransferStatus status, ProgressListener listener) throws BackgroundException {
        if (status.isExists()) {
            Path rename;
            do {
                String proposal = MessageFormat.format(PreferencesFactory.get().getProperty("queue.upload.file.rename.format"), FilenameUtils.getBaseName((String)file.getName()), UserDateFormatterFactory.get().getMediumFormat(System.currentTimeMillis(), false).replace('/', '-').replace(':', '-'), StringUtils.isNotBlank((CharSequence)file.getExtension()) ? String.format(".%s", file.getExtension()) : "");
                rename = new Path(file.getParent(), proposal, file.getType());
            } while (this.find.withCache(this.cache).find(rename));
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Rename existing file %s to %s", file, rename));
            }
            this.move.move(file, rename, new TransferStatus().exists(false), new Delete.DisabledCallback(), new DisabledConnectionCallback());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Clear exist flag for file %s", file));
            }
            status.setExists(false);
        }
        super.apply(file, local, status, listener);
    }
}

