/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.serializer;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DeserializerFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.serializer.Deserializer;
import ch.cyberduck.core.serializer.PathAttributesDictionary;
import java.util.EnumSet;
import org.apache.commons.lang3.StringUtils;

public class PathDictionary {
    private final DeserializerFactory factory;

    public PathDictionary() {
        this.factory = new DeserializerFactory();
    }

    public PathDictionary(DeserializerFactory factory) {
        this.factory = factory;
    }

    public <T> Path deserialize(T serialized) {
        Path path;
        T attributesObj;
        Deserializer<T> dict = this.factory.create(serialized);
        EnumSet<AbstractPath.Type> type = EnumSet.noneOf(AbstractPath.Type.class);
        String typeObj = dict.stringForKey("Type");
        if (typeObj != null) {
            for (String t : StringUtils.splitByWholeSeparator((String)StringUtils.replaceEach((String)typeObj, (String[])new String[]{"[", "]"}, (String[])new String[]{"", ""}), (String)", ")) {
                type.add(AbstractPath.Type.valueOf(t));
            }
        }
        if ((attributesObj = dict.objectForKey("Attributes")) != null) {
            PathAttributes attributes = new PathAttributesDictionary(this.factory).deserialize(attributesObj);
            String legacyTypeObj = this.factory.create(attributesObj).stringForKey("Type");
            if (legacyTypeObj != null) {
                if ((Integer.valueOf(legacyTypeObj) & AbstractPath.Type.file.legacy()) == AbstractPath.Type.file.legacy()) {
                    type.add(AbstractPath.Type.file);
                }
                if ((Integer.valueOf(legacyTypeObj) & AbstractPath.Type.directory.legacy()) == AbstractPath.Type.directory.legacy()) {
                    type.add(AbstractPath.Type.directory);
                }
                if ((Integer.valueOf(legacyTypeObj) & AbstractPath.Type.symboliclink.legacy()) == AbstractPath.Type.symboliclink.legacy()) {
                    type.add(AbstractPath.Type.symboliclink);
                }
                if ((Integer.valueOf(legacyTypeObj) & AbstractPath.Type.volume.legacy()) == AbstractPath.Type.volume.legacy()) {
                    type.add(AbstractPath.Type.volume);
                }
            }
            if (type.isEmpty()) {
                return null;
            }
            String absolute = dict.stringForKey("Remote");
            if (null == absolute) {
                return null;
            }
            path = new Path(absolute, type, attributes);
        } else {
            if (type.isEmpty()) {
                return null;
            }
            String absolute = dict.stringForKey("Remote");
            if (null == absolute) {
                return null;
            }
            path = new Path(absolute, type);
        }
        T symlinkObj = dict.objectForKey("Symbolic Link");
        if (symlinkObj != null) {
            path.setSymlinkTarget(new PathDictionary(this.factory).deserialize(symlinkObj));
        }
        return path;
    }
}

