/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.serializer;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.DeserializerFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.serializer.AclDictionary;
import ch.cyberduck.core.serializer.Deserializer;
import ch.cyberduck.core.serializer.PathDictionary;
import ch.cyberduck.core.serializer.PermissionDictionary;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PathAttributesDictionary {
    private final DeserializerFactory factory;

    public PathAttributesDictionary() {
        this.factory = new DeserializerFactory();
    }

    public PathAttributesDictionary(DeserializerFactory factory) {
        this.factory = factory;
    }

    public <T> PathAttributes deserialize(T serialized) {
        Map<String, String> customObj;
        String hiddenObj;
        String linkObj;
        T aclObj;
        T permissionObj;
        String etagObj;
        List versionsObj;
        String revisionObj;
        String modifiedObj;
        String quotaObj;
        Deserializer<T> dict = this.factory.create(serialized);
        PathAttributes attributes = new PathAttributes();
        String sizeObj = dict.stringForKey("Size");
        if (sizeObj != null) {
            attributes.setSize(Long.parseLong(sizeObj));
        }
        if ((quotaObj = dict.stringForKey("Quota")) != null) {
            attributes.setQuota(Long.parseLong(quotaObj));
        }
        if ((modifiedObj = dict.stringForKey("Modified")) != null) {
            attributes.setModificationDate(Long.parseLong(modifiedObj));
        }
        if ((revisionObj = dict.stringForKey("Revision")) != null) {
            attributes.setRevision(Long.parseLong(revisionObj));
        }
        if ((versionsObj = dict.listForKey("Versions")) != null) {
            AttributedList<Path> versions = new AttributedList<Path>();
            for (Object versionDict : versionsObj) {
                versions.add(new PathDictionary(this.factory).deserialize(versionDict));
            }
            attributes.setVersions(versions);
        }
        if ((etagObj = dict.stringForKey("ETag")) != null) {
            attributes.setETag(dict.stringForKey("ETag"));
        }
        if ((permissionObj = dict.objectForKey("Permission")) != null) {
            attributes.setPermission(new PermissionDictionary().deserialize(permissionObj));
        }
        if ((aclObj = dict.objectForKey("Acl")) != null) {
            attributes.setAcl(new AclDictionary().deserialize(aclObj));
        }
        if ((linkObj = dict.stringForKey("Link")) != null) {
            attributes.setLink(new DescriptiveUrl(URI.create(dict.stringForKey("Link")), DescriptiveUrl.Type.http));
        }
        if (dict.mapForKey("Checksum") != null) {
            Map<String, String> checksum = dict.mapForKey("Checksum");
            attributes.setChecksum(new Checksum(HashAlgorithm.valueOf(checksum.get("Algorithm")), checksum.get("Hash")));
        } else {
            attributes.setChecksum(Checksum.parse(dict.stringForKey("Checksum")));
        }
        attributes.setVersionId(dict.stringForKey("Version"));
        attributes.setFileId(dict.stringForKey("File Id"));
        attributes.setLockId(dict.stringForKey("Lock Id"));
        String duplicateObj = dict.stringForKey("Duplicate");
        if (duplicateObj != null) {
            attributes.setDuplicate(Boolean.parseBoolean(duplicateObj));
        }
        if ((hiddenObj = dict.stringForKey("Hidden")) != null) {
            attributes.setHidden(Boolean.parseBoolean(hiddenObj));
        }
        attributes.setMetadata(Collections.emptyMap());
        attributes.setRegion(dict.stringForKey("Region"));
        attributes.setStorageClass(dict.stringForKey("Storage Class"));
        T vaultObj = dict.objectForKey("Vault");
        if (vaultObj != null) {
            attributes.setVault(new PathDictionary(this.factory).deserialize(vaultObj));
        }
        if ((customObj = dict.mapForKey("Custom")) != null) {
            attributes.setCustom(customObj);
        }
        return attributes;
    }
}

