/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.filter;

import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class UploadRegexFilter
implements Filter<Local> {
    private static final Logger log = Logger.getLogger(UploadRegexFilter.class);
    private final Pattern pattern;

    public UploadRegexFilter() {
        this(Pattern.compile(PreferencesFactory.get().getProperty("queue.upload.skip.regex")));
    }

    public UploadRegexFilter(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public boolean accept(Local file) {
        if (this.pattern.matcher(file.getName()).matches()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Skip %s excluded with regex", file));
            }
            return false;
        }
        return true;
    }

    @Override
    public Pattern toPattern() {
        return this.pattern;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("UploadRegexFilter{");
        sb.append("pattern=").append(this.pattern);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UploadRegexFilter)) {
            return false;
        }
        UploadRegexFilter that = (UploadRegexFilter)o;
        return Objects.equals(this.pattern, that.pattern);
    }

    public int hashCode() {
        return Objects.hash(this.pattern);
    }
}

