/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.collections;

import java.util.AbstractList;
import java.util.List;

public class Partition<T>
extends AbstractList<List<T>> {
    final List<T> list;
    final int size;

    public Partition(List<T> list, int size) {
        this.list = list;
        this.size = size;
    }

    @Override
    public List<T> get(int index) {
        int start = index * this.size;
        int end = Math.min(start + this.size, this.list.size());
        return this.list.subList(start, end);
    }

    @Override
    public int size() {
        return (this.list.size() + this.size - 1) / this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }
}

