/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.CacheReference;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.unicode.NFCNormalizer;
import ch.cyberduck.core.unicode.UnicodeNormalizer;
import java.util.Objects;

public class SimplePathPredicate
implements CacheReference<Path> {
    private static final UnicodeNormalizer normalizer = new NFCNormalizer();
    private final AbstractPath.Type type;
    private final String path;

    public SimplePathPredicate(Path file) {
        this(file.isSymbolicLink() ? AbstractPath.Type.symboliclink : (file.isFile() ? AbstractPath.Type.file : AbstractPath.Type.directory), file.getAbsolute());
    }

    public SimplePathPredicate(AbstractPath.Type type, String path) {
        this.type = type;
        this.path = normalizer.normalize(path).toString();
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (o instanceof CacheReference && this.hashCode() == o.hashCode()) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.path});
    }

    @Override
    public boolean test(Path test) {
        return this.equals(new SimplePathPredicate(test));
    }

    public String toString() {
        return "[" + (Object)((Object)this.type) + "]-" + this.path;
    }
}

