/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.DisabledPasswordCallback;
import ch.cyberduck.core.Factory;
import ch.cyberduck.core.PasswordCallback;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.log4j.Logger;

public class PasswordCallbackFactory
extends Factory<PasswordCallback> {
    private static final Logger log = Logger.getLogger(PasswordCallbackFactory.class);
    private Constructor<PasswordCallback> constructor;

    protected PasswordCallbackFactory() {
        super("factory.passwordcallback.class");
    }

    public PasswordCallback create(Controller controller) {
        try {
            if (null == this.constructor) {
                this.constructor = ConstructorUtils.getMatchingAccessibleConstructor((Class)this.clazz, (Class[])new Class[]{controller.getClass()});
            }
            if (null == this.constructor) {
                log.warn((Object)String.format("No matching constructor for parameter %s", controller.getClass()));
                return (PasswordCallback)this.clazz.newInstance();
            }
            return this.constructor.newInstance(controller);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            log.error((Object)String.format("Failure loading callback class %s. %s", this.clazz, e.getMessage()));
            return new DisabledPasswordCallback();
        }
    }

    public static PasswordCallback get(Controller c) {
        return new PasswordCallbackFactory().create(c);
    }
}

