/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.ConnectionService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.HostnameConfiguratorFactory;
import ch.cyberduck.core.JumpHostConfiguratorFactory;
import ch.cyberduck.core.KeychainLoginService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.LoginService;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Resolver;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.StringAppender;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.ResolveFailedException;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.proxy.ProxyFactory;
import ch.cyberduck.core.proxy.ProxyFinder;
import ch.cyberduck.core.proxy.ProxyHostUrlProvider;
import ch.cyberduck.core.threading.CancelCallback;
import java.text.MessageFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class LoginConnectionService
implements ConnectionService {
    private static final Logger log = Logger.getLogger(LoginConnectionService.class);
    private final Resolver resolver = new Resolver();
    private final HostKeyCallback key;
    private final ProgressListener listener;
    private final LoginCallback prompt;
    private final ProxyFinder proxy;
    private final LoginService login;

    public LoginConnectionService(LoginCallback prompt, HostKeyCallback key, HostPasswordStore keychain, ProgressListener listener) {
        this(new KeychainLoginService(keychain), prompt, key, listener);
    }

    public LoginConnectionService(LoginCallback prompt, HostKeyCallback key, HostPasswordStore keychain, ProgressListener listener, ProxyFinder proxy) {
        this(new KeychainLoginService(keychain), prompt, key, listener, proxy);
    }

    public LoginConnectionService(LoginService login, LoginCallback prompt, HostKeyCallback key, ProgressListener listener) {
        this(login, prompt, key, listener, ProxyFactory.get());
    }

    public LoginConnectionService(LoginService login, LoginCallback prompt, HostKeyCallback key, ProgressListener listener, ProxyFinder proxy) {
        this.login = login;
        this.prompt = prompt;
        this.proxy = proxy;
        this.key = key;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean check(Session<?> session, CancelCallback callback) throws BackgroundException {
        Host bookmark = session.getHost();
        if (bookmark.getProtocol().isHostnameConfigurable() && StringUtils.isBlank((CharSequence)bookmark.getHostname())) {
            throw new ConnectionCanceledException();
        }
        if (session.isConnected()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Skip opening connection for session %s", session));
            }
            return false;
        }
        LoginService loginService = this.login;
        synchronized (loginService) {
            LoginOptions options = new LoginOptions(bookmark.getProtocol());
            StringAppender message = new StringAppender();
            if (options.password) {
                message.append(MessageFormat.format(LocaleFactory.localizedString("Login {0} with username and password", "Credentials"), BookmarkNameProvider.toString(bookmark)));
            }
            if (options.publickey) {
                message.append(LocaleFactory.localizedString("Select the private key in PEM or PuTTY format", "Credentials"));
            }
            this.login.validate(bookmark, message.toString(), this.prompt, options);
        }
        this.connect(session, callback);
        return true;
    }

    @Override
    public void close(Session<?> session) {
        this.listener.message(MessageFormat.format(LocaleFactory.localizedString("Disconnecting {0}", "Status"), session.getHost().getHostname()));
        try {
            session.interrupt();
        }
        catch (BackgroundException e) {
            log.warn((Object)String.format("Ignore failure closing connection %s", e.getMessage()));
        }
    }

    @Override
    public void connect(Session<?> session, CancelCallback cancel) throws BackgroundException {
        if (session.isConnected()) {
            this.close(session);
        }
        Host bookmark = session.getHost();
        String hostname = HostnameConfiguratorFactory.get(bookmark.getProtocol()).getHostname(bookmark.getHostname());
        this.listener.message(MessageFormat.format(LocaleFactory.localizedString("Resolving {0}", "Status"), hostname));
        Proxy proxy = this.proxy.find(new ProxyHostUrlProvider().get(bookmark));
        if (proxy == Proxy.DIRECT && null == JumpHostConfiguratorFactory.get(bookmark.getProtocol()).getJumphost(bookmark.getHostname())) {
            try {
                this.resolver.resolve(hostname, cancel);
            }
            catch (ResolveFailedException e) {
                log.warn((Object)String.format("DNS resolver failed for %s", hostname));
                throw e;
            }
        }
        this.listener.message(MessageFormat.format(LocaleFactory.localizedString("Opening {0} connection to {1}", "Status"), bookmark.getProtocol().getName(), hostname));
        session.open(proxy, this.key, this.prompt, cancel);
        this.listener.message(MessageFormat.format(LocaleFactory.localizedString("{0} connection opened", "Status"), bookmark.getProtocol().getName()));
        bookmark.setTimestamp(new Date());
        if (session.alert(this.prompt)) {
            this.prompt.warn(bookmark, MessageFormat.format(LocaleFactory.localizedString("Unsecured {0} connection", "Credentials"), bookmark.getProtocol().getName()), MessageFormat.format("{0} {1}.", MessageFormat.format(LocaleFactory.localizedString("{0} will be sent in plaintext.", "Credentials"), bookmark.getProtocol().getPasswordPlaceholder()), LocaleFactory.localizedString("Please contact your web hosting service provider for assistance", "Support")), LocaleFactory.localizedString("Continue", "Credentials"), LocaleFactory.localizedString("Disconnect", "Credentials"), String.format("connection.unsecure.%s", bookmark.getHostname()));
        }
        try {
            this.authenticate(proxy, session, cancel);
        }
        catch (BackgroundException e) {
            this.close(session);
            throw e;
        }
    }

    private void authenticate(Proxy proxy, Session session, CancelCallback callback) throws BackgroundException {
        if (!this.login.authenticate(proxy, session, this.listener, this.prompt, callback)) {
            if (session.isConnected()) {
                this.authenticate(proxy, session, callback);
            } else {
                this.connect(session, callback);
            }
        }
    }
}

