/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.irods;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.irods.IRODSAttributesFinderFeature;
import ch.cyberduck.core.irods.IRODSExceptionMappingService;
import ch.cyberduck.core.irods.IRODSFindFeature;
import ch.cyberduck.core.irods.IRODSSession;
import ch.cyberduck.core.shared.AppendWriteFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.DefaultExceptionMappingService;
import java.io.OutputStream;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.JargonRuntimeException;
import org.irods.jargon.core.packinstr.DataObjInp;
import org.irods.jargon.core.pub.IRODSFileSystemAO;
import org.irods.jargon.core.pub.io.IRODSFileOutputStream;
import org.irods.jargon.core.pub.io.PackingIrodsOutputStream;

public class IRODSWriteFeature
extends AppendWriteFeature<Integer> {
    private final IRODSSession session;

    public IRODSWriteFeature(IRODSSession session) {
        super((Find)new IRODSFindFeature(session), (AttributesFinder)new IRODSAttributesFinderFeature(session));
        this.session = session;
    }

    public FileDescriptorOutputStream write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            try {
                IRODSFileSystemAO fs = (IRODSFileSystemAO)this.session.getClient();
                IRODSFileOutputStream out = fs.getIRODSFileFactory().instanceIRODSFileOutputStream(file.getAbsolute(), status.isAppend() ? DataObjInp.OpenFlags.READ_WRITE : DataObjInp.OpenFlags.WRITE_TRUNCATE);
                return new FileDescriptorOutputStream((OutputStream)new PackingIrodsOutputStream(out), out.getFileDescriptor());
            }
            catch (JargonRuntimeException e) {
                if (e.getCause() instanceof JargonException) {
                    throw (JargonException)e.getCause();
                }
                throw new DefaultExceptionMappingService().map((Throwable)e);
            }
        }
        catch (JargonException e) {
            throw new IRODSExceptionMappingService().map("Uploading {0} failed", e, file);
        }
    }

    public boolean temporary() {
        return false;
    }

    public boolean random() {
        return false;
    }

    private final class FileDescriptorOutputStream
    extends StatusOutputStream<Integer> {
        private final Integer handle;

        public FileDescriptorOutputStream(OutputStream proxy, Integer handle) {
            super(proxy);
            this.handle = handle;
        }

        public Integer getStatus() {
            return this.handle;
        }
    }
}

