/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.irods;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.irods.IRODSExceptionMappingService;
import ch.cyberduck.core.irods.IRODSSession;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.DataTransferOperations;
import org.irods.jargon.core.pub.IRODSFileSystemAO;
import org.irods.jargon.core.transfer.DefaultTransferControlBlock;
import org.irods.jargon.core.transfer.TransferStatusCallbackListener;

public class IRODSCopyFeature
implements Copy {
    private final IRODSSession session;

    public IRODSCopyFeature(IRODSSession session) {
        this.session = session;
    }

    public Path copy(Path source, Path target, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            IRODSFileSystemAO fs = (IRODSFileSystemAO)this.session.getClient();
            DataTransferOperations transfer = fs.getIRODSAccessObjectFactory().getDataTransferOperations(fs.getIRODSAccount());
            transfer.copy(fs.getIRODSFileFactory().instanceIRODSFile(source.getAbsolute()), fs.getIRODSFileFactory().instanceIRODSFile(target.getAbsolute()), new TransferStatusCallbackListener(){

                public TransferStatusCallbackListener.FileStatusCallbackResponse statusCallback(org.irods.jargon.core.transfer.TransferStatus transferStatus) {
                    return TransferStatusCallbackListener.FileStatusCallbackResponse.CONTINUE;
                }

                public void overallStatusCallback(org.irods.jargon.core.transfer.TransferStatus transferStatus) {
                }

                public TransferStatusCallbackListener.CallbackResponse transferAsksWhetherToForceOperation(String irodsAbsolutePath, boolean isCollection) {
                    return TransferStatusCallbackListener.CallbackResponse.YES_THIS_FILE;
                }
            }, DefaultTransferControlBlock.instance((String)"", (int)PreferencesFactory.get().getInteger("connection.retry")));
            return target;
        }
        catch (JargonException e) {
            throw new IRODSExceptionMappingService().map("Cannot copy {0}", e, source);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }

    public boolean isSupported(Path source, Path target) {
        return true;
    }
}

