/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.valueeditors.integer;

import java.math.BigDecimal;
import org.apache.directory.studio.valueeditors.ValueEditorsActivator;
import org.apache.directory.studio.valueeditors.integer.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class IntegerDialog
extends Dialog {
    private BigDecimal initialValue;
    private BigDecimal value;
    private Text text;

    public IntegerDialog(Shell parentShell, BigDecimal initialValue) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        this.initialValue = initialValue;
        this.value = new BigDecimal(initialValue.toString());
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("IntegerDialog.IntegerEditor"));
        shell.setImage(ValueEditorsActivator.getDefault().getImage("resources/icons/integereditor.gif"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        Button minusButton = new Button(composite, 8);
        minusButton.setText("-");
        minusButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IntegerDialog.this.addToValue(-1);
                IntegerDialog.this.text.selectAll();
            }
        });
        this.text = new Text(composite, 2048);
        this.text.setLayoutData((Object)new GridData(768));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IntegerDialog.this.updateValueFromText();
            }
        });
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("(-)?([0-9])*")) {
                    e.doit = false;
                }
            }
        });
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000001) {
                    IntegerDialog.this.addToValue(1);
                    e.doit = false;
                    IntegerDialog.this.text.selectAll();
                } else if (e.keyCode == 0x1000002) {
                    IntegerDialog.this.addToValue(-1);
                    e.doit = false;
                    IntegerDialog.this.text.selectAll();
                } else if (e.keyCode == 0x1000005) {
                    IntegerDialog.this.addToValue(100);
                    e.doit = false;
                    IntegerDialog.this.text.selectAll();
                } else if (e.keyCode == 0x1000006) {
                    IntegerDialog.this.addToValue(-100);
                    e.doit = false;
                    IntegerDialog.this.text.selectAll();
                }
            }
        });
        Button plusButton = new Button(composite, 8);
        plusButton.setText("+");
        plusButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IntegerDialog.this.addToValue(1);
                IntegerDialog.this.text.selectAll();
            }
        });
        this.updateTextValue();
        this.text.setFocus();
        IntegerDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void updateTextValue() {
        this.text.setText(this.value.toString());
    }

    private void addToValue(int i) {
        this.value = this.value.add(new BigDecimal(i));
        this.updateTextValue();
    }

    private void updateValueFromText() {
        try {
            BigDecimal newValue;
            this.value = newValue = new BigDecimal(this.text.getText());
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public BigDecimal getInteger() {
        return this.value;
    }

    public boolean isDirty() {
        return !this.initialValue.equals(this.value);
    }
}

