/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.dialogs.properties;

import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.apache.directory.studio.ldapbrowser.ui.dialogs.properties.Messages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class ValuePropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Text descriptionText;
    private Text valueText;
    private Text typeText;
    private Text sizeText;

    protected Control createContents(Composite parent) {
        IValue value = ValuePropertyPage.getValue(this.getElement());
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)1, (int)1);
        Composite mainGroup = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)2, (int)1);
        BaseWidgetUtils.createLabel((Composite)mainGroup, (String)Messages.getString("ValuePropertyPage.AttributeDescription"), (int)1);
        this.descriptionText = BaseWidgetUtils.createLabeledText((Composite)mainGroup, (String)"", (int)1);
        BaseWidgetUtils.createLabel((Composite)mainGroup, (String)Messages.getString("ValuePropertyPage.ValueType"), (int)1);
        this.typeText = BaseWidgetUtils.createLabeledText((Composite)mainGroup, (String)"", (int)1);
        BaseWidgetUtils.createLabel((Composite)mainGroup, (String)Messages.getString("ValuePropertyPage.ValueSize"), (int)1);
        this.sizeText = BaseWidgetUtils.createLabeledText((Composite)mainGroup, (String)"", (int)1);
        BaseWidgetUtils.createLabel((Composite)mainGroup, (String)Messages.getString("ValuePropertyPage.Data"), (int)1);
        if (value != null && value.isString()) {
            this.valueText = new Text(mainGroup, 2826);
            this.valueText.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
            GridData gd = new GridData(1808);
            gd.widthHint = this.convertHorizontalDLUsToPixels(150);
            gd.heightHint = this.convertHorizontalDLUsToPixels(75);
            this.valueText.setLayoutData((Object)gd);
            this.valueText.setBackground(parent.getBackground());
        } else {
            this.valueText = BaseWidgetUtils.createLabeledText((Composite)mainGroup, (String)"", (int)1);
        }
        if (value != null) {
            int chars;
            super.setMessage(String.valueOf(Messages.getString("ValuePropertyPage.Value")) + org.apache.directory.studio.connection.core.Utils.shorten((String)value.toString(), (int)30));
            this.descriptionText.setText(value.getAttribute().getDescription());
            this.valueText.setText(value.isString() ? value.getStringValue() : Messages.getString("ValuePropertyPage.Binary"));
            this.typeText.setText(value.isString() ? Messages.getString("ValuePropertyPage.String") : Messages.getString("ValuePropertyPage.Binary"));
            int bytes = value.getBinaryValue().length;
            int n = chars = value.isString() ? value.getStringValue().length() : 0;
            String size = value.isString() ? String.valueOf(chars) + (chars > 1 ? Messages.getString("ValuePropertyPage.Characters") : Messages.getString("ValuePropertyPage.Character")) : "";
            size = String.valueOf(size) + Utils.formatBytes((long)bytes);
            this.sizeText.setText(size);
        }
        return parent;
    }

    private static IValue getValue(Object element) {
        IValue value = null;
        if (element instanceof IAdaptable) {
            value = (IValue)((IAdaptable)element).getAdapter(IValue.class);
        }
        return value;
    }
}

