/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.editor;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import org.apache.directory.api.ldap.model.csn.CsnFactory;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.FileUtils;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.config.ConfigWriter;
import org.apache.directory.server.core.api.DnFactory;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.partition.impl.btree.AbstractBTreePartition;
import org.apache.directory.server.core.partition.ldif.LdifPartition;
import org.apache.directory.server.core.partition.ldif.SingleFileLdifPartition;
import org.apache.directory.studio.apacheds.configuration.ApacheDS2ConfigurationPlugin;
import org.apache.directory.studio.apacheds.configuration.editor.Configuration;
import org.apache.directory.studio.apacheds.configuration.editor.ConnectionServerConfigurationInput;
import org.apache.directory.studio.apacheds.configuration.editor.Messages;
import org.apache.directory.studio.apacheds.configuration.jobs.EntryBasedConfigurationPartition;
import org.apache.directory.studio.apacheds.configuration.jobs.PartitionsDiffComputer;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.common.ui.CommonUIUtils;
import org.apache.directory.studio.common.ui.filesystem.PathEditorInput;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.jobs.ExecuteLdifRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;

public class ServerConfigurationEditorUtils {
    public static IEditorInput saveAs(IProgressMonitor monitor, Shell shell, IEditorInput input, ConfigWriter configWriter, Configuration configuration, boolean newInput) throws Exception {
        boolean isIDE = CommonUIUtils.isIDEEnvironment();
        if (isIDE) {
            SaveAsDialog dialog = new SaveAsDialog(shell);
            String inputClassName = input.getClass().getName();
            if (input instanceof FileEditorInput) {
                dialog.setOriginalFile(((FileEditorInput)input).getFile());
            } else if (input instanceof IPathEditorInput) {
                dialog.setOriginalFile(ResourcesPlugin.getWorkspace().getRoot().getFile(((IPathEditorInput)input).getPath()));
            } else if (inputClassName.equals("org.eclipse.ui.internal.editors.text.JavaFileEditorInput") || inputClassName.equals("org.eclipse.ui.ide.FileStoreEditorInput")) {
                dialog.setOriginalFile(ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(input.getToolTipText())));
            } else {
                dialog.setOriginalName("config.ldif");
            }
            if (ServerConfigurationEditorUtils.openDialogInUIThread((Dialog)dialog) != 0) {
                return null;
            }
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(dialog.getResult());
            if (!file.exists()) {
                file.create((InputStream)new ByteArrayInputStream("".getBytes()), true, null);
            }
            FileEditorInput fei = new FileEditorInput(file);
            File configFile = fei.getPath().toFile();
            ServerConfigurationEditorUtils.saveConfiguration(configFile, configWriter, configuration);
            return fei;
        }
        boolean canOverwrite = false;
        String path = null;
        block4: while (!canOverwrite) {
            path = ServerConfigurationEditorUtils.openFileDialogInUIThread(shell);
            if (path == null) {
                return null;
            }
            File externalFile = new File(path);
            if (externalFile.exists()) {
                String question = NLS.bind((String)Messages.getString("ServerConfigurationEditorUtils.TheFileAlreadyExistsWantToReplace"), (Object)path);
                MessageDialog overwriteDialog = new MessageDialog(shell, Messages.getString("ServerConfigurationEditorUtils.Question"), null, question, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                int overwrite = ServerConfigurationEditorUtils.openDialogInUIThread((Dialog)overwriteDialog);
                switch (overwrite) {
                    case 0: {
                        canOverwrite = true;
                        continue block4;
                    }
                    case 1: {
                        continue block4;
                    }
                    default: {
                        return null;
                    }
                }
            }
            canOverwrite = true;
        }
        ServerConfigurationEditorUtils.saveConfiguration(new File(path), configWriter, configuration);
        if (newInput) {
            return new PathEditorInput((IPath)new Path(path));
        }
        return null;
    }

    private static int openDialogInUIThread(Dialog dialog) {
        class DialogResult {
            private int result;

            DialogResult() {
            }

            public int getResult() {
                return this.result;
            }

            public void setResult(int result) {
                this.result = result;
            }
        }
        DialogResult result = new DialogResult();
        Display.getDefault().syncExec(() -> result.setResult(dialog.open()));
        return result.getResult();
    }

    private static String openFileDialogInUIThread(Shell shell) {
        class DialogResult {
            private String result;

            DialogResult() {
            }

            public String getResult() {
                return this.result;
            }

            public void setResult(String result) {
                this.result = result;
            }
        }
        DialogResult result = new DialogResult();
        Display.getDefault().syncExec(() -> {
            FileDialog dialog = new FileDialog(shell, 8192);
            result.setResult(dialog.open());
        });
        return result.getResult();
    }

    public static void saveConfiguration(ConnectionServerConfigurationInput input, ConfigWriter configWriter, IProgressMonitor monitor) throws Exception {
        EntryBasedConfigurationPartition originalPartition = input.getOriginalPartition();
        SchemaManager schemaManager = ApacheDS2ConfigurationPlugin.getDefault().getSchemaManager();
        EntryBasedConfigurationPartition newconfigurationPartition = new EntryBasedConfigurationPartition(schemaManager);
        newconfigurationPartition.initialize();
        List convertedLdifEntries = configWriter.getConvertedLdifEntries();
        for (LdifEntry ldifEntry : convertedLdifEntries) {
            newconfigurationPartition.addEntry((Entry)new DefaultEntry(schemaManager, ldifEntry.getEntry()));
        }
        ConnectionEventRegistry.suspendEventFiringInCurrentThread();
        try {
            PartitionsDiffComputer partitionsDiffComputer = new PartitionsDiffComputer();
            partitionsDiffComputer.setOriginalPartition((Partition)originalPartition);
            partitionsDiffComputer.setDestinationPartition((Partition)newconfigurationPartition);
            List<LdifEntry> modificationsList = partitionsDiffComputer.computeModifications(new String[]{"*"});
            StringBuilder modificationsLdif = new StringBuilder();
            for (LdifEntry ldifEntry : modificationsList) {
                modificationsLdif.append(ldifEntry.toString());
                modificationsLdif.append('\n');
            }
            IBrowserConnection browserConnection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnection(input.getConnection());
            StudioProgressMonitor studioProgressMonitor = new StudioProgressMonitor((IProgressMonitor)new NullProgressMonitor());
            ExecuteLdifRunnable.executeLdif((IBrowserConnection)browserConnection, (String)modificationsLdif.toString(), (boolean)true, (boolean)true, (StudioProgressMonitor)studioProgressMonitor);
            if (studioProgressMonitor.errorsReported()) {
                throw new Exception(Messages.getString("ServerConfigurationEditorUtils.ChangesCouldNotBeSavedToConnection"));
            }
            input.setOriginalPartition(newconfigurationPartition);
        }
        finally {
            ConnectionEventRegistry.resumeEventFiringInCurrentThread();
        }
    }

    public static void saveConfiguration(File file, ConfigWriter configWriter, Configuration configuration) throws Exception {
        SchemaManager schemaManager = ApacheDS2ConfigurationPlugin.getDefault().getSchemaManager();
        DnFactory dnFactory = null;
        CsnFactory csnFactory = new CsnFactory(0);
        if (file != null) {
            SingleFileLdifPartition configPartition;
            if (file.getName().equals("ou=config.ldif")) {
                File confDir = file.getParentFile();
                File ouConfigLdifFile = new File(confDir, "ou=config.ldif");
                File ouConfigDir = new File(confDir, "ou=config");
                if (ouConfigLdifFile.exists() && ouConfigDir.exists()) {
                    ouConfigLdifFile.delete();
                    FileUtils.deleteDirectory((File)ouConfigDir);
                }
                configPartition = ServerConfigurationEditorUtils.createMultiFileConfiguration(confDir, schemaManager, dnFactory);
            } else {
                if (file.exists()) {
                    file.delete();
                }
                configPartition = ServerConfigurationEditorUtils.createSingleFileConfiguration(file, schemaManager, dnFactory);
            }
            List convertedLdifEntries = configWriter.getConvertedLdifEntries();
            for (LdifEntry ldifEntry : convertedLdifEntries) {
                DefaultEntry entry = new DefaultEntry(schemaManager, ldifEntry.getEntry());
                if (entry.get("entryCSN") == null) {
                    entry.add("entryCSN", new String[]{csnFactory.newInstance().toString()});
                }
                if (entry.get("entryUUID") == null) {
                    String uuid = UUID.randomUUID().toString();
                    entry.add("entryUUID", new String[]{uuid});
                }
                configPartition.add(new AddOperationContext(null, (Entry)entry));
            }
        }
    }

    private static SingleFileLdifPartition createSingleFileConfiguration(File configFile, SchemaManager schemaManager, DnFactory dnFactory) throws Exception {
        SingleFileLdifPartition configPartition = new SingleFileLdifPartition(schemaManager, dnFactory);
        configPartition.setId("config");
        configPartition.setPartitionPath(configFile.toURI());
        configPartition.setSuffixDn(new Dn(schemaManager, new String[]{"ou=config"}));
        configPartition.setSchemaManager(schemaManager);
        configPartition.initialize();
        return configPartition;
    }

    private static LdifPartition createMultiFileConfiguration(File confDir, SchemaManager schemaManager, DnFactory dnFactory) throws Exception {
        LdifPartition configPartition = new LdifPartition(schemaManager, dnFactory);
        configPartition.setId("config");
        configPartition.setPartitionPath(confDir.toURI());
        configPartition.setSuffixDn(new Dn(schemaManager, new String[]{"ou=config"}));
        configPartition.setSchemaManager(schemaManager);
        configPartition.initialize();
        return configPartition;
    }

    private static List<LdifEntry> computeModifications(ConfigWriter configWriter, AbstractBTreePartition originalPartition) throws Exception {
        SchemaManager schemaManager = ApacheDS2ConfigurationPlugin.getDefault().getSchemaManager();
        EntryBasedConfigurationPartition newconfigurationPartition = new EntryBasedConfigurationPartition(schemaManager);
        newconfigurationPartition.initialize();
        List convertedLdifEntries = configWriter.getConvertedLdifEntries();
        for (LdifEntry ldifEntry : convertedLdifEntries) {
            newconfigurationPartition.addEntry((Entry)new DefaultEntry(schemaManager, ldifEntry.getEntry()));
        }
        PartitionsDiffComputer partitionsDiffComputer = new PartitionsDiffComputer();
        partitionsDiffComputer.setOriginalPartition((Partition)originalPartition);
        partitionsDiffComputer.setDestinationPartition((Partition)newconfigurationPartition);
        return partitionsDiffComputer.computeModifications(new String[]{"*"});
    }

    public static String checkNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public static String checkEmptyString(String s) {
        if (Strings.isEmpty((String)s)) {
            return null;
        }
        return s;
    }
}

