/*
 * Decompiled with CFR 0.152.
 */
package org.snakeyaml.engine.v2.common;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.snakeyaml.engine.v2.exceptions.EmitterException;

public class Anchor {
    private static final Set<Character> INVALID_ANCHOR = new HashSet<Character>();
    private static final Pattern SPACES_PATTERN = Pattern.compile("\\s");
    private final String value;

    public Anchor(String value2) {
        Objects.requireNonNull(value2);
        if (value2.isEmpty()) {
            throw new IllegalArgumentException("Empty anchor.");
        }
        for (int i2 = 0; i2 < value2.length(); ++i2) {
            char ch = value2.charAt(i2);
            if (!INVALID_ANCHOR.contains(Character.valueOf(ch))) continue;
            throw new EmitterException("Invalid character '" + ch + "' in the anchor: " + value2);
        }
        Matcher matcher = SPACES_PATTERN.matcher(value2);
        if (matcher.find()) {
            throw new EmitterException("Anchor may not contain spaces: " + value2);
        }
        this.value = value2;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Anchor anchor1 = (Anchor)o;
        return Objects.equals(this.value, anchor1.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    static {
        INVALID_ANCHOR.add(Character.valueOf('['));
        INVALID_ANCHOR.add(Character.valueOf(']'));
        INVALID_ANCHOR.add(Character.valueOf('{'));
        INVALID_ANCHOR.add(Character.valueOf('}'));
        INVALID_ANCHOR.add(Character.valueOf(','));
        INVALID_ANCHOR.add(Character.valueOf('*'));
        INVALID_ANCHOR.add(Character.valueOf('&'));
    }
}

