/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.calls.inference.CallHandle;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderImpl;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UtilsKt;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;

public class TypeIntersector {
    public static boolean isIntersectionEmpty(@NotNull KotlinType typeA, @NotNull KotlinType typeB) {
        if (typeA == null) {
            TypeIntersector.$$$reportNull$$$0(0);
        }
        if (typeB == null) {
            TypeIntersector.$$$reportNull$$$0(1);
        }
        return TypeIntersector.intersectTypes(new LinkedHashSet<KotlinType>(Arrays.asList(typeA, typeB))) == null;
    }

    @Nullable
    public static KotlinType intersectTypes(@NotNull Collection<KotlinType> types2) {
        if (types2 == null) {
            TypeIntersector.$$$reportNull$$$0(2);
        }
        assert (!types2.isEmpty()) : "Attempting to intersect empty collection of types, this case should be dealt with on the call site.";
        if (types2.size() == 1) {
            return types2.iterator().next();
        }
        KotlinType nothingOrNullableNothing = null;
        boolean allNullable = true;
        ArrayList<KotlinType> nullabilityStripped = new ArrayList<KotlinType>(types2.size());
        for (KotlinType type2 : types2) {
            if (KotlinTypeKt.isError(type2)) continue;
            if (KotlinBuiltIns.isNothingOrNullableNothing(type2)) {
                nothingOrNullableNothing = type2;
            }
            allNullable &= type2.isMarkedNullable();
            nullabilityStripped.add(TypeUtils.makeNotNullable(type2));
        }
        if (nothingOrNullableNothing != null) {
            return TypeUtils.makeNullableAsSpecified(nothingOrNullableNothing, allNullable);
        }
        if (nullabilityStripped.isEmpty()) {
            return ErrorUtils.createErrorType(ErrorTypeKind.INTERSECTION_OF_ERROR_TYPES, types2.toString());
        }
        KotlinTypeChecker typeChecker = KotlinTypeChecker.DEFAULT;
        ArrayList<KotlinType> resultingTypes = new ArrayList<KotlinType>();
        block1: for (KotlinType type3 : nullabilityStripped) {
            if (!TypeUtils.canHaveSubtypes(typeChecker, type3)) {
                boolean relativeToAll = true;
                for (KotlinType other : nullabilityStripped) {
                    boolean relative;
                    boolean mayBeEqual = TypeUnifier.mayBeEqual(type3, other);
                    boolean bl = relative = typeChecker.isSubtypeOf(type3, other) || typeChecker.isSubtypeOf(other, type3);
                    if (!mayBeEqual && !relative) {
                        return null;
                    }
                    if (relative) continue;
                    relativeToAll = false;
                    break;
                }
                if (relativeToAll) {
                    return TypeUtils.makeNullableAsSpecified(type3, allNullable);
                }
            }
            for (KotlinType other : nullabilityStripped) {
                if (type3.equals(other) || !typeChecker.isSubtypeOf(other, type3)) continue;
                continue block1;
            }
            for (KotlinType other : resultingTypes) {
                if (!typeChecker.equalTypes(other, type3)) continue;
                continue block1;
            }
            resultingTypes.add(type3);
        }
        if (resultingTypes.isEmpty()) {
            KotlinType bestRepresentative = FlexibleTypesKt.singleBestRepresentative(nullabilityStripped);
            if (bestRepresentative == null) {
                bestRepresentative = UtilsKt.hackForTypeIntersector(nullabilityStripped);
            }
            if (bestRepresentative == null) {
                return null;
            }
            return TypeUtils.makeNullableAsSpecified(bestRepresentative, allNullable);
        }
        if (resultingTypes.size() == 1) {
            return TypeUtils.makeNullableAsSpecified((KotlinType)resultingTypes.get(0), allNullable);
        }
        return new IntersectionTypeConstructor(resultingTypes).createType();
    }

    @NotNull
    public static KotlinType getUpperBoundsAsType(@NotNull TypeParameterDescriptor descriptor2) {
        if (descriptor2 == null) {
            TypeIntersector.$$$reportNull$$$0(3);
        }
        KotlinType kotlinType = TypeIntersector.intersectUpperBounds(descriptor2, descriptor2.getUpperBounds());
        if (kotlinType == null) {
            TypeIntersector.$$$reportNull$$$0(4);
        }
        return kotlinType;
    }

    public static KotlinType intersectUpperBounds(@NotNull TypeParameterDescriptor descriptor2, @NotNull List<KotlinType> upperBounds) {
        if (descriptor2 == null) {
            TypeIntersector.$$$reportNull$$$0(5);
        }
        if (upperBounds == null) {
            TypeIntersector.$$$reportNull$$$0(6);
        }
        assert (!upperBounds.isEmpty()) : "Upper bound list is empty: " + descriptor2;
        KotlinType upperBoundsAsType = TypeIntersector.intersectTypes(upperBounds);
        return upperBoundsAsType != null ? upperBoundsAsType : DescriptorUtilsKt.getBuiltIns(descriptor2).getNothingType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeA";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeB";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/types/TypeIntersector";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upperBounds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/types/TypeIntersector";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpperBoundsAsType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isIntersectionEmpty";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "intersectTypes";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUpperBoundsAsType";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "intersectUpperBounds";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TypeUnifier {
        private TypeUnifier() {
        }

        public static boolean mayBeEqual(@NotNull KotlinType type2, @NotNull KotlinType other) {
            if (type2 == null) {
                TypeUnifier.$$$reportNull$$$0(0);
            }
            if (other == null) {
                TypeUnifier.$$$reportNull$$$0(1);
            }
            return TypeUnifier.unify(type2, other);
        }

        private static boolean unify(KotlinType withParameters, KotlinType expected) {
            HashMap parameters = new HashMap();
            Function1<TypeParameterUsage, Unit> processor = parameterUsage -> {
                Variance howTheTypeIsUsedBefore = (Variance)((Object)((Object)parameters.get(((TypeParameterUsage)parameterUsage).typeParameterDescriptor)));
                if (howTheTypeIsUsedBefore == null) {
                    howTheTypeIsUsedBefore = Variance.INVARIANT;
                }
                parameters.put(((TypeParameterUsage)parameterUsage).typeParameterDescriptor, ((TypeParameterUsage)parameterUsage).howTheTypeParameterIsUsed.superpose(howTheTypeIsUsedBefore));
                return Unit.INSTANCE;
            };
            TypeUnifier.processAllTypeParameters(withParameters, Variance.INVARIANT, processor, parameters::containsKey);
            TypeUnifier.processAllTypeParameters(expected, Variance.INVARIANT, processor, parameters::containsKey);
            ConstraintSystemBuilderImpl constraintSystem = new ConstraintSystemBuilderImpl();
            TypeSubstitutor substitutor2 = constraintSystem.registerTypeVariables(CallHandle.NONE.INSTANCE, parameters.keySet(), false);
            constraintSystem.addSubtypeConstraint(withParameters, substitutor2.substitute(expected, Variance.INVARIANT), ConstraintPositionKind.SPECIAL.position());
            return constraintSystem.build().getStatus().isSuccessful();
        }

        private static void processAllTypeParameters(KotlinType type2, Variance howThisTypeIsUsed, Function1<TypeParameterUsage, Unit> result2, Function1<TypeParameterDescriptor, Boolean> containsParameter) {
            ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
            if (descriptor2 instanceof TypeParameterDescriptor) {
                if (containsParameter.invoke((TypeParameterDescriptor)descriptor2).booleanValue()) {
                    return;
                }
                result2.invoke(new TypeParameterUsage((TypeParameterDescriptor)descriptor2, howThisTypeIsUsed));
                for (KotlinType superType : type2.getConstructor().getSupertypes()) {
                    TypeUnifier.processAllTypeParameters(superType, howThisTypeIsUsed, result2, containsParameter);
                }
            }
            for (TypeProjection projection : type2.getArguments()) {
                if (projection.isStarProjection()) continue;
                TypeUnifier.processAllTypeParameters(projection.getType(), projection.getProjectionKind(), result2, containsParameter);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "other";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/types/TypeIntersector$TypeUnifier";
            objectArray[2] = "mayBeEqual";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class TypeParameterUsage {
            private final TypeParameterDescriptor typeParameterDescriptor;
            private final Variance howTheTypeParameterIsUsed;

            public TypeParameterUsage(TypeParameterDescriptor typeParameterDescriptor, Variance howTheTypeParameterIsUsed) {
                this.typeParameterDescriptor = typeParameterDescriptor;
                this.howTheTypeParameterIsUsed = howTheTypeParameterIsUsed;
            }
        }
    }
}

