/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubInputStream;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubOutputStream;
import org.jetbrains.kotlin.com.intellij.util.io.StringRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassLikeDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.stubs.KotlinClassifierStub;
import org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.kotlin.psi.stubs.KotlinScriptStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u0007J\u001e\u0010\f\u001a\u0004\u0018\u00010\u00052\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/StubUtils;", "", "<init>", "()V", "deserializeClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "dataStream", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/StubInputStream;", "serializeClassId", "", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/StubOutputStream;", "classId", "createNestedClassId", "parentStub", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/StubElement;", "currentDeclaration", "Lorg/jetbrains/kotlin/psi/KtClassLikeDeclaration;", "psi"})
public final class StubUtils {
    @NotNull
    public static final StubUtils INSTANCE = new StubUtils();

    private StubUtils() {
    }

    @JvmStatic
    @Nullable
    public static final ClassId deserializeClassId(@NotNull StubInputStream dataStream) {
        Intrinsics.checkNotNullParameter(dataStream, "dataStream");
        StringRef stringRef = dataStream.readName();
        if (stringRef == null) {
            return null;
        }
        StringRef classId = stringRef;
        String string2 = classId.getString();
        Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
        return ClassId.Companion.fromString$default(ClassId.Companion, string2, false, 2, null);
    }

    @JvmStatic
    public static final void serializeClassId(@NotNull StubOutputStream dataStream, @Nullable ClassId classId) {
        Intrinsics.checkNotNullParameter(dataStream, "dataStream");
        ClassId classId2 = classId;
        dataStream.writeName(classId2 != null ? classId2.asString() : null);
    }

    @JvmStatic
    @Nullable
    public static final ClassId createNestedClassId(@NotNull StubElement<?> parentStub, @NotNull KtClassLikeDeclaration currentDeclaration) {
        ClassId classId;
        Intrinsics.checkNotNullParameter(parentStub, "parentStub");
        Intrinsics.checkNotNullParameter(currentDeclaration, "currentDeclaration");
        if (parentStub instanceof KotlinFileStub) {
            FqName fqName = ((KotlinFileStub)parentStub).getPackageFqName();
            Name name2 = currentDeclaration.getNameAsSafeName();
            Intrinsics.checkNotNullExpressionValue(name2, "getNameAsSafeName(...)");
            classId = new ClassId(fqName, name2);
        } else if (parentStub instanceof KotlinScriptStub) {
            StubElement stubElement = ((KotlinScriptStub)parentStub).getParentStub();
            Intrinsics.checkNotNullExpressionValue(stubElement, "getParentStub(...)");
            classId = StubUtils.createNestedClassId(stubElement, currentDeclaration);
        } else if (parentStub instanceof KotlinPlaceHolderStub && Intrinsics.areEqual(((KotlinPlaceHolderStub)parentStub).getStubType(), KtStubElementTypes.CLASS_BODY)) {
            KotlinClassifierStub containingClassStub;
            StubElement stubElement = ((KotlinPlaceHolderStub)parentStub).getParentStub();
            KotlinClassifierStub kotlinClassifierStub = containingClassStub = stubElement instanceof KotlinClassifierStub ? (KotlinClassifierStub)((Object)stubElement) : null;
            if (containingClassStub != null && !(currentDeclaration instanceof KtEnumEntry)) {
                ClassId classId2 = containingClassStub.getClassId();
                if (classId2 != null) {
                    Name name3 = currentDeclaration.getNameAsSafeName();
                    Intrinsics.checkNotNullExpressionValue(name3, "getNameAsSafeName(...)");
                    classId = classId2.createNestedClassId(name3);
                } else {
                    classId = null;
                }
            } else {
                classId = null;
            }
        } else {
            classId = null;
        }
        return classId;
    }
}

