/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.protobuf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.kotlin.protobuf.AbstractMessageLite;
import org.jetbrains.kotlin.protobuf.ByteString;
import org.jetbrains.kotlin.protobuf.CodedInputStream;
import org.jetbrains.kotlin.protobuf.CodedOutputStream;
import org.jetbrains.kotlin.protobuf.Descriptors;
import org.jetbrains.kotlin.protobuf.ExtensionRegistry;
import org.jetbrains.kotlin.protobuf.ExtensionRegistryLite;
import org.jetbrains.kotlin.protobuf.Internal;
import org.jetbrains.kotlin.protobuf.InvalidProtocolBufferException;
import org.jetbrains.kotlin.protobuf.Message;
import org.jetbrains.kotlin.protobuf.MessageReflection;
import org.jetbrains.kotlin.protobuf.TextFormat;
import org.jetbrains.kotlin.protobuf.UninitializedMessageException;
import org.jetbrains.kotlin.protobuf.UnknownFieldSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessage
extends AbstractMessageLite
implements Message {
    private int memoizedSize = -1;

    @Override
    public boolean isInitialized() {
        return MessageReflection.isInitialized(this);
    }

    @Override
    public List<String> findInitializationErrors() {
        return MessageReflection.findMissingFields(this);
    }

    @Override
    public String getInitializationErrorString() {
        return MessageReflection.delimitWithCommas(this.findInitializationErrors());
    }

    @Override
    public boolean hasOneof(Descriptors.OneofDescriptor oneof) {
        throw new UnsupportedOperationException("hasOneof() is not implemented.");
    }

    @Override
    public Descriptors.FieldDescriptor getOneofFieldDescriptor(Descriptors.OneofDescriptor oneof) {
        throw new UnsupportedOperationException("getOneofFieldDescriptor() is not implemented.");
    }

    @Override
    public final String toString() {
        return TextFormat.printToString(this);
    }

    @Override
    public void writeTo(CodedOutputStream output2) throws IOException {
        MessageReflection.writeMessageTo(this, output2, false);
    }

    @Override
    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        this.memoizedSize = MessageReflection.getSerializedSize(this);
        return this.memoizedSize;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Message)) {
            return false;
        }
        Message otherMessage = (Message)other;
        if (this.getDescriptorForType() != otherMessage.getDescriptorForType()) {
            return false;
        }
        return AbstractMessage.compareFields(this.getAllFields(), otherMessage.getAllFields()) && this.getUnknownFields().equals(otherMessage.getUnknownFields());
    }

    @Override
    public int hashCode() {
        int hash = this.memoizedHashCode;
        if (hash == 0) {
            hash = 41;
            hash = 19 * hash + this.getDescriptorForType().hashCode();
            hash = AbstractMessage.hashFields(hash, this.getAllFields());
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        }
        return hash;
    }

    private static ByteString toByteString(Object value2) {
        if (value2 instanceof byte[]) {
            return ByteString.copyFrom((byte[])value2);
        }
        return (ByteString)value2;
    }

    private static boolean compareBytes(Object a2, Object b2) {
        if (a2 instanceof byte[] && b2 instanceof byte[]) {
            return Arrays.equals((byte[])a2, (byte[])b2);
        }
        return AbstractMessage.toByteString(a2).equals(AbstractMessage.toByteString(b2));
    }

    static boolean compareFields(Map<Descriptors.FieldDescriptor, Object> a2, Map<Descriptors.FieldDescriptor, Object> b2) {
        if (a2.size() != b2.size()) {
            return false;
        }
        for (Descriptors.FieldDescriptor descriptor2 : a2.keySet()) {
            if (!b2.containsKey(descriptor2)) {
                return false;
            }
            Object value1 = a2.get(descriptor2);
            Object value2 = b2.get(descriptor2);
            if (descriptor2.getType() == Descriptors.FieldDescriptor.Type.BYTES) {
                if (descriptor2.isRepeated()) {
                    List list1 = (List)value1;
                    List list2 = (List)value2;
                    if (list1.size() != list2.size()) {
                        return false;
                    }
                    for (int i2 = 0; i2 < list1.size(); ++i2) {
                        if (AbstractMessage.compareBytes(list1.get(i2), list2.get(i2))) continue;
                        return false;
                    }
                    continue;
                }
                if (AbstractMessage.compareBytes(value1, value2)) continue;
                return false;
            }
            if (value1.equals(value2)) continue;
            return false;
        }
        return true;
    }

    protected static int hashFields(int hash, Map<Descriptors.FieldDescriptor, Object> map2) {
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : map2.entrySet()) {
            Descriptors.FieldDescriptor field = entry.getKey();
            Object value2 = entry.getValue();
            hash = 37 * hash + field.getNumber();
            if (field.getType() != Descriptors.FieldDescriptor.Type.ENUM) {
                hash = 53 * hash + value2.hashCode();
                continue;
            }
            if (field.isRepeated()) {
                List list = (List)value2;
                hash = 53 * hash + Internal.hashEnumList(list);
                continue;
            }
            hash = 53 * hash + Internal.hashEnum((Internal.EnumLite)value2);
        }
        return hash;
    }

    @Override
    UninitializedMessageException newUninitializedMessageException() {
        return Builder.newUninitializedMessageException(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Builder<BuilderType extends Builder>
    extends AbstractMessageLite.Builder<BuilderType>
    implements Message.Builder {
        @Override
        public abstract BuilderType clone();

        @Override
        public boolean hasOneof(Descriptors.OneofDescriptor oneof) {
            throw new UnsupportedOperationException("hasOneof() is not implemented.");
        }

        @Override
        public Descriptors.FieldDescriptor getOneofFieldDescriptor(Descriptors.OneofDescriptor oneof) {
            throw new UnsupportedOperationException("getOneofFieldDescriptor() is not implemented.");
        }

        public BuilderType clearOneof(Descriptors.OneofDescriptor oneof) {
            throw new UnsupportedOperationException("clearOneof() is not implemented.");
        }

        public BuilderType clear() {
            for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : this.getAllFields().entrySet()) {
                this.clearField(entry.getKey());
            }
            return (BuilderType)this;
        }

        @Override
        public List<String> findInitializationErrors() {
            return MessageReflection.findMissingFields(this);
        }

        @Override
        public String getInitializationErrorString() {
            return MessageReflection.delimitWithCommas(this.findInitializationErrors());
        }

        public BuilderType mergeFrom(Message other) {
            if (other.getDescriptorForType() != this.getDescriptorForType()) {
                throw new IllegalArgumentException("mergeFrom(Message) can only merge messages of the same type.");
            }
            for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : other.getAllFields().entrySet()) {
                Descriptors.FieldDescriptor field = entry.getKey();
                if (field.isRepeated()) {
                    for (Object element : (List)entry.getValue()) {
                        this.addRepeatedField(field, element);
                    }
                    continue;
                }
                if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                    Message existingValue = (Message)this.getField(field);
                    if (existingValue == existingValue.getDefaultInstanceForType()) {
                        this.setField(field, entry.getValue());
                        continue;
                    }
                    this.setField(field, existingValue.newBuilderForType().mergeFrom(existingValue).mergeFrom((Message)entry.getValue()).build());
                    continue;
                }
                this.setField(field, entry.getValue());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            return (BuilderType)this;
        }

        @Override
        public BuilderType mergeFrom(CodedInputStream input2) throws IOException {
            return (BuilderType)this.mergeFrom(input2, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        }

        @Override
        public BuilderType mergeFrom(CodedInputStream input2, ExtensionRegistryLite extensionRegistry) throws IOException {
            int tag;
            UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder(this.getUnknownFields());
            while ((tag = input2.readTag()) != 0) {
                MessageReflection.BuilderAdapter builderAdapter = new MessageReflection.BuilderAdapter(this);
                if (MessageReflection.mergeFieldFrom(input2, unknownFields, extensionRegistry, this.getDescriptorForType(), builderAdapter, tag)) continue;
                break;
            }
            this.setUnknownFields(unknownFields.build());
            return (BuilderType)this;
        }

        public BuilderType mergeUnknownFields(UnknownFieldSet unknownFields) {
            this.setUnknownFields(UnknownFieldSet.newBuilder(this.getUnknownFields()).mergeFrom(unknownFields).build());
            return (BuilderType)this;
        }

        @Override
        public Message.Builder getFieldBuilder(Descriptors.FieldDescriptor field) {
            throw new UnsupportedOperationException("getFieldBuilder() called on an unsupported message type.");
        }

        public String toString() {
            return TextFormat.printToString(this);
        }

        protected static UninitializedMessageException newUninitializedMessageException(Message message) {
            return new UninitializedMessageException(MessageReflection.findMissingFields(message));
        }

        @Override
        public BuilderType mergeFrom(ByteString data) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(data));
        }

        @Override
        public BuilderType mergeFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(data, extensionRegistry));
        }

        @Override
        public BuilderType mergeFrom(byte[] data) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(data));
        }

        @Override
        public BuilderType mergeFrom(byte[] data, int off, int len) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(data, off, len));
        }

        @Override
        public BuilderType mergeFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(data, extensionRegistry));
        }

        @Override
        public BuilderType mergeFrom(byte[] data, int off, int len, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(data, off, len, extensionRegistry));
        }

        @Override
        public BuilderType mergeFrom(InputStream input2) throws IOException {
            return (BuilderType)((Builder)super.mergeFrom(input2));
        }

        @Override
        public BuilderType mergeFrom(InputStream input2, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (BuilderType)((Builder)super.mergeFrom(input2, extensionRegistry));
        }

        @Override
        public boolean mergeDelimitedFrom(InputStream input2) throws IOException {
            return super.mergeDelimitedFrom(input2);
        }

        @Override
        public boolean mergeDelimitedFrom(InputStream input2, ExtensionRegistryLite extensionRegistry) throws IOException {
            return super.mergeDelimitedFrom(input2, extensionRegistry);
        }
    }
}

