/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jline.builtins;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.org.jline.builtins.ConsoleOptionGetter;

public class Styles {
    protected static final List<String> ANSI_STYLES = Arrays.asList("blink", "bold", "conceal", "crossed-out", "crossedout", "faint", "hidden", "inverse", "inverse-neg", "inverseneg", "italic", "underline");
    private static final Pattern STYLE_ELEMENT_SEPARATOR = Pattern.compile(":");
    private static final Pattern STYLE_ELEMENT_PATTERN = Pattern.compile("([a-z]{2}|\\*\\.[a-zA-Z0-9]+)=(([!~#]?[a-zA-Z0-9]+[a-z0-9-;]*)?|[A-Z_]+)(,(([!~#]?[a-zA-Z0-9]+[a-z0-9-;]*)?|[A-Z_]+))*");

    private static ConsoleOptionGetter optionGetter() {
        try {
            return (ConsoleOptionGetter)Class.forName("org.jetbrains.kotlin.org.jline.console.SystemRegistry").getDeclaredMethod("get", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static <T> T consoleOption(String name2, T defVal) {
        T out = defVal;
        ConsoleOptionGetter cog = Styles.optionGetter();
        if (cog != null) {
            out = cog.consoleOption(name2, defVal);
        }
        return out;
    }

    public static class StyleCompiler {
        private static final List<String> COLORS_8 = Arrays.asList("white", "black", "red", "blue", "green", "yellow", "magenta", "cyan");
        private static final Map<String, Integer> COLORS_NANO = new HashMap<String, Integer>();
        private final Map<String, String> colors;
        private final Map<String, String> tokenColors;
        private final boolean nanoStyle;

        public StyleCompiler(Map<String, String> colors, boolean nanoStyle) {
            this.colors = colors;
            this.nanoStyle = nanoStyle;
            this.tokenColors = (Map)Styles.consoleOption("NANORC_THEME", new HashMap());
        }

        public String getStyle(String reference2) {
            String rawStyle = this.colors.get(reference2);
            if (rawStyle == null) {
                return null;
            }
            if (rawStyle.matches("[A-Z_]+")) {
                rawStyle = this.tokenColors.getOrDefault(rawStyle, "normal");
            } else if (!this.nanoStyle && rawStyle.matches("[0-9]*(;[0-9]+){0,2}")) {
                return rawStyle;
            }
            StringBuilder out = new StringBuilder();
            boolean first2 = true;
            boolean fg = true;
            for (String s : rawStyle.split(",")) {
                if (s.trim().isEmpty()) {
                    fg = false;
                    continue;
                }
                if (!first2) {
                    out.append(",");
                }
                if (ANSI_STYLES.contains(s)) {
                    out.append(s);
                } else if (COLORS_8.contains(s) || COLORS_NANO.containsKey(s) || s.startsWith("light") || s.startsWith("bright") || s.startsWith("~") || s.startsWith("!") || s.matches("\\d+") || s.matches("[#x][0-9a-fA-F]{6}") || s.equals("normal") || s.equals("default")) {
                    if (s.matches("[#x][0-9a-fA-F]{6}")) {
                        if (fg) {
                            out.append("fg-rgb:");
                        } else {
                            out.append("bg-rgb:");
                        }
                        out.append(s);
                    } else if (s.matches("\\d+") || COLORS_NANO.containsKey(s)) {
                        if (fg) {
                            out.append("38;5;");
                        } else {
                            out.append("48;5;");
                        }
                        out.append(s.matches("\\d+") ? s : COLORS_NANO.get(s).toString());
                    } else {
                        if (fg) {
                            out.append("fg:");
                        } else {
                            out.append("bg:");
                        }
                        if (COLORS_8.contains(s) || s.startsWith("~") || s.startsWith("!") || s.startsWith("bright-")) {
                            out.append(s);
                        } else if (s.startsWith("light")) {
                            out.append("!").append(s.substring(5));
                        } else if (s.startsWith("bright")) {
                            out.append("!").append(s.substring(6));
                        } else {
                            out.append("default");
                        }
                    }
                    fg = false;
                }
                first2 = false;
            }
            return out.toString();
        }

        static {
            COLORS_NANO.put("pink", 204);
            COLORS_NANO.put("purple", 163);
            COLORS_NANO.put("mauve", 134);
            COLORS_NANO.put("lagoon", 38);
            COLORS_NANO.put("mint", 48);
            COLORS_NANO.put("lime", 148);
            COLORS_NANO.put("peach", 215);
            COLORS_NANO.put("orange", 208);
            COLORS_NANO.put("latte", 137);
        }
    }
}

