/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.impl;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.library.MetadataKotlinLibraryLayout;
import org.jetbrains.kotlin.library.MetadataWriter;
import org.jetbrains.kotlin.library.SerializedMetadata;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/library/impl/MetadataWriterImpl;", "Lorg/jetbrains/kotlin/library/MetadataWriter;", "metadataLayout", "Lorg/jetbrains/kotlin/library/MetadataKotlinLibraryLayout;", "(Lorg/jetbrains/kotlin/library/MetadataKotlinLibraryLayout;)V", "getMetadataLayout", "()Lorg/jetbrains/kotlin/library/MetadataKotlinLibraryLayout;", "addMetadata", "", "metadata", "Lorg/jetbrains/kotlin/library/SerializedMetadata;", "kotlin-util-klib"})
@SourceDebugExtension(value={"SMAP\nMetadataWriterImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetadataWriterImpl.kt\norg/jetbrains/kotlin/library/impl/MetadataWriterImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,34:1\n1872#2,3:35\n*S KotlinDebug\n*F\n+ 1 MetadataWriterImpl.kt\norg/jetbrains/kotlin/library/impl/MetadataWriterImpl\n*L\n19#1:35,3\n*E\n"})
public final class MetadataWriterImpl
implements MetadataWriter {
    @NotNull
    private final MetadataKotlinLibraryLayout metadataLayout;

    public MetadataWriterImpl(@NotNull MetadataKotlinLibraryLayout metadataLayout) {
        Intrinsics.checkNotNullParameter(metadataLayout, "metadataLayout");
        this.metadataLayout = metadataLayout;
        this.metadataLayout.getMetadataDir().mkdirs();
    }

    @NotNull
    public final MetadataKotlinLibraryLayout getMetadataLayout() {
        return this.metadataLayout;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addMetadata(@NotNull SerializedMetadata metadata) {
        Intrinsics.checkNotNullParameter(metadata, "metadata");
        this.metadataLayout.getModuleHeaderFile().writeBytes(metadata.getModule());
        Iterable $this$forEachIndexed$iv = metadata.getFragments();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv;
            int index = n;
            boolean bl = false;
            String packageFqName = metadata.getFragmentNames().get(index);
            String shortName = StringsKt.substringAfterLast$default(packageFqName, ".", null, 2, null);
            File dir2 = this.metadataLayout.packageFragmentsDir(packageFqName);
            dir2.deleteRecursively();
            dir2.mkdirs();
            int numCount = String.valueOf(it.size()).length();
            Iterator iterator2 = ((Iterable)it).iterator();
            int n2 = 0;
            while (iterator2.hasNext()) {
                int i2 = n2++;
                byte[] fragment = (byte[])iterator2.next();
                this.metadataLayout.packageFragmentFile(packageFqName, MetadataWriterImpl.addMetadata$lambda$0$withLeadingZeros(numCount, i2) + '_' + shortName).writeBytes(fragment);
            }
        }
    }

    private static final String addMetadata$lambda$0$withLeadingZeros(int numCount, int i2) {
        String string2 = "%0" + numCount + 'd';
        Object[] objectArray = new Object[]{i2};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
        return string3;
    }
}

